/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.MetricsHubConstants;
import org.sentrysoftware.metricshub.engine.connector.model.common.EmbeddedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedFileHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedFileHelper.class);

    public static Map<Integer, EmbeddedFile> findEmbeddedFiles(@NonNull String value, @NonNull Map<Integer, EmbeddedFile> connectorEmbeddedFiles) {
        if (value == null) {
            throw new IllegalArgumentException("value is marked non-null but is null");
        }
        if (connectorEmbeddedFiles == null) {
            throw new IllegalArgumentException("connectorEmbeddedFiles is marked non-null but is null");
        }
        HashMap<Integer, EmbeddedFile> embeddedFiles = new HashMap<Integer, EmbeddedFile>();
        ArrayList<Integer> alreadyProcessedFiles = new ArrayList<Integer>();
        Matcher fileMatcher = MetricsHubConstants.FILE_PATTERN.matcher(value);
        while (fileMatcher.find()) {
            Integer fileNumber = Integer.parseInt(fileMatcher.group(1));
            if (alreadyProcessedFiles.contains(fileNumber)) continue;
            embeddedFiles.put(fileNumber, connectorEmbeddedFiles.get(fileNumber));
            alreadyProcessedFiles.add(fileNumber);
        }
        return embeddedFiles;
    }

    public static Optional<EmbeddedFile> findEmbeddedFile(@NonNull String value, @NonNull Map<Integer, EmbeddedFile> connectorEmbeddedFiles, @NonNull String hostname, @NonNull String connectorId) {
        if (value == null) {
            throw new IllegalArgumentException("value is marked non-null but is null");
        }
        if (connectorEmbeddedFiles == null) {
            throw new IllegalArgumentException("connectorEmbeddedFiles is marked non-null but is null");
        }
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (connectorId == null) {
            throw new IllegalArgumentException("connectorId is marked non-null but is null");
        }
        Map<Integer, EmbeddedFile> embeddedFiles = EmbeddedFileHelper.findEmbeddedFiles(value, connectorEmbeddedFiles);
        if (embeddedFiles.size() > 1) {
            String message = String.format("Hostname %s - Many embedded files are referenced in value: %s. Expected 1 embedded file reference. Connector: %s.", hostname, value, connectorId);
            log.error(message);
            throw new IllegalStateException(message);
        }
        return embeddedFiles.entrySet().stream().map(Map.Entry::getValue).findFirst();
    }

    @Generated
    private EmbeddedFileHelper() {
    }
}

