/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.utils;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.exception.RetryableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryOperation<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryOperation.class);
    private long waitStrategy;
    private T defaultValue;
    private int maxRetries;
    @NonNull
    private String hostname;
    @NonNull
    private String description;

    public T run(Supplier<T> function) {
        try {
            return function.get();
        }
        catch (RetryableException e) {
            if (this.maxRetries <= 0) {
                log.info("Hostname {} - {} failed and will not be retried.", (Object)this.hostname, (Object)this.description);
                return this.defaultValue;
            }
            return this.retry(function);
        }
    }

    private T retry(Supplier<T> function) {
        log.info("Hostname {} - {} failed and will be retried {} time{}.", new Object[]{this.hostname, this.description, this.maxRetries, this.maxRetries == 1 ? "" : "s"});
        int retryCounter = 0;
        while (retryCounter < this.maxRetries) {
            try {
                if (this.waitStrategy > 0L) {
                    log.info("Hostname {} - {} retry will be performed after {} seconds.", new Object[]{this.hostname, this.description, this.waitStrategy});
                    this.pauseRetry();
                }
                return function.get();
            }
            catch (RetryableException ex) {
                log.info("Hostname {} - {} failed on retry {} / {}.", new Object[]{this.hostname, this.description, ++retryCounter, this.maxRetries});
                if (retryCounter < this.maxRetries) continue;
                log.warn("Hostname {} - Max retries exceeded for {}.", (Object)this.hostname, (Object)this.description);
                break;
            }
        }
        return this.defaultValue;
    }

    private void pauseRetry() {
        try {
            TimeUnit.SECONDS.sleep(this.waitStrategy);
        }
        catch (InterruptedException e) {
            log.warn("Hostname {} - {} retry interrupted while sleeping.", (Object)this.hostname, (Object)this.description);
            log.debug(String.format("Hostname %s - %s retry interrupted while sleeping. Exception: ", this.hostname, this.description), (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Generated
    private static <T> long $default$waitStrategy() {
        return 0L;
    }

    @Generated
    private static <T> int $default$maxRetries() {
        return 1;
    }

    @Generated
    public static <T> RetryOperationBuilder<T> builder() {
        return new RetryOperationBuilder();
    }

    @Generated
    public RetryOperation(long waitStrategy, T defaultValue, int maxRetries, @NonNull String hostname, @NonNull String description) {
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (description == null) {
            throw new IllegalArgumentException("description is marked non-null but is null");
        }
        this.waitStrategy = waitStrategy;
        this.defaultValue = defaultValue;
        this.maxRetries = maxRetries;
        this.hostname = hostname;
        this.description = description;
    }

    @Generated
    public static class RetryOperationBuilder<T> {
        @Generated
        private boolean waitStrategy$set;
        @Generated
        private long waitStrategy$value;
        @Generated
        private T defaultValue;
        @Generated
        private boolean maxRetries$set;
        @Generated
        private int maxRetries$value;
        @Generated
        private String hostname;
        @Generated
        private String description;

        @Generated
        RetryOperationBuilder() {
        }

        @Generated
        public RetryOperationBuilder<T> withWaitStrategy(long waitStrategy) {
            this.waitStrategy$value = waitStrategy;
            this.waitStrategy$set = true;
            return this;
        }

        @Generated
        public RetryOperationBuilder<T> withDefaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Generated
        public RetryOperationBuilder<T> withMaxRetries(int maxRetries) {
            this.maxRetries$value = maxRetries;
            this.maxRetries$set = true;
            return this;
        }

        @Generated
        public RetryOperationBuilder<T> withHostname(@NonNull String hostname) {
            if (hostname == null) {
                throw new IllegalArgumentException("hostname is marked non-null but is null");
            }
            this.hostname = hostname;
            return this;
        }

        @Generated
        public RetryOperationBuilder<T> withDescription(@NonNull String description) {
            if (description == null) {
                throw new IllegalArgumentException("description is marked non-null but is null");
            }
            this.description = description;
            return this;
        }

        @Generated
        public RetryOperation<T> build() {
            long waitStrategy$value = this.waitStrategy$value;
            if (!this.waitStrategy$set) {
                waitStrategy$value = RetryOperation.$default$waitStrategy();
            }
            int maxRetries$value = this.maxRetries$value;
            if (!this.maxRetries$set) {
                maxRetries$value = RetryOperation.$default$maxRetries();
            }
            return new RetryOperation<T>(waitStrategy$value, this.defaultValue, maxRetries$value, this.hostname, this.description);
        }

        @Generated
        public String toString() {
            return "RetryOperation.RetryOperationBuilder(waitStrategy$value=" + this.waitStrategy$value + ", defaultValue=" + String.valueOf(this.defaultValue) + ", maxRetries$value=" + this.maxRetries$value + ", hostname=" + this.hostname + ", description=" + this.description + ")";
        }
    }
}

