/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.telemetry;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;

public class SshSemaphoreFactory {
    private static final int MAX_PERMITS = 8;
    private static final SshSemaphoreFactory INSTANCE = new SshSemaphoreFactory();
    private final Map<String, Semaphore> sshSemaphores = new HashMap<String, Semaphore>();

    public synchronized Semaphore createOrGetSempahore(String hostname) {
        this.sshSemaphores.putIfAbsent(hostname, new Semaphore(8));
        return this.sshSemaphores.get(hostname);
    }

    public static SshSemaphoreFactory getInstance() {
        return INSTANCE;
    }

    public void deleteSemaphore(String hostname) {
        this.sshSemaphores.remove(hostname);
    }
}

