/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.telemetry.metric;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.telemetry.metric.NumberMetric;
import org.sentrysoftware.metricshub.engine.telemetry.metric.StateSetMetric;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=StateSetMetric.class, name="StateSetMetric"), @JsonSubTypes.Type(value=NumberMetric.class, name="NumberMetric")})
public abstract class AbstractMetric {
    private String name;
    private Long collectTime;
    private Long previousCollectTime;
    private Map<String, String> attributes = new HashMap<String, String>();
    private boolean resetMetricTime;

    AbstractMetric(String name, Long collectTime, Map<String, String> attributes) {
        this.name = name;
        this.collectTime = collectTime;
        this.attributes = attributes == null ? new HashMap() : attributes;
    }

    public void save() {
        this.previousCollectTime = this.collectTime;
    }

    public boolean isUpdated() {
        if (this.collectTime == null) {
            return false;
        }
        return !this.collectTime.equals(this.previousCollectTime);
    }

    public abstract String getType();

    public abstract <T> T getValue();

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Long getCollectTime() {
        return this.collectTime;
    }

    @Generated
    public Long getPreviousCollectTime() {
        return this.previousCollectTime;
    }

    @Generated
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public boolean isResetMetricTime() {
        return this.resetMetricTime;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setCollectTime(Long collectTime) {
        this.collectTime = collectTime;
    }

    @Generated
    public void setPreviousCollectTime(Long previousCollectTime) {
        this.previousCollectTime = previousCollectTime;
    }

    @Generated
    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setResetMetricTime(boolean resetMetricTime) {
        this.resetMetricTime = resetMetricTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractMetric)) {
            return false;
        }
        AbstractMetric other = (AbstractMetric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isResetMetricTime() != other.isResetMetricTime()) {
            return false;
        }
        Long this$collectTime = this.getCollectTime();
        Long other$collectTime = other.getCollectTime();
        if (this$collectTime == null ? other$collectTime != null : !((Object)this$collectTime).equals(other$collectTime)) {
            return false;
        }
        Long this$previousCollectTime = this.getPreviousCollectTime();
        Long other$previousCollectTime = other.getPreviousCollectTime();
        if (this$previousCollectTime == null ? other$previousCollectTime != null : !((Object)this$previousCollectTime).equals(other$previousCollectTime)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractMetric;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isResetMetricTime() ? 79 : 97);
        Long $collectTime = this.getCollectTime();
        result = result * 59 + ($collectTime == null ? 43 : ((Object)$collectTime).hashCode());
        Long $previousCollectTime = this.getPreviousCollectTime();
        result = result * 59 + ($previousCollectTime == null ? 43 : ((Object)$previousCollectTime).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbstractMetric(name=" + this.getName() + ", collectTime=" + this.getCollectTime() + ", previousCollectTime=" + this.getPreviousCollectTime() + ", attributes=" + String.valueOf(this.getAttributes()) + ", resetMetricTime=" + this.isResetMetricTime() + ")";
    }

    @Generated
    public AbstractMetric() {
    }
}

