/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.xflat;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sentrysoftware.xflat.Utils;
import org.sentrysoftware.xflat.exceptions.XFlatException;
import org.sentrysoftware.xflat.handlers.ResultHandler;
import org.sentrysoftware.xflat.handlers.SearchPathTreeHandler;
import org.sentrysoftware.xflat.handlers.XmlHandler;
import org.sentrysoftware.xflat.types.SearchPathNode;

public class XFlat {
    private XFlat() {
    }

    public static List<List<String>> parseXml(String xml, String properties, String rootTag) throws XFlatException {
        Utils.checkNonBlank(xml, "xml");
        Utils.checkNonBlank(properties, "properties");
        Utils.checkNonBlank(rootTag, "rootTag");
        List<String> propertiesList = Stream.of(properties.replaceAll("\\s", "").split(";")).filter(property -> !Utils.isBlank(property)).collect(Collectors.toList());
        SearchPathNode rootTreeNode = SearchPathTreeHandler.build(propertiesList, rootTag);
        Map<String, Map<Integer, String>> dataValueNodesMap = XmlHandler.parse(xml, rootTreeNode);
        return ResultHandler.arrange(dataValueNodesMap, propertiesList.size());
    }
}

