/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import org.springframework.beans.BeanInfoFactory;
import org.springframework.core.Ordered;
import org.springframework.core.SpringProperties;
import org.springframework.lang.NonNull;

public class StandardBeanInfoFactory
implements BeanInfoFactory,
Ordered {
    public static final String IGNORE_BEANINFO_PROPERTY_NAME = "spring.beaninfo.ignore";
    private static final boolean shouldIntrospectorIgnoreBeaninfoClasses = SpringProperties.getFlag("spring.beaninfo.ignore");

    @Override
    @NonNull
    public BeanInfo getBeanInfo(Class<?> beanClass) throws IntrospectionException {
        return shouldIntrospectorIgnoreBeaninfoClasses ? Introspector.getBeanInfo(beanClass, 3) : Introspector.getBeanInfo(beanClass);
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

