package org.sentrysoftware.metricshub.engine.common.exception;

/*-
 * ╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲
 * MetricsHub Engine
 * ჻჻჻჻჻჻
 * Copyright 2023 - 2024 Sentry Software
 * ჻჻჻჻჻჻
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * ╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱
 */

/**
 * This exception is thrown when no credentials are provided.
 *
 * <p>{@code NoCredentialProvidedException} is a checked exception that indicates a scenario
 * where the required credentials are not provided.</p>
 */
public class NoCredentialProvidedException extends Exception {

	private static final long serialVersionUID = 1L;

	/**
	 * Constructs a new {@code NoCredentialProvidedException} with a default message.
	 * The default message is "No credentials provided."
	 */
	public NoCredentialProvidedException() {
		super("No credentials provided.");
	}
}
