/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.alert;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.alert.AlertCondition;
import org.sentrysoftware.metricshub.engine.alert.AlertDetails;
import org.sentrysoftware.metricshub.engine.alert.AlertInfo;
import org.sentrysoftware.metricshub.engine.alert.AlertRuleState;
import org.sentrysoftware.metricshub.engine.alert.AlertRuleType;
import org.sentrysoftware.metricshub.engine.alert.Severity;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertRule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertRule.class);
    @JsonIgnore
    private BiFunction<Monitor, Set<AlertCondition>, AlertDetails> conditionsChecker;
    private long period;
    private Set<AlertCondition> conditions;
    private Severity severity;
    private Long firstTriggerTimestamp;
    private AlertDetails details;
    private AlertRuleState active = AlertRuleState.INACTIVE;
    private AlertRuleType type;
    @JsonIgnore
    private AlertInfo alertInfo;
    @JsonIgnore
    private Consumer<AlertInfo> trigger;
    private boolean triggered;

    public AlertRule(@NonNull BiFunction<Monitor, Set<AlertCondition>, AlertDetails> conditionsChecker, @NonNull Set<AlertCondition> conditions, long period, @NonNull Severity severity, @NonNull AlertRuleType type) {
        if (conditionsChecker == null) {
            throw new IllegalArgumentException("conditionsChecker is marked non-null but is null");
        }
        if (conditions == null) {
            throw new IllegalArgumentException("conditions is marked non-null but is null");
        }
        if (severity == null) {
            throw new IllegalArgumentException("severity is marked non-null but is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is marked non-null but is null");
        }
        this.conditionsChecker = conditionsChecker;
        this.conditions = conditions;
        this.period = period;
        this.severity = severity;
        this.type = type;
    }

    public AlertRule(@NonNull BiFunction<Monitor, Set<AlertCondition>, AlertDetails> conditionsChecker, @NonNull Set<AlertCondition> conditions, @NonNull Severity severity, @NonNull AlertRuleType type) {
        this(conditionsChecker, conditions, 0L, severity, type);
        if (conditionsChecker == null) {
            throw new IllegalArgumentException("conditionsChecker is marked non-null but is null");
        }
        if (conditions == null) {
            throw new IllegalArgumentException("conditions is marked non-null but is null");
        }
        if (severity == null) {
            throw new IllegalArgumentException("severity is marked non-null but is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is marked non-null but is null");
        }
    }

    public AlertRule(@NonNull BiFunction<Monitor, Set<AlertCondition>, AlertDetails> conditionsChecker, @NonNull Set<AlertCondition> conditions, long period, @NonNull Severity severity) {
        this(conditionsChecker, conditions, period, severity, AlertRuleType.STATIC);
        if (conditionsChecker == null) {
            throw new IllegalArgumentException("conditionsChecker is marked non-null but is null");
        }
        if (conditions == null) {
            throw new IllegalArgumentException("conditions is marked non-null but is null");
        }
        if (severity == null) {
            throw new IllegalArgumentException("severity is marked non-null but is null");
        }
    }

    public AlertRule(@NonNull BiFunction<Monitor, Set<AlertCondition>, AlertDetails> conditionsChecker, @NonNull Set<AlertCondition> conditions, @NonNull Severity severity) {
        this(conditionsChecker, conditions, 0L, severity, AlertRuleType.STATIC);
        if (conditionsChecker == null) {
            throw new IllegalArgumentException("conditionsChecker is marked non-null but is null");
        }
        if (conditions == null) {
            throw new IllegalArgumentException("conditions is marked non-null but is null");
        }
        if (severity == null) {
            throw new IllegalArgumentException("severity is marked non-null but is null");
        }
    }

    public void evaluate(Monitor monitor) {
        this.details = this.conditionsChecker.apply(monitor, this.conditions);
        this.refresh();
    }

    public AlertRuleState getActive() {
        this.refresh();
        return this.active;
    }

    public boolean isActive() {
        this.refresh();
        return AlertRuleState.ACTIVE.equals((Object)this.active);
    }

    private void refresh() {
        if (this.details != null) {
            long currentTimeMillis = System.currentTimeMillis();
            this.firstTriggerTimestamp = this.firstTriggerTimestamp == null ? currentTimeMillis : this.firstTriggerTimestamp;
            if (currentTimeMillis - this.firstTriggerTimestamp >= this.period) {
                this.active = AlertRuleState.ACTIVE;
                if (!this.isTriggered() && this.trigger != null && this.alertInfo != null) {
                    try {
                        this.trigger.accept(this.alertInfo);
                    }
                    catch (Exception e) {
                        log.debug("Hostname {} - Exception detected when triggering alert.", (Object)StringHelper.getValue(() -> this.alertInfo.getHostname(), ""), (Object)e);
                    }
                    this.triggered = true;
                }
            } else {
                this.active = AlertRuleState.PENDING;
            }
        } else {
            this.firstTriggerTimestamp = null;
            this.triggered = false;
        }
    }

    public AlertRule copy() {
        return new AlertRule(this.conditionsChecker, this.conditions.stream().filter(Objects::nonNull).map(AlertCondition::copy).collect(Collectors.toCollection(HashSet::new)), this.period, this.severity, this.type);
    }

    public boolean same(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlertRule other = (AlertRule)obj;
        if (this.conditions == null ? other.conditions != null : !this.conditions.equals(other.conditions)) {
            return false;
        }
        if (this.period != other.period) {
            return false;
        }
        return this.severity == other.severity;
    }

    @Generated
    public BiFunction<Monitor, Set<AlertCondition>, AlertDetails> getConditionsChecker() {
        return this.conditionsChecker;
    }

    @Generated
    public long getPeriod() {
        return this.period;
    }

    @Generated
    public Set<AlertCondition> getConditions() {
        return this.conditions;
    }

    @Generated
    public Severity getSeverity() {
        return this.severity;
    }

    @Generated
    public Long getFirstTriggerTimestamp() {
        return this.firstTriggerTimestamp;
    }

    @Generated
    public AlertDetails getDetails() {
        return this.details;
    }

    @Generated
    public AlertRuleType getType() {
        return this.type;
    }

    @Generated
    public AlertInfo getAlertInfo() {
        return this.alertInfo;
    }

    @Generated
    public Consumer<AlertInfo> getTrigger() {
        return this.trigger;
    }

    @Generated
    public boolean isTriggered() {
        return this.triggered;
    }

    @JsonIgnore
    @Generated
    public void setConditionsChecker(BiFunction<Monitor, Set<AlertCondition>, AlertDetails> conditionsChecker) {
        this.conditionsChecker = conditionsChecker;
    }

    @Generated
    public void setPeriod(long period) {
        this.period = period;
    }

    @Generated
    public void setConditions(Set<AlertCondition> conditions) {
        this.conditions = conditions;
    }

    @Generated
    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    @Generated
    public void setFirstTriggerTimestamp(Long firstTriggerTimestamp) {
        this.firstTriggerTimestamp = firstTriggerTimestamp;
    }

    @Generated
    public void setDetails(AlertDetails details) {
        this.details = details;
    }

    @Generated
    public void setActive(AlertRuleState active) {
        this.active = active;
    }

    @Generated
    public void setType(AlertRuleType type) {
        this.type = type;
    }

    @JsonIgnore
    @Generated
    public void setAlertInfo(AlertInfo alertInfo) {
        this.alertInfo = alertInfo;
    }

    @JsonIgnore
    @Generated
    public void setTrigger(Consumer<AlertInfo> trigger) {
        this.trigger = trigger;
    }

    @Generated
    public void setTriggered(boolean triggered) {
        this.triggered = triggered;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlertRule)) {
            return false;
        }
        AlertRule other = (AlertRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPeriod() != other.getPeriod()) {
            return false;
        }
        if (this.isTriggered() != other.isTriggered()) {
            return false;
        }
        Long this$firstTriggerTimestamp = this.getFirstTriggerTimestamp();
        Long other$firstTriggerTimestamp = other.getFirstTriggerTimestamp();
        if (this$firstTriggerTimestamp == null ? other$firstTriggerTimestamp != null : !((Object)this$firstTriggerTimestamp).equals(other$firstTriggerTimestamp)) {
            return false;
        }
        BiFunction<Monitor, Set<AlertCondition>, AlertDetails> this$conditionsChecker = this.getConditionsChecker();
        BiFunction<Monitor, Set<AlertCondition>, AlertDetails> other$conditionsChecker = other.getConditionsChecker();
        if (this$conditionsChecker == null ? other$conditionsChecker != null : !this$conditionsChecker.equals(other$conditionsChecker)) {
            return false;
        }
        Set<AlertCondition> this$conditions = this.getConditions();
        Set<AlertCondition> other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        Severity this$severity = this.getSeverity();
        Severity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
            return false;
        }
        AlertDetails this$details = this.getDetails();
        AlertDetails other$details = other.getDetails();
        if (this$details == null ? other$details != null : !((Object)this$details).equals(other$details)) {
            return false;
        }
        AlertRuleState this$active = this.getActive();
        AlertRuleState other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)((Object)this$active)).equals((Object)other$active)) {
            return false;
        }
        AlertRuleType this$type = this.getType();
        AlertRuleType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Consumer<AlertInfo> this$trigger = this.getTrigger();
        Consumer<AlertInfo> other$trigger = other.getTrigger();
        return !(this$trigger == null ? other$trigger != null : !this$trigger.equals(other$trigger));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AlertRule;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $period = this.getPeriod();
        result = result * 59 + (int)($period >>> 32 ^ $period);
        result = result * 59 + (this.isTriggered() ? 79 : 97);
        Long $firstTriggerTimestamp = this.getFirstTriggerTimestamp();
        result = result * 59 + ($firstTriggerTimestamp == null ? 43 : ((Object)$firstTriggerTimestamp).hashCode());
        BiFunction<Monitor, Set<AlertCondition>, AlertDetails> $conditionsChecker = this.getConditionsChecker();
        result = result * 59 + ($conditionsChecker == null ? 43 : $conditionsChecker.hashCode());
        Set<AlertCondition> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        Severity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
        AlertDetails $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        AlertRuleState $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)((Object)$active)).hashCode());
        AlertRuleType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Consumer<AlertInfo> $trigger = this.getTrigger();
        result = result * 59 + ($trigger == null ? 43 : $trigger.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AlertRule(conditionsChecker=" + String.valueOf(this.getConditionsChecker()) + ", period=" + this.getPeriod() + ", conditions=" + String.valueOf(this.getConditions()) + ", severity=" + String.valueOf((Object)this.getSeverity()) + ", firstTriggerTimestamp=" + this.getFirstTriggerTimestamp() + ", details=" + String.valueOf(this.getDetails()) + ", active=" + String.valueOf((Object)this.getActive()) + ", type=" + String.valueOf((Object)this.getType()) + ", trigger=" + String.valueOf(this.getTrigger()) + ", triggered=" + this.isTriggered() + ")";
    }

    @Generated
    public AlertRule() {
    }
}

