/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.awk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import lombok.Generated;
import org.sentrysoftware.jawk.ExitException;
import org.sentrysoftware.jawk.backend.AVM;
import org.sentrysoftware.jawk.frontend.AwkParser;
import org.sentrysoftware.jawk.frontend.AwkSyntaxTree;
import org.sentrysoftware.jawk.intermediate.AwkTuples;
import org.sentrysoftware.jawk.util.AwkSettings;
import org.sentrysoftware.jawk.util.ScriptSource;
import org.sentrysoftware.metricshub.engine.awk.UniformPrintStream;

public class Awk {
    public static AwkTuples getIntermediateCode(String script) throws ParseException {
        ScriptSource awkHeader = new ScriptSource("Header", (Reader)new StringReader("BEGIN { ORS = RS = \"\\n\"; }"), false);
        ScriptSource awkSource = new ScriptSource("Body", (Reader)new StringReader(script), false);
        ArrayList<ScriptSource> sourceList = new ArrayList<ScriptSource>();
        sourceList.add(awkHeader);
        sourceList.add(awkSource);
        AwkSettings settings = new AwkSettings();
        settings.setCatchIllegalFormatExceptions(false);
        AwkTuples tuples = new AwkTuples();
        AwkParser parser = new AwkParser(false, false, Collections.emptyMap());
        try {
            AwkSyntaxTree ast = parser.parse(sourceList);
            if (ast != null) {
                ast.semanticAnalysis();
                ast.semanticAnalysis();
                if (ast.populateTuples(tuples) != 0) {
                    throw new RuntimeException("Syntax problem with the Awk script");
                }
                tuples.postProcess();
                parser.populateGlobalVariableNameToOffsetMappings(tuples);
            }
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        return tuples;
    }

    public static String interpret(String input, AwkTuples intermediateCode, Charset charset) {
        AwkSettings settings = new AwkSettings();
        settings.setInput((InputStream)new ByteArrayInputStream(input.getBytes(charset)));
        ByteArrayOutputStream resultBytesStream = new ByteArrayOutputStream();
        UniformPrintStream resultStream = new UniformPrintStream(resultBytesStream);
        settings.setOutputStream((PrintStream)resultStream);
        settings.setCatchIllegalFormatExceptions(true);
        settings.setDefaultRS("\n");
        AVM avm = new AVM(settings, Collections.emptyMap());
        try {
            avm.interpret(intermediateCode);
        }
        catch (ExitException e) {
            if (e.getCode() != 0) {
                throw new RuntimeException(e.getMessage());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return resultBytesStream.toString();
    }

    public static String interpret(String input, AwkTuples intermediateCode) {
        return Awk.interpret(input, intermediateCode, StandardCharsets.UTF_8);
    }

    public static String interpret(String input, String script) throws ParseException {
        AwkTuples intermediateCode = Awk.getIntermediateCode(script);
        return Awk.interpret(input, intermediateCode);
    }

    @Generated
    private Awk() {
    }
}

