/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.common.helpers;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArrayHelper {
    private static final Pattern HEX_PATTERN = Pattern.compile("^\\s*(?:0x|#)?([0-9a-f]*)\\s*$", 2);

    private ArrayHelper() {
    }

    public static <T> T getValueAtIndex(T[] array, int index, T defaultValue) {
        if (array == null || array.length <= index) {
            return defaultValue;
        }
        return array[index];
    }

    public static boolean anyMatchLowerCase(Predicate<String> predicate, String ... data) {
        return Arrays.stream(data).filter(Objects::nonNull).map(String::toLowerCase).anyMatch(predicate);
    }

    public static byte[] hexToByteArray(String hexString) {
        if (hexString == null) {
            return new byte[0];
        }
        Matcher hexMatcher = HEX_PATTERN.matcher(hexString);
        if (!hexMatcher.find()) {
            throw new IllegalArgumentException("Invalid hexadecimal data: " + hexString);
        }
        String hexData = hexMatcher.group(1);
        int len = hexData.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("Missing or extraneous digit in " + hexData);
        }
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexData.charAt(i), 16) << 4) + Character.digit(hexData.charAt(i + 1), 16));
        }
        return data;
    }
}

