/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.deserializer.custom;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;

public abstract class AbstractCollectionDeserializer<T>
extends JsonDeserializer<Collection<T>> {
    public Collection<T> deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        if (parser == null) {
            return this.emptyCollection();
        }
        try {
            if (parser.isExpectedStartArrayToken()) {
                Collection strCollection = (Collection)parser.readValueAs((TypeReference)new TypeReference<Collection<String>>(){});
                return Optional.ofNullable(strCollection).map(collection -> collection.stream().map(this.valueExtractor()).filter(Objects::nonNull).collect(this.collector())).orElse(this.emptyCollection());
            }
            return Optional.ofNullable(parser.getValueAsString()).map(str -> this.fromCollection(Collections.singleton(this.valueExtractor().apply((String)str)))).orElse(this.emptyCollection());
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected abstract Function<String, T> valueExtractor();

    protected abstract Collection<T> emptyCollection();

    protected abstract Collector<T, ?, Collection<T>> collector();

    protected abstract Collection<T> fromCollection(Collection<T> var1);
}

