/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.connector.model.common.ExecuteForEachEntryOf;
import org.sentrysoftware.metricshub.engine.connector.model.common.HttpMethod;
import org.sentrysoftware.metricshub.engine.connector.model.common.ResultContent;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Compute;
import org.sentrysoftware.metricshub.engine.strategy.source.ISourceProcessor;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;

public class HttpSource
extends Source {
    private static final long serialVersionUID = 1L;
    @JsonSetter(nulls=Nulls.SKIP)
    private HttpMethod method = HttpMethod.GET;
    @JsonSetter(nulls=Nulls.SKIP)
    private String url;
    @JsonSetter(nulls=Nulls.SKIP)
    private String path;
    private String header;
    private String body;
    private String authenticationToken;
    @JsonSetter(nulls=Nulls.SKIP)
    private ResultContent resultContent = ResultContent.BODY;

    public HttpSource(@JsonProperty(value="type") String type, @JsonProperty(value="computes") List<Compute> computes, @JsonProperty(value="forceSerialization") boolean forceSerialization, @JsonProperty(value="method") HttpMethod method, @JsonProperty(value="url") String url, @JsonProperty(value="path") String path, @JsonProperty(value="header") String header, @JsonProperty(value="body") String body, @JsonProperty(value="authenticationToken") String authenticationToken, @JsonProperty(value="resultContent") ResultContent resultContent, @JsonProperty(value="key") String key, @JsonProperty(value="executeForEachEntryOf") ExecuteForEachEntryOf executeForEachEntryOf) {
        super(type, computes, forceSerialization, key, executeForEachEntryOf);
        this.method = method;
        this.url = url;
        this.path = path;
        this.header = header;
        this.body = body;
        this.authenticationToken = authenticationToken;
        this.resultContent = resultContent == null ? ResultContent.BODY : resultContent;
    }

    @Override
    public HttpSource copy() {
        return HttpSource.builder().type(this.type).key(this.key).forceSerialization(this.forceSerialization).computes((List<Compute>)(this.getComputes() != null ? new ArrayList<Compute>(this.getComputes()) : null)).executeForEachEntryOf(this.executeForEachEntryOf != null ? this.executeForEachEntryOf.copy() : null).method(this.method).url(this.url).path(this.path).header(this.header).body(this.body).authenticationToken(this.authenticationToken).resultContent(this.resultContent).build();
    }

    @Override
    public void update(UnaryOperator<String> updater) {
        this.url = (String)updater.apply(this.url);
        this.path = (String)updater.apply(this.path);
        this.header = (String)updater.apply(this.header);
        this.body = (String)updater.apply(this.body);
        this.authenticationToken = (String)updater.apply(this.authenticationToken);
    }

    @Override
    public String toString() {
        StringJoiner stringJoiner = new StringJoiner("\n");
        stringJoiner.add(super.toString());
        StringHelper.addNonNull(stringJoiner, "- method=", this.method);
        StringHelper.addNonNull(stringJoiner, "- url=", this.url);
        StringHelper.addNonNull(stringJoiner, "- path=", this.path);
        StringHelper.addNonNull(stringJoiner, "- header=", this.header);
        StringHelper.addNonNull(stringJoiner, "- body=", this.body);
        StringHelper.addNonNull(stringJoiner, "- authenticationToken=", this.authenticationToken);
        StringHelper.addNonNull(stringJoiner, "- resultContent=", this.resultContent != null ? this.resultContent.getName() : null);
        return stringJoiner.toString();
    }

    @Override
    public SourceTable accept(ISourceProcessor sourceProcessor) {
        return sourceProcessor.process(this);
    }

    @Generated
    public static HttpSourceBuilder builder() {
        return new HttpSourceBuilder();
    }

    @Generated
    public HttpMethod getMethod() {
        return this.method;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getHeader() {
        return this.header;
    }

    @Generated
    public String getBody() {
        return this.body;
    }

    @Generated
    public String getAuthenticationToken() {
        return this.authenticationToken;
    }

    @Generated
    public ResultContent getResultContent() {
        return this.resultContent;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setHeader(String header) {
        this.header = header;
    }

    @Generated
    public void setBody(String body) {
        this.body = body;
    }

    @Generated
    public void setAuthenticationToken(String authenticationToken) {
        this.authenticationToken = authenticationToken;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setResultContent(ResultContent resultContent) {
        this.resultContent = resultContent;
    }

    @Generated
    public HttpSource() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpSource)) {
            return false;
        }
        HttpSource other = (HttpSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpMethod this$method = this.getMethod();
        HttpMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$header = this.getHeader();
        String other$header = other.getHeader();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        String this$authenticationToken = this.getAuthenticationToken();
        String other$authenticationToken = other.getAuthenticationToken();
        if (this$authenticationToken == null ? other$authenticationToken != null : !this$authenticationToken.equals(other$authenticationToken)) {
            return false;
        }
        ResultContent this$resultContent = this.getResultContent();
        ResultContent other$resultContent = other.getResultContent();
        return !(this$resultContent == null ? other$resultContent != null : !((Object)((Object)this$resultContent)).equals((Object)other$resultContent));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpSource;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        HttpMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        String $authenticationToken = this.getAuthenticationToken();
        result = result * 59 + ($authenticationToken == null ? 43 : $authenticationToken.hashCode());
        ResultContent $resultContent = this.getResultContent();
        result = result * 59 + ($resultContent == null ? 43 : ((Object)((Object)$resultContent)).hashCode());
        return result;
    }

    @Generated
    public static class HttpSourceBuilder {
        @Generated
        private String type;
        @Generated
        private List<Compute> computes;
        @Generated
        private boolean forceSerialization;
        @Generated
        private HttpMethod method;
        @Generated
        private String url;
        @Generated
        private String path;
        @Generated
        private String header;
        @Generated
        private String body;
        @Generated
        private String authenticationToken;
        @Generated
        private ResultContent resultContent;
        @Generated
        private String key;
        @Generated
        private ExecuteForEachEntryOf executeForEachEntryOf;

        @Generated
        HttpSourceBuilder() {
        }

        @JsonProperty(value="type")
        @Generated
        public HttpSourceBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="computes")
        @Generated
        public HttpSourceBuilder computes(List<Compute> computes) {
            this.computes = computes;
            return this;
        }

        @JsonProperty(value="forceSerialization")
        @Generated
        public HttpSourceBuilder forceSerialization(boolean forceSerialization) {
            this.forceSerialization = forceSerialization;
            return this;
        }

        @JsonProperty(value="method")
        @Generated
        public HttpSourceBuilder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        @JsonProperty(value="url")
        @Generated
        public HttpSourceBuilder url(String url) {
            this.url = url;
            return this;
        }

        @JsonProperty(value="path")
        @Generated
        public HttpSourceBuilder path(String path) {
            this.path = path;
            return this;
        }

        @JsonProperty(value="header")
        @Generated
        public HttpSourceBuilder header(String header) {
            this.header = header;
            return this;
        }

        @JsonProperty(value="body")
        @Generated
        public HttpSourceBuilder body(String body) {
            this.body = body;
            return this;
        }

        @JsonProperty(value="authenticationToken")
        @Generated
        public HttpSourceBuilder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        @JsonProperty(value="resultContent")
        @Generated
        public HttpSourceBuilder resultContent(ResultContent resultContent) {
            this.resultContent = resultContent;
            return this;
        }

        @JsonProperty(value="key")
        @Generated
        public HttpSourceBuilder key(String key) {
            this.key = key;
            return this;
        }

        @JsonProperty(value="executeForEachEntryOf")
        @Generated
        public HttpSourceBuilder executeForEachEntryOf(ExecuteForEachEntryOf executeForEachEntryOf) {
            this.executeForEachEntryOf = executeForEachEntryOf;
            return this;
        }

        @Generated
        public HttpSource build() {
            return new HttpSource(this.type, this.computes, this.forceSerialization, this.method, this.url, this.path, this.header, this.body, this.authenticationToken, this.resultContent, this.key, this.executeForEachEntryOf);
        }

        @Generated
        public String toString() {
            return "HttpSource.HttpSourceBuilder(type=" + this.type + ", computes=" + String.valueOf(this.computes) + ", forceSerialization=" + this.forceSerialization + ", method=" + String.valueOf((Object)this.method) + ", url=" + this.url + ", path=" + this.path + ", header=" + this.header + ", body=" + this.body + ", authenticationToken=" + this.authenticationToken + ", resultContent=" + String.valueOf((Object)this.resultContent) + ", key=" + this.key + ", executeForEachEntryOf=" + String.valueOf(this.executeForEachEntryOf) + ")";
        }
    }
}

