/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.StringJoiner;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.TranslationTableDeserializer;
import org.sentrysoftware.metricshub.engine.connector.model.common.ITranslationTable;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Compute;
import org.sentrysoftware.metricshub.engine.strategy.source.compute.IComputeProcessor;

public class ArrayTranslate
extends Compute {
    private static final long serialVersionUID = 1L;
    @JsonSetter(nulls=Nulls.FAIL)
    @NonNull
    private Integer column;
    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=TranslationTableDeserializer.class)
    @NonNull
    private ITranslationTable translationTable;
    private String arraySeparator;
    private String resultSeparator;

    @JsonCreator
    public ArrayTranslate(@JsonProperty(value="type") String type, @JsonProperty(value="column", required=true) @NonNull Integer column, @JsonProperty(value="translationTable", required=true) @NonNull ITranslationTable translationTable, @JsonProperty(value="arraySeparator") String arraySeparator, @JsonProperty(value="resultSeparator") String resultSeparator) {
        super(type);
        if (column == null) {
            throw new IllegalArgumentException("column is marked non-null but is null");
        }
        if (translationTable == null) {
            throw new IllegalArgumentException("translationTable is marked non-null but is null");
        }
        this.column = column;
        this.translationTable = translationTable;
        this.arraySeparator = arraySeparator;
        this.resultSeparator = resultSeparator;
    }

    @Override
    public String toString() {
        StringJoiner stringJoiner = new StringJoiner("\n");
        stringJoiner.add(super.toString());
        StringHelper.addNonNull(stringJoiner, "- column=", this.column);
        StringHelper.addNonNull(stringJoiner, "- translationTable=", this.translationTable);
        StringHelper.addNonNull(stringJoiner, "- arraySeparator=", this.arraySeparator);
        StringHelper.addNonNull(stringJoiner, "- resultSeparator=", this.resultSeparator);
        return stringJoiner.toString();
    }

    @Override
    public ArrayTranslate copy() {
        return ArrayTranslate.builder().type(this.type).column(this.column).translationTable(this.translationTable).arraySeparator(this.arraySeparator).resultSeparator(this.resultSeparator).build();
    }

    @Override
    public void update(UnaryOperator<String> updater) {
        this.arraySeparator = (String)updater.apply(this.arraySeparator);
        this.resultSeparator = (String)updater.apply(this.resultSeparator);
        this.translationTable.update(updater);
    }

    @Override
    public void accept(IComputeProcessor computeProcessor) {
        computeProcessor.process(this);
    }

    @Generated
    public static ArrayTranslateBuilder builder() {
        return new ArrayTranslateBuilder();
    }

    @NonNull
    @Generated
    public Integer getColumn() {
        return this.column;
    }

    @NonNull
    @Generated
    public ITranslationTable getTranslationTable() {
        return this.translationTable;
    }

    @Generated
    public String getArraySeparator() {
        return this.arraySeparator;
    }

    @Generated
    public String getResultSeparator() {
        return this.resultSeparator;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @Generated
    public void setColumn(@NonNull Integer column) {
        if (column == null) {
            throw new IllegalArgumentException("column is marked non-null but is null");
        }
        this.column = column;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=TranslationTableDeserializer.class)
    @Generated
    public void setTranslationTable(@NonNull ITranslationTable translationTable) {
        if (translationTable == null) {
            throw new IllegalArgumentException("translationTable is marked non-null but is null");
        }
        this.translationTable = translationTable;
    }

    @Generated
    public void setArraySeparator(String arraySeparator) {
        this.arraySeparator = arraySeparator;
    }

    @Generated
    public void setResultSeparator(String resultSeparator) {
        this.resultSeparator = resultSeparator;
    }

    @Generated
    public ArrayTranslate() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrayTranslate)) {
            return false;
        }
        ArrayTranslate other = (ArrayTranslate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$column = this.getColumn();
        Integer other$column = other.getColumn();
        if (this$column == null ? other$column != null : !((Object)this$column).equals(other$column)) {
            return false;
        }
        ITranslationTable this$translationTable = this.getTranslationTable();
        ITranslationTable other$translationTable = other.getTranslationTable();
        if (this$translationTable == null ? other$translationTable != null : !this$translationTable.equals(other$translationTable)) {
            return false;
        }
        String this$arraySeparator = this.getArraySeparator();
        String other$arraySeparator = other.getArraySeparator();
        if (this$arraySeparator == null ? other$arraySeparator != null : !this$arraySeparator.equals(other$arraySeparator)) {
            return false;
        }
        String this$resultSeparator = this.getResultSeparator();
        String other$resultSeparator = other.getResultSeparator();
        return !(this$resultSeparator == null ? other$resultSeparator != null : !this$resultSeparator.equals(other$resultSeparator));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArrayTranslate;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : ((Object)$column).hashCode());
        ITranslationTable $translationTable = this.getTranslationTable();
        result = result * 59 + ($translationTable == null ? 43 : $translationTable.hashCode());
        String $arraySeparator = this.getArraySeparator();
        result = result * 59 + ($arraySeparator == null ? 43 : $arraySeparator.hashCode());
        String $resultSeparator = this.getResultSeparator();
        result = result * 59 + ($resultSeparator == null ? 43 : $resultSeparator.hashCode());
        return result;
    }

    @Generated
    public static class ArrayTranslateBuilder {
        @Generated
        private String type;
        @Generated
        private Integer column;
        @Generated
        private ITranslationTable translationTable;
        @Generated
        private String arraySeparator;
        @Generated
        private String resultSeparator;

        @Generated
        ArrayTranslateBuilder() {
        }

        @JsonProperty(value="type")
        @Generated
        public ArrayTranslateBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="column", required=true)
        @Generated
        public ArrayTranslateBuilder column(@NonNull Integer column) {
            if (column == null) {
                throw new IllegalArgumentException("column is marked non-null but is null");
            }
            this.column = column;
            return this;
        }

        @JsonProperty(value="translationTable", required=true)
        @Generated
        public ArrayTranslateBuilder translationTable(@NonNull ITranslationTable translationTable) {
            if (translationTable == null) {
                throw new IllegalArgumentException("translationTable is marked non-null but is null");
            }
            this.translationTable = translationTable;
            return this;
        }

        @JsonProperty(value="arraySeparator")
        @Generated
        public ArrayTranslateBuilder arraySeparator(String arraySeparator) {
            this.arraySeparator = arraySeparator;
            return this;
        }

        @JsonProperty(value="resultSeparator")
        @Generated
        public ArrayTranslateBuilder resultSeparator(String resultSeparator) {
            this.resultSeparator = resultSeparator;
            return this;
        }

        @Generated
        public ArrayTranslate build() {
            return new ArrayTranslate(this.type, this.column, this.translationTable, this.arraySeparator, this.resultSeparator);
        }

        @Generated
        public String toString() {
            return "ArrayTranslate.ArrayTranslateBuilder(type=" + this.type + ", column=" + this.column + ", translationTable=" + String.valueOf(this.translationTable) + ", arraySeparator=" + this.arraySeparator + ", resultSeparator=" + this.resultSeparator + ")";
        }
    }
}

