/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.update;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.MonitorJob;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.SimpleMonitorJob;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.StandardMonitorJob;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.AbstractCollect;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.Discovery;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.Simple;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.connector.update.AbstractConnectorUpdateChain;

public class AvailableSourceUpdate
extends AbstractConnectorUpdateChain {
    @Override
    void doUpdate(Connector connector) {
        HashSet<Class<? extends Source>> sourceTypes = new HashSet<Class<? extends Source>>();
        for (MonitorJob monitor : connector.getMonitors().values()) {
            Map<String, Source> afterAll;
            Map<String, Source> beforeAll;
            if (monitor instanceof StandardMonitorJob) {
                StandardMonitorJob standardMonitorJob = (StandardMonitorJob)monitor;
                this.processDiscoverySources(sourceTypes, standardMonitorJob.getDiscovery());
                this.processCollectSources(sourceTypes, standardMonitorJob.getCollect());
            }
            if (monitor instanceof SimpleMonitorJob) {
                SimpleMonitorJob simpleMonitorJob = (SimpleMonitorJob)monitor;
                Simple simple = simpleMonitorJob.getSimple();
                this.processSimpleSources(sourceTypes, simple);
            }
            if ((beforeAll = connector.getBeforeAll()) != null) {
                beforeAll.values().forEach(source -> sourceTypes.add(source.getClass()));
            }
            if ((afterAll = connector.getAfterAll()) != null) {
                afterAll.values().forEach(source -> sourceTypes.add(source.getClass()));
            }
            connector.setSourceTypes(sourceTypes);
        }
    }

    private void processSimpleSources(Set<Class<? extends Source>> sourceTypes, Simple simple) {
        if (simple != null) {
            simple.getSources().values().forEach(source -> sourceTypes.add(source.getClass()));
        }
    }

    private void processCollectSources(Set<Class<? extends Source>> sourceTypes, AbstractCollect collect) {
        if (collect != null) {
            collect.getSources().values().forEach(source -> sourceTypes.add(source.getClass()));
        }
    }

    private void processDiscoverySources(Set<Class<? extends Source>> sourceTypes, Discovery discovery) {
        if (discovery != null) {
            discovery.getSources().values().forEach(source -> sourceTypes.add(source.getClass()));
        }
    }
}

