/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.update;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.connector.update.AbstractConnectorUpdateChain;

public abstract class SourceConnectorUpdateChain
extends AbstractConnectorUpdateChain {
    protected List<Set<String>> updateSourceDependency(Map<String, Source> sources, Pattern context, int sourceGroup) {
        if (sources.isEmpty()) {
            return new ArrayList<Set<String>>();
        }
        LinkedHashMap<Integer, Set<String>> mapLevels = new LinkedHashMap<Integer, Set<String>>();
        Map<String, Set> sourceIdToDependencyIds = sources.entrySet().stream().map(entry -> this.buildDependencyEntry((Map.Entry<String, Source>)entry, context, sourceGroup)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        Set pendingSourceIds = sources.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toSet());
        Map<String, Map> foundDependencies = sourceIdToDependencyIds.entrySet().stream().filter(entry -> !((Set)entry.getValue()).isEmpty()).map(entry -> Map.entry((String)entry.getKey(), new HashMap())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        do {
            HashSet<String> processedSourceIds = new HashSet<String>();
            for (String sourceId : pendingSourceIds) {
                Set dependencyIds = sourceIdToDependencyIds.get(sourceId);
                if (!dependencyIds.isEmpty()) {
                    Map found = foundDependencies.get(sourceId);
                    this.findDependencyLevels(mapLevels, dependencyIds, found);
                    if (found.size() != dependencyIds.size()) continue;
                    SourceConnectorUpdateChain.addSourceIdToLevel(mapLevels, sourceId, (Integer)Collections.max(found.values()) + 1, processedSourceIds);
                    continue;
                }
                SourceConnectorUpdateChain.addSourceIdToLevel(mapLevels, sourceId, 1, processedSourceIds);
            }
            pendingSourceIds.removeAll(processedSourceIds);
        } while (!pendingSourceIds.isEmpty());
        return mapLevels.values().stream().map(Function.identity()).collect(Collectors.toList());
    }

    private void findDependencyLevels(Map<Integer, Set<String>> mapLevels, Set<String> dependencyIds, Map<String, Integer> found) {
        Set remaining = dependencyIds.stream().collect(Collectors.toSet());
        remaining.removeAll(found.keySet());
        for (String depId : remaining) {
            mapLevels.entrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(depId)).findFirst().ifPresent(entry -> found.put(depId, (Integer)entry.getKey()));
        }
    }

    private Map.Entry<String, Set<String>> buildDependencyEntry(Map.Entry<String, Source> sourceEntry, Pattern context, int sourceGroup) {
        Source source = sourceEntry.getValue();
        String sourceId = sourceEntry.getKey();
        Set<String> references = source.getReferences();
        return this.getContextDependencies(sourceId, context, sourceGroup, references.toArray(new String[references.size()]));
    }

    private Map.Entry<String, Set<String>> getContextDependencies(String sourceId, Pattern context, int sourceGroup, String ... refs) {
        HashSet<String> dependencies = new HashSet<String>();
        for (String ref : refs) {
            Matcher includeMatcher = context.matcher(ref);
            while (includeMatcher.find()) {
                dependencies.add(includeMatcher.group(sourceGroup));
            }
        }
        return Map.entry(sourceId, dependencies);
    }

    private static void addSourceIdToLevel(Map<Integer, Set<String>> mapLevels, String sourceId, int level, Set<String> processedSources) {
        mapLevels.computeIfAbsent(level, k -> new LinkedHashSet()).add(sourceId);
        processedSources.add(sourceId);
    }

    protected String getSourceIdentifiersRegex(Map<String, Source> sources) {
        return sources.keySet().stream().map(Pattern::quote).collect(Collectors.joining("|"));
    }
}

