/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.extension;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.classloader.agent.ClassLoaderAgent;
import org.sentrysoftware.metricshub.engine.extension.ExtensionManager;
import org.sentrysoftware.metricshub.engine.extension.ICompositeSourceScriptExtension;
import org.sentrysoftware.metricshub.engine.extension.IConnectorStoreProviderExtension;
import org.sentrysoftware.metricshub.engine.extension.IProtocolExtension;
import org.sentrysoftware.metricshub.engine.extension.ISourceComputationExtension;
import org.sentrysoftware.metricshub.engine.extension.IStrategyProviderExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtensionLoader.class);
    @NonNull
    private File extensionsDirectory;
    private ExtensionManager extensionManager;

    public ExtensionManager load() throws IOException {
        if (this.extensionManager != null) {
            return this.extensionManager;
        }
        File[] extensionJars = this.extensionsDirectory.listFiles((unused, fileName) -> fileName.endsWith(".jar"));
        if (extensionJars == null || extensionJars.length == 0) {
            log.debug("No extension to load from {}. Stop extension loading.", (Object)this.extensionsDirectory);
            return ExtensionManager.empty();
        }
        URL[] urls = new URL[extensionJars.length];
        for (int i = 0; i < extensionJars.length; ++i) {
            File jarFile = extensionJars[i];
            ClassLoaderAgent.addToClassPath((JarFile)new JarFile(jarFile));
            urls[i] = jarFile.toURI().toURL();
        }
        URLClassLoader classLoader = new URLClassLoader(urls);
        ServiceLoader<IProtocolExtension> protocolExtensions = ServiceLoader.load(IProtocolExtension.class, classLoader);
        protocolExtensions.forEach(extension -> log.info("Loaded protocol extension {}.", (Object)extension.getClass().getSimpleName()));
        ServiceLoader<IStrategyProviderExtension> strategyProviderExtensions = ServiceLoader.load(IStrategyProviderExtension.class, classLoader);
        strategyProviderExtensions.forEach(extension -> log.info("Loaded strategy provider extension {}.", (Object)extension.getClass().getSimpleName()));
        ServiceLoader<IConnectorStoreProviderExtension> connectorStoreProviderExtensions = ServiceLoader.load(IConnectorStoreProviderExtension.class, classLoader);
        connectorStoreProviderExtensions.forEach(extension -> log.info("Loaded connector store provider extension {}.", (Object)extension.getClass().getSimpleName()));
        ServiceLoader<ISourceComputationExtension> sourceComputationExtensions = ServiceLoader.load(ISourceComputationExtension.class, classLoader);
        sourceComputationExtensions.forEach(extension -> log.info("Loaded source computation extension {}.", (Object)extension.getClass().getSimpleName()));
        ServiceLoader<ICompositeSourceScriptExtension> compositeSourceScriptExtensions = ServiceLoader.load(ICompositeSourceScriptExtension.class, classLoader);
        compositeSourceScriptExtensions.forEach(extension -> log.info("Loaded composite source script extension {}.", (Object)extension.getClass().getSimpleName()));
        this.extensionManager = ExtensionManager.builder().withProtocolExtensions(this.convertProviderStreamToList(protocolExtensions.stream())).withStrategyProviderExtensions(this.convertProviderStreamToList(strategyProviderExtensions.stream())).withConnectorStoreProviderExtensions(this.convertProviderStreamToList(connectorStoreProviderExtensions.stream())).withSourceComputationExtensions(this.convertProviderStreamToList(sourceComputationExtensions.stream())).withCompositeSourceScriptExtensions(this.convertProviderStreamToList(compositeSourceScriptExtensions.stream())).build();
        return this.extensionManager;
    }

    <T> List<T> convertProviderStreamToList(Stream<ServiceLoader.Provider<T>> providerStream) {
        return providerStream.map(ServiceLoader.Provider::get).collect(Collectors.toCollection(ArrayList::new));
    }

    @NonNull
    @Generated
    public File getExtensionsDirectory() {
        return this.extensionsDirectory;
    }

    @Generated
    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    @Generated
    public void setExtensionsDirectory(@NonNull File extensionsDirectory) {
        if (extensionsDirectory == null) {
            throw new IllegalArgumentException("extensionsDirectory is marked non-null but is null");
        }
        this.extensionsDirectory = extensionsDirectory;
    }

    @Generated
    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtensionLoader)) {
            return false;
        }
        ExtensionLoader other = (ExtensionLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$extensionsDirectory = this.getExtensionsDirectory();
        File other$extensionsDirectory = other.getExtensionsDirectory();
        if (this$extensionsDirectory == null ? other$extensionsDirectory != null : !((Object)this$extensionsDirectory).equals(other$extensionsDirectory)) {
            return false;
        }
        ExtensionManager this$extensionManager = this.getExtensionManager();
        ExtensionManager other$extensionManager = other.getExtensionManager();
        return !(this$extensionManager == null ? other$extensionManager != null : !((Object)this$extensionManager).equals(other$extensionManager));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExtensionLoader;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $extensionsDirectory = this.getExtensionsDirectory();
        result = result * 59 + ($extensionsDirectory == null ? 43 : ((Object)$extensionsDirectory).hashCode());
        ExtensionManager $extensionManager = this.getExtensionManager();
        result = result * 59 + ($extensionManager == null ? 43 : ((Object)$extensionManager).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ExtensionLoader(extensionsDirectory=" + String.valueOf(this.getExtensionsDirectory()) + ", extensionManager=" + String.valueOf(this.getExtensionManager()) + ")";
    }

    @Generated
    public ExtensionLoader(@NonNull File extensionsDirectory) {
        if (extensionsDirectory == null) {
            throw new IllegalArgumentException("extensionsDirectory is marked non-null but is null");
        }
        this.extensionsDirectory = extensionsDirectory;
    }
}

