/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.security.CryptoCipher;
import org.sentrysoftware.metricshub.engine.security.MetricsHubSecurityException;

public class SecurityManager {
    private static final char[] KEY_STORE_PASSWORD = new char[]{'M', 'a', 't', 'r', 'i', 'x', ',', ' ', 'C', 'r', 'e', 'd', 'i', 't', 's', ':', ' ', 'B', 'e', 'r', 't', 'r', 'a', 'n', 'd', ',', ' ', 'E', 'l', 'v', 'i', 's', ',', ' ', 'F', 'a', 'd', 'h', 'e', 'l', 'a', ',', ' ', 'H', 'u', 'a', 'n', ',', ' ', 'N', 'a', 's', 's', 'i', 'm', ',', ' ', 'R', 'a', 'm', 'a', 's', 's', 'h', ' ', 'a', 'n', 'd', ' ', 'T', 'h', 'o', 'm', 'a', 's'};
    private static final String MASTER_KEY_ALIAS = "masterKey";
    public static final String METRICSHUB_KEY_STORE_FILE_NAME = "metricshub-keystore.p12";

    public static char[] encrypt(char[] passwd, @NonNull File keyStoreFile) throws MetricsHubSecurityException {
        if (keyStoreFile == null) {
            throw new IllegalArgumentException("keyStoreFile is marked non-null but is null");
        }
        if (passwd == null) {
            return passwd;
        }
        return CryptoCipher.encrypt(passwd, SecurityManager.getSecretKey(keyStoreFile));
    }

    public static char[] decrypt(char[] encrypted, File keyStoreFile) throws MetricsHubSecurityException {
        if (encrypted != null && keyStoreFile != null && keyStoreFile.exists()) {
            return CryptoCipher.decrypt(encrypted, SecurityManager.getSecretKey(keyStoreFile));
        }
        return encrypted;
    }

    private static SecretKey getSecretKey(@NonNull File keyStoreFile) throws MetricsHubSecurityException {
        if (keyStoreFile == null) {
            throw new IllegalArgumentException("keyStoreFile is marked non-null but is null");
        }
        KeyStore ks = SecurityManager.loadKeyStore(keyStoreFile);
        KeyStore.SecretKeyEntry entry = null;
        try {
            entry = (KeyStore.SecretKeyEntry)ks.getEntry(MASTER_KEY_ALIAS, new KeyStore.PasswordProtection(KEY_STORE_PASSWORD));
        }
        catch (Exception e) {
            throw new MetricsHubSecurityException("Error detected when getting the secret key entry", e);
        }
        if (entry == null) {
            return SecurityManager.generateMasterKey(ks, KEY_STORE_PASSWORD, keyStoreFile);
        }
        return entry.getSecretKey();
    }

    public static KeyStore loadKeyStore(@NonNull File keyStoreFile) throws MetricsHubSecurityException {
        if (keyStoreFile == null) {
            throw new IllegalArgumentException("keyStoreFile is marked non-null but is null");
        }
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12");
            if (keyStoreFile.exists()) {
                try (FileInputStream stream = new FileInputStream(keyStoreFile);){
                    ks.load(stream, KEY_STORE_PASSWORD);
                }
            }
            ks.load(null, null);
            try (FileOutputStream stream = new FileOutputStream(keyStoreFile);){
                ks.store(stream, KEY_STORE_PASSWORD);
            }
            return ks;
        }
        catch (Exception e) {
            throw new MetricsHubSecurityException("Error detected when loading metricshub-keystore.p12", e);
        }
    }

    public static SecretKey generateMasterKey(@NonNull KeyStore ks, @NonNull char[] password, @NonNull File keyStoreFile) throws MetricsHubSecurityException {
        if (ks == null) {
            throw new IllegalArgumentException("ks is marked non-null but is null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password is marked non-null but is null");
        }
        if (keyStoreFile == null) {
            throw new IllegalArgumentException("keyStoreFile is marked non-null but is null");
        }
        try {
            char[] masterKey = CryptoCipher.generateRandomMasterKey();
            PBEKeySpec spec = new PBEKeySpec(masterKey, CryptoCipher.getSalt(), 2333, 256);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            SecretKey secretKey = skf.generateSecret(spec);
            KeyStore.SecretKeyEntry skEntry = new KeyStore.SecretKeyEntry(secretKey);
            ks.setEntry(MASTER_KEY_ALIAS, skEntry, new KeyStore.PasswordProtection(password));
            ks.store(new FileOutputStream(keyStoreFile), password);
            return secretKey;
        }
        catch (Exception e) {
            throw new MetricsHubSecurityException("Error detected when generating the master key", e);
        }
    }

    @Generated
    private SecurityManager() {
    }
}

