/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.discovery;

import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.MonitorJob;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.StandardMonitorJob;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.AbstractMonitorTask;
import org.sentrysoftware.metricshub.engine.extension.ExtensionManager;
import org.sentrysoftware.metricshub.engine.strategy.AbstractAllAtOnceStrategy;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;

public class DiscoveryStrategy
extends AbstractAllAtOnceStrategy {
    private static final String JOB_NAME = "discovery";

    public DiscoveryStrategy(@NonNull TelemetryManager telemetryManager, @NonNull Long strategyTime, @NonNull ClientsExecutor clientsExecutor, @NonNull ExtensionManager extensionManager) {
        super(telemetryManager, (long)strategyTime, clientsExecutor, extensionManager);
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        if (strategyTime == null) {
            throw new IllegalArgumentException("strategyTime is marked non-null but is null");
        }
        if (clientsExecutor == null) {
            throw new IllegalArgumentException("clientsExecutor is marked non-null but is null");
        }
        if (extensionManager == null) {
            throw new IllegalArgumentException("extensionManager is marked non-null but is null");
        }
    }

    @Override
    protected String getJobName() {
        return JOB_NAME;
    }

    @Override
    protected AbstractMonitorTask retrieveTask(MonitorJob monitorJob) {
        if (monitorJob instanceof StandardMonitorJob) {
            StandardMonitorJob standardMonitorJob = (StandardMonitorJob)monitorJob;
            return standardMonitorJob.getDiscovery();
        }
        return null;
    }

    @Generated
    public static DiscoveryStrategyBuilder builder() {
        return new DiscoveryStrategyBuilder();
    }

    @Generated
    public DiscoveryStrategy() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DiscoveryStrategy)) {
            return false;
        }
        DiscoveryStrategy other = (DiscoveryStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DiscoveryStrategy;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public static class DiscoveryStrategyBuilder {
        @Generated
        private TelemetryManager telemetryManager;
        @Generated
        private Long strategyTime;
        @Generated
        private ClientsExecutor clientsExecutor;
        @Generated
        private ExtensionManager extensionManager;

        @Generated
        DiscoveryStrategyBuilder() {
        }

        @Generated
        public DiscoveryStrategyBuilder telemetryManager(@NonNull TelemetryManager telemetryManager) {
            if (telemetryManager == null) {
                throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
            }
            this.telemetryManager = telemetryManager;
            return this;
        }

        @Generated
        public DiscoveryStrategyBuilder strategyTime(@NonNull Long strategyTime) {
            if (strategyTime == null) {
                throw new IllegalArgumentException("strategyTime is marked non-null but is null");
            }
            this.strategyTime = strategyTime;
            return this;
        }

        @Generated
        public DiscoveryStrategyBuilder clientsExecutor(@NonNull ClientsExecutor clientsExecutor) {
            if (clientsExecutor == null) {
                throw new IllegalArgumentException("clientsExecutor is marked non-null but is null");
            }
            this.clientsExecutor = clientsExecutor;
            return this;
        }

        @Generated
        public DiscoveryStrategyBuilder extensionManager(@NonNull ExtensionManager extensionManager) {
            if (extensionManager == null) {
                throw new IllegalArgumentException("extensionManager is marked non-null but is null");
            }
            this.extensionManager = extensionManager;
            return this;
        }

        @Generated
        public DiscoveryStrategy build() {
            return new DiscoveryStrategy(this.telemetryManager, this.strategyTime, this.clientsExecutor, this.extensionManager);
        }

        @Generated
        public String toString() {
            return "DiscoveryStrategy.DiscoveryStrategyBuilder(telemetryManager=" + String.valueOf(this.telemetryManager) + ", strategyTime=" + this.strategyTime + ", clientsExecutor=" + String.valueOf(this.clientsExecutor) + ", extensionManager=" + String.valueOf(this.extensionManager) + ")";
        }
    }
}

