/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.JobInfo;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedSources {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OrderedSources.class);
    private List<Source> sources;

    @Generated
    private static List<Source> $default$sources() {
        return new ArrayList<Source>();
    }

    @Generated
    public static OrderedSourcesBuilder builder() {
        return new OrderedSourcesBuilder();
    }

    @Generated
    private OrderedSources() {
        this.sources = OrderedSources.$default$sources();
    }

    @Generated
    public OrderedSources(List<Source> sources) {
        this.sources = sources;
    }

    @Generated
    public List<Source> getSources() {
        return this.sources;
    }

    public static class OrderedSourcesBuilder {
        @Generated
        private boolean sources$set;
        @Generated
        private List<Source> sources$value;

        public OrderedSourcesBuilder sources(Map<String, Source> sources, List<String> executionOrder, List<Set<String>> sourceDepTree, JobInfo jobInfo) {
            if (sources == null || sources.isEmpty()) {
                this.sources$value = new ArrayList<Source>();
                this.sources$set = true;
                return this;
            }
            if (executionOrder != null && !executionOrder.isEmpty()) {
                return this.orderSources(sources, executionOrder, "execution order", jobInfo);
            }
            if (sourceDepTree != null && !sourceDepTree.isEmpty()) {
                return this.orderSources(sources, sourceDepTree.stream().flatMap(Collection::stream).collect(Collectors.toList()), "dependency tree", jobInfo);
            }
            this.sources$value = sources.values().stream().collect(Collectors.toList());
            this.sources$set = true;
            return this;
        }

        OrderedSourcesBuilder orderSources(Map<String, Source> sources, List<String> order, String orderDescription, JobInfo jobInfo) {
            if (order.size() != sources.size()) {
                String message = String.format("Hostname %s - The %s size (%d) is not equals to the sources size (%d). The sources will not be processed. Context: connector %s, monitor type: %s, job: %s.", jobInfo.getHostname(), orderDescription, order.size(), sources.size(), jobInfo.getConnectorId(), jobInfo.getMonitorType(), jobInfo.getJobName());
                log.error(message);
                throw new IllegalStateException(message);
            }
            this.sources$value = sources.entrySet().stream().sorted(Comparator.comparing(entry -> this.findSourcePosition((String)entry.getKey(), order, orderDescription, jobInfo))).map(Map.Entry::getValue).collect(Collectors.toList());
            this.sources$set = true;
            return this;
        }

        int findSourcePosition(String sourceName, List<String> order, String orderDescription, JobInfo jobInfo) {
            int index = order.indexOf(sourceName);
            if (index == -1) {
                String message = String.format("Hostname %s - The source (%s) listed in the %s is not defined. The sources will not be processed. Context: connector %s, monitor type: %s, job: %s.", jobInfo.getHostname(), sourceName, orderDescription, jobInfo.getConnectorId(), jobInfo.getMonitorType(), jobInfo.getJobName());
                log.error(message);
                throw new IllegalStateException(message);
            }
            return index;
        }

        @Generated
        OrderedSourcesBuilder() {
        }

        @Generated
        public OrderedSources build() {
            List<Source> sources$value = this.sources$value;
            if (!this.sources$set) {
                sources$value = OrderedSources.$default$sources();
            }
            return new OrderedSources(sources$value);
        }

        @Generated
        public String toString() {
            return "OrderedSources.OrderedSourcesBuilder(sources$value=" + String.valueOf(this.sources$value) + ")";
        }
    }
}

