/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.surrounding;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.common.JobInfo;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.extension.ExtensionManager;
import org.sentrysoftware.metricshub.engine.strategy.AbstractStrategy;
import org.sentrysoftware.metricshub.engine.strategy.source.OrderedSources;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SurroundingStrategy
extends AbstractStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SurroundingStrategy.class);
    protected Connector connector;

    protected SurroundingStrategy(@NonNull TelemetryManager telemetryManager, @NonNull Long strategyTime, @NonNull ClientsExecutor clientsExecutor, @NonNull Connector connector, @NonNull ExtensionManager extensionManager) {
        super(telemetryManager, strategyTime, clientsExecutor, extensionManager);
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        if (strategyTime == null) {
            throw new IllegalArgumentException("strategyTime is marked non-null but is null");
        }
        if (clientsExecutor == null) {
            throw new IllegalArgumentException("clientsExecutor is marked non-null but is null");
        }
        if (connector == null) {
            throw new IllegalArgumentException("connector is marked non-null but is null");
        }
        if (extensionManager == null) {
            throw new IllegalArgumentException("extensionManager is marked non-null but is null");
        }
        this.connector = connector;
    }

    @Override
    public void run() {
        String connectorId = this.connector.getCompiledFilename();
        String hostname = this.telemetryManager.getHostname();
        String jobName = this.getJobName();
        Map<String, Source> sources = this.getSurroundingSources();
        if (sources == null || sources.isEmpty()) {
            log.debug("Hostname {} - Attempted to process {} sources, but none are available for connector {}.", new Object[]{hostname, jobName, connectorId});
            return;
        }
        JobInfo jobInfo = JobInfo.builder().hostname(hostname).connectorId(connectorId).jobName(jobName).monitorType("none").build();
        OrderedSources orderedSources = OrderedSources.builder().sources(sources, new ArrayList<String>(), this.getSourceDependencies(), jobInfo).build();
        this.processSourcesAndComputes(orderedSources.getSources(), jobInfo);
    }

    protected abstract Map<String, Source> getSurroundingSources();

    protected abstract String getJobName();

    protected abstract List<Set<String>> getSourceDependencies();

    @Generated
    public Connector getConnector() {
        return this.connector;
    }

    @Generated
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    @Override
    @Generated
    public String toString() {
        return "SurroundingStrategy(connector=" + String.valueOf(this.getConnector()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SurroundingStrategy)) {
            return false;
        }
        SurroundingStrategy other = (SurroundingStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Connector this$connector = this.getConnector();
        Connector other$connector = other.getConnector();
        return !(this$connector == null ? other$connector != null : !((Object)this$connector).equals(other$connector));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SurroundingStrategy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Connector $connector = this.getConnector();
        result = result * 59 + ($connector == null ? 43 : ((Object)$connector).hashCode());
        return result;
    }
}

