/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.telemetry;

import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.alert.AlertRule;
import org.sentrysoftware.metricshub.engine.common.HostLocation;
import org.sentrysoftware.metricshub.engine.common.helpers.KnownMonitorType;
import org.sentrysoftware.metricshub.engine.common.helpers.MetricsHubConstants;
import org.sentrysoftware.metricshub.engine.common.helpers.NetworkHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.configuration.HostConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.common.DeviceKind;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.Resource;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.engine.telemetry.metric.AbstractMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitorFactory.class);
    private Map<String, AbstractMetric> metrics;
    private Map<String, String> attributes;
    private Resource resource;
    private Map<String, List<AlertRule>> alertRules;
    private TelemetryManager telemetryManager;
    private String monitorType;
    private String connectorId;
    @NonNull
    private Long discoveryTime;
    private Set<String> keys;

    public Monitor createOrUpdateMonitor(String id) {
        return this.createOrUpdateMonitor(this.attributes, this.resource, this.monitorType, id);
    }

    public Monitor createOrUpdateMonitor() {
        String keysString = this.keys.stream().map(key -> Optional.ofNullable(this.attributes.get(key)).orElse("")).collect(Collectors.joining("_"));
        String id = MonitorFactory.buildMonitorId(this.connectorId, this.monitorType, keysString);
        return this.createOrUpdateMonitor(this.attributes, this.resource, this.monitorType, id);
    }

    Monitor createOrUpdateMonitor(Map<String, String> attributes, Resource resource, String monitorType, String id) {
        return this.createOrUpdateMonitor(attributes, resource, monitorType, id, this.discoveryTime);
    }

    Monitor createOrUpdateMonitor(Map<String, String> attributes, Resource resource, String monitorType, String id, long discoveryTime) {
        Monitor foundMonitor = this.telemetryManager.findMonitorByTypeAndId(monitorType, id);
        if (foundMonitor != null) {
            foundMonitor.setAttributes(attributes);
            foundMonitor.setResource(resource);
            foundMonitor.setType(monitorType);
            foundMonitor.setDiscoveryTime(discoveryTime);
            this.setConnectorIdAttribute(foundMonitor);
            return foundMonitor;
        }
        Monitor newMonitor = Monitor.builder().resource(resource).attributes(attributes).type(monitorType).id(id).discoveryTime(discoveryTime).build();
        this.setConnectorIdAttribute(newMonitor);
        this.telemetryManager.addNewMonitor(newMonitor, monitorType, id);
        return newMonitor;
    }

    private void setConnectorIdAttribute(Monitor monitor) {
        if (this.connectorId != null) {
            monitor.addAttribute("connector_id", this.connectorId);
        }
    }

    public Monitor createEndpointHostMonitor(boolean isLocalhost) {
        HostConfiguration hostConfiguration = this.telemetryManager.getHostConfiguration();
        String hostname = hostConfiguration.getHostname();
        Map<String, String> monitorAttributes = Map.of("id", this.telemetryManager.getHostConfiguration().getHostId(), "location", isLocalhost ? HostLocation.LOCAL.getKey() : HostLocation.REMOTE.getKey(), "is_endpoint", "true", "name", this.telemetryManager.getHostname());
        DeviceKind deviceKind = hostConfiguration.getHostType();
        String osType = MetricsHubConstants.HOST_TYPE_TO_OTEL_OS_TYPE.getOrDefault((Object)deviceKind, deviceKind.getDisplayName().toLowerCase());
        String hostType = MetricsHubConstants.HOST_TYPE_TO_OTEL_HOST_TYPE.getOrDefault((Object)deviceKind, deviceKind.getDisplayName().toLowerCase());
        Map<String, String> resourceAttributes = Map.of("host.id", hostConfiguration.getHostId(), "host.name", hostConfiguration.isResolveHostnameToFqdn() ? NetworkHelper.getFqdn(hostname) : hostname, "host.type", hostType, "os.type", osType, "agent.host.name", StringHelper.getValue(() -> InetAddress.getLocalHost().getCanonicalHostName(), "unknown"));
        Resource monitorResource = Resource.builder().type("host").attributes(resourceAttributes).build();
        Monitor monitor = this.createOrUpdateMonitor(monitorAttributes, monitorResource, KnownMonitorType.HOST.getKey(), this.telemetryManager.getHostConfiguration().getHostId());
        monitor.setAsEndpoint();
        log.debug("Hostname {} - Created endpoint host ID: {} ", (Object)hostname, (Object)hostConfiguration.getHostId());
        return monitor;
    }

    public static String buildMonitorId(@NonNull String connectorId, @NonNull String monitorType, @NonNull String id) {
        if (connectorId == null) {
            throw new IllegalArgumentException("connectorId is marked non-null but is null");
        }
        if (monitorType == null) {
            throw new IllegalArgumentException("monitorType is marked non-null but is null");
        }
        if (id == null) {
            throw new IllegalArgumentException("id is marked non-null but is null");
        }
        return connectorId + "_" + monitorType + "_" + id.replaceAll("\\s*", "");
    }

    @Generated
    public static MonitorFactoryBuilder builder() {
        return new MonitorFactoryBuilder();
    }

    @Generated
    public Map<String, AbstractMetric> getMetrics() {
        return this.metrics;
    }

    @Generated
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public Resource getResource() {
        return this.resource;
    }

    @Generated
    public Map<String, List<AlertRule>> getAlertRules() {
        return this.alertRules;
    }

    @Generated
    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    @Generated
    public String getMonitorType() {
        return this.monitorType;
    }

    @Generated
    public String getConnectorId() {
        return this.connectorId;
    }

    @NonNull
    @Generated
    public Long getDiscoveryTime() {
        return this.discoveryTime;
    }

    @Generated
    public Set<String> getKeys() {
        return this.keys;
    }

    @Generated
    public void setMetrics(Map<String, AbstractMetric> metrics) {
        this.metrics = metrics;
    }

    @Generated
    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    @Generated
    public void setAlertRules(Map<String, List<AlertRule>> alertRules) {
        this.alertRules = alertRules;
    }

    @Generated
    public void setTelemetryManager(TelemetryManager telemetryManager) {
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public void setMonitorType(String monitorType) {
        this.monitorType = monitorType;
    }

    @Generated
    public void setConnectorId(String connectorId) {
        this.connectorId = connectorId;
    }

    @Generated
    public void setDiscoveryTime(@NonNull Long discoveryTime) {
        if (discoveryTime == null) {
            throw new IllegalArgumentException("discoveryTime is marked non-null but is null");
        }
        this.discoveryTime = discoveryTime;
    }

    @Generated
    public void setKeys(Set<String> keys) {
        this.keys = keys;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonitorFactory)) {
            return false;
        }
        MonitorFactory other = (MonitorFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$discoveryTime = this.getDiscoveryTime();
        Long other$discoveryTime = other.getDiscoveryTime();
        if (this$discoveryTime == null ? other$discoveryTime != null : !((Object)this$discoveryTime).equals(other$discoveryTime)) {
            return false;
        }
        Map<String, AbstractMetric> this$metrics = this.getMetrics();
        Map<String, AbstractMetric> other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        Resource this$resource = this.getResource();
        Resource other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !((Object)this$resource).equals(other$resource)) {
            return false;
        }
        Map<String, List<AlertRule>> this$alertRules = this.getAlertRules();
        Map<String, List<AlertRule>> other$alertRules = other.getAlertRules();
        if (this$alertRules == null ? other$alertRules != null : !((Object)this$alertRules).equals(other$alertRules)) {
            return false;
        }
        TelemetryManager this$telemetryManager = this.getTelemetryManager();
        TelemetryManager other$telemetryManager = other.getTelemetryManager();
        if (this$telemetryManager == null ? other$telemetryManager != null : !((Object)this$telemetryManager).equals(other$telemetryManager)) {
            return false;
        }
        String this$monitorType = this.getMonitorType();
        String other$monitorType = other.getMonitorType();
        if (this$monitorType == null ? other$monitorType != null : !this$monitorType.equals(other$monitorType)) {
            return false;
        }
        String this$connectorId = this.getConnectorId();
        String other$connectorId = other.getConnectorId();
        if (this$connectorId == null ? other$connectorId != null : !this$connectorId.equals(other$connectorId)) {
            return false;
        }
        Set<String> this$keys = this.getKeys();
        Set<String> other$keys = other.getKeys();
        return !(this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MonitorFactory;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $discoveryTime = this.getDiscoveryTime();
        result = result * 59 + ($discoveryTime == null ? 43 : ((Object)$discoveryTime).hashCode());
        Map<String, AbstractMetric> $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        Resource $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : ((Object)$resource).hashCode());
        Map<String, List<AlertRule>> $alertRules = this.getAlertRules();
        result = result * 59 + ($alertRules == null ? 43 : ((Object)$alertRules).hashCode());
        TelemetryManager $telemetryManager = this.getTelemetryManager();
        result = result * 59 + ($telemetryManager == null ? 43 : ((Object)$telemetryManager).hashCode());
        String $monitorType = this.getMonitorType();
        result = result * 59 + ($monitorType == null ? 43 : $monitorType.hashCode());
        String $connectorId = this.getConnectorId();
        result = result * 59 + ($connectorId == null ? 43 : $connectorId.hashCode());
        Set<String> $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MonitorFactory(metrics=" + String.valueOf(this.getMetrics()) + ", attributes=" + String.valueOf(this.getAttributes()) + ", resource=" + String.valueOf(this.getResource()) + ", alertRules=" + String.valueOf(this.getAlertRules()) + ", telemetryManager=" + String.valueOf(this.getTelemetryManager()) + ", monitorType=" + this.getMonitorType() + ", connectorId=" + this.getConnectorId() + ", discoveryTime=" + this.getDiscoveryTime() + ", keys=" + String.valueOf(this.getKeys()) + ")";
    }

    @Generated
    public MonitorFactory(Map<String, AbstractMetric> metrics, Map<String, String> attributes, Resource resource, Map<String, List<AlertRule>> alertRules, TelemetryManager telemetryManager, String monitorType, String connectorId, @NonNull Long discoveryTime, Set<String> keys) {
        if (discoveryTime == null) {
            throw new IllegalArgumentException("discoveryTime is marked non-null but is null");
        }
        this.metrics = metrics;
        this.attributes = attributes;
        this.resource = resource;
        this.alertRules = alertRules;
        this.telemetryManager = telemetryManager;
        this.monitorType = monitorType;
        this.connectorId = connectorId;
        this.discoveryTime = discoveryTime;
        this.keys = keys;
    }

    @Generated
    public MonitorFactory() {
    }

    @Generated
    public static class MonitorFactoryBuilder {
        @Generated
        private Map<String, AbstractMetric> metrics;
        @Generated
        private Map<String, String> attributes;
        @Generated
        private Resource resource;
        @Generated
        private Map<String, List<AlertRule>> alertRules;
        @Generated
        private TelemetryManager telemetryManager;
        @Generated
        private String monitorType;
        @Generated
        private String connectorId;
        @Generated
        private Long discoveryTime;
        @Generated
        private Set<String> keys;

        @Generated
        MonitorFactoryBuilder() {
        }

        @Generated
        public MonitorFactoryBuilder metrics(Map<String, AbstractMetric> metrics) {
            this.metrics = metrics;
            return this;
        }

        @Generated
        public MonitorFactoryBuilder attributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        @Generated
        public MonitorFactoryBuilder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        @Generated
        public MonitorFactoryBuilder alertRules(Map<String, List<AlertRule>> alertRules) {
            this.alertRules = alertRules;
            return this;
        }

        @Generated
        public MonitorFactoryBuilder telemetryManager(TelemetryManager telemetryManager) {
            this.telemetryManager = telemetryManager;
            return this;
        }

        @Generated
        public MonitorFactoryBuilder monitorType(String monitorType) {
            this.monitorType = monitorType;
            return this;
        }

        @Generated
        public MonitorFactoryBuilder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        @Generated
        public MonitorFactoryBuilder discoveryTime(@NonNull Long discoveryTime) {
            if (discoveryTime == null) {
                throw new IllegalArgumentException("discoveryTime is marked non-null but is null");
            }
            this.discoveryTime = discoveryTime;
            return this;
        }

        @Generated
        public MonitorFactoryBuilder keys(Set<String> keys) {
            this.keys = keys;
            return this;
        }

        @Generated
        public MonitorFactory build() {
            return new MonitorFactory(this.metrics, this.attributes, this.resource, this.alertRules, this.telemetryManager, this.monitorType, this.connectorId, this.discoveryTime, this.keys);
        }

        @Generated
        public String toString() {
            return "MonitorFactory.MonitorFactoryBuilder(metrics=" + String.valueOf(this.metrics) + ", attributes=" + String.valueOf(this.attributes) + ", resource=" + String.valueOf(this.resource) + ", alertRules=" + String.valueOf(this.alertRules) + ", telemetryManager=" + String.valueOf(this.telemetryManager) + ", monitorType=" + this.monitorType + ", connectorId=" + this.connectorId + ", discoveryTime=" + this.discoveryTime + ", keys=" + String.valueOf(this.keys) + ")";
        }
    }
}

