/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.Event;
import com.vmware.vim25.EventArgDesc;
import com.vmware.vim25.EventDescription;
import com.vmware.vim25.EventFilterSpec;
import com.vmware.vim25.InvalidEvent;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.TaskInfo;
import com.vmware.vim25.mo.EventHistoryCollector;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import java.rmi.RemoteException;

public class EventManager
extends ManagedObject {
    public EventManager(ServerConnection serverConnection, ManagedObjectReference mor) {
        super(serverConnection, mor);
    }

    public EventDescription getDescription() {
        return (EventDescription)this.getCurrentProperty("description");
    }

    public Event getLatestEvent() {
        return (Event)this.getCurrentProperty("latestEvent");
    }

    public int getMaxCollector() {
        return (Integer)this.getCurrentProperty("maxCollector");
    }

    public EventHistoryCollector createCollectorForEvents(EventFilterSpec filter) throws InvalidState, RuntimeFault, RemoteException {
        return new EventHistoryCollector(this.getServerConnection(), this.getVimService().createCollectorForEvents(this.getMOR(), filter));
    }

    public void logUserEvent(ManagedEntity entity, String msg) throws RuntimeFault, RemoteException {
        if (entity == null) {
            throw new IllegalArgumentException("entity must not be null.");
        }
        this.getVimService().logUserEvent(this.getMOR(), entity.getMOR(), msg);
    }

    public void postEvent(Event eventToPost, TaskInfo taskInfo) throws InvalidEvent, RuntimeFault, RemoteException {
        this.getVimService().postEvent(this.getMOR(), eventToPost, taskInfo);
    }

    public Event[] queryEvents(EventFilterSpec filter) throws RuntimeFault, RemoteException {
        return this.getVimService().queryEvents(this.getMOR(), filter);
    }

    public EventArgDesc[] retrieveArgumentDescription(String eventTypeId) throws RuntimeFault, RemoteException {
        return this.getVimService().retrieveArgumentDescription(this.getMOR(), eventTypeId);
    }
}

