/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.wbem;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.TransportProtocols;
import org.sentrysoftware.metricshub.engine.deserialization.MultiValueDeserializer;
import org.sentrysoftware.metricshub.engine.deserialization.TimeDeserializer;

public class WbemConfiguration
implements IConfiguration {
    @JsonSetter(nulls=Nulls.SKIP)
    private final TransportProtocols protocol;
    @JsonSetter(nulls=Nulls.SKIP)
    private final Integer port;
    private String namespace;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=TimeDeserializer.class)
    private final Long timeout;
    String username;
    char[] password;
    String vCenter;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=MultiValueDeserializer.class)
    private String hostname;

    public String toString() {
        String description = String.valueOf(this.protocol) + "/" + this.port;
        if (this.username != null) {
            description = description + " as " + this.username;
        }
        return description;
    }

    public void validateConfiguration(String resourceKey) throws InvalidConfigurationException {
        StringHelper.validateConfigurationAttribute((Object)this.timeout, attr -> attr == null || attr < 0L, () -> String.format("Resource %s - Timeout value is invalid for protocol %s. Timeout value returned: %s. This resource will not be monitored. Please verify the configured timeout value.", resourceKey, "WBEM", this.timeout));
        StringHelper.validateConfigurationAttribute((Object)this.port, attr -> attr == null || attr < 1 || attr > 65535, () -> String.format("Resource %s - Invalid port configured for protocol %s. Port value returned: %s. This resource will not be monitored. Please verify the configured port value.", resourceKey, "WBEM", this.port));
        StringHelper.validateConfigurationAttribute((Object)this.username, attr -> attr != null && attr.isBlank(), () -> String.format("Resource %s - No username configured for protocol %s. This resource will not be monitored. Please verify the configured username.", resourceKey, "WBEM"));
        StringHelper.validateConfigurationAttribute((Object)this.vCenter, attr -> attr != null && attr.isBlank(), () -> String.format("Resource %s - vCenter value is invalid for protocol %s. This resource will not be monitored. Please verify the configured vCenter value.", resourceKey, "WBEM"));
    }

    public IConfiguration copy() {
        return WbemConfiguration.builder().namespace(this.namespace).password(this.password).port(this.port).protocol(this.protocol).timeout(this.timeout).username(this.username).vCenter(this.vCenter).hostname(this.hostname).build();
    }

    @Generated
    private static TransportProtocols $default$protocol() {
        return TransportProtocols.HTTPS;
    }

    @Generated
    private static Integer $default$port() {
        return 5989;
    }

    @Generated
    private static Long $default$timeout() {
        return 120L;
    }

    @Generated
    public static WbemConfigurationBuilder builder() {
        return new WbemConfigurationBuilder();
    }

    @Generated
    public TransportProtocols getProtocol() {
        return this.protocol;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public Long getTimeout() {
        return this.timeout;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Generated
    public String getVCenter() {
        return this.vCenter;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Generated
    public void setVCenter(String vCenter) {
        this.vCenter = vCenter;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=MultiValueDeserializer.class)
    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WbemConfiguration)) {
            return false;
        }
        WbemConfiguration other = (WbemConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Long this$timeout = this.getTimeout();
        Long other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        TransportProtocols this$protocol = this.getProtocol();
        TransportProtocols other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        String this$vCenter = this.getVCenter();
        String other$vCenter = other.getVCenter();
        if (this$vCenter == null ? other$vCenter != null : !this$vCenter.equals(other$vCenter)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        return !(this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WbemConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Long $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        TransportProtocols $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        String $vCenter = this.getVCenter();
        result = result * 59 + ($vCenter == null ? 43 : $vCenter.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        return result;
    }

    @Generated
    public WbemConfiguration(TransportProtocols protocol, Integer port, String namespace, Long timeout, String username, char[] password, String vCenter, String hostname) {
        this.protocol = protocol;
        this.port = port;
        this.namespace = namespace;
        this.timeout = timeout;
        this.username = username;
        this.password = password;
        this.vCenter = vCenter;
        this.hostname = hostname;
    }

    @Generated
    public WbemConfiguration() {
        this.protocol = WbemConfiguration.$default$protocol();
        this.port = WbemConfiguration.$default$port();
        this.timeout = WbemConfiguration.$default$timeout();
    }

    @Generated
    public static class WbemConfigurationBuilder {
        @Generated
        private boolean protocol$set;
        @Generated
        private TransportProtocols protocol$value;
        @Generated
        private boolean port$set;
        @Generated
        private Integer port$value;
        @Generated
        private String namespace;
        @Generated
        private boolean timeout$set;
        @Generated
        private Long timeout$value;
        @Generated
        private String username;
        @Generated
        private char[] password;
        @Generated
        private String vCenter;
        @Generated
        private String hostname;

        @Generated
        WbemConfigurationBuilder() {
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public WbemConfigurationBuilder protocol(TransportProtocols protocol) {
            this.protocol$value = protocol;
            this.protocol$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public WbemConfigurationBuilder port(Integer port) {
            this.port$value = port;
            this.port$set = true;
            return this;
        }

        @Generated
        public WbemConfigurationBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=TimeDeserializer.class)
        @Generated
        public WbemConfigurationBuilder timeout(Long timeout) {
            this.timeout$value = timeout;
            this.timeout$set = true;
            return this;
        }

        @Generated
        public WbemConfigurationBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public WbemConfigurationBuilder password(char[] password) {
            this.password = password;
            return this;
        }

        @Generated
        public WbemConfigurationBuilder vCenter(String vCenter) {
            this.vCenter = vCenter;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=MultiValueDeserializer.class)
        @Generated
        public WbemConfigurationBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @Generated
        public WbemConfiguration build() {
            TransportProtocols protocol$value = this.protocol$value;
            if (!this.protocol$set) {
                protocol$value = WbemConfiguration.$default$protocol();
            }
            Integer port$value = this.port$value;
            if (!this.port$set) {
                port$value = WbemConfiguration.$default$port();
            }
            Long timeout$value = this.timeout$value;
            if (!this.timeout$set) {
                timeout$value = WbemConfiguration.$default$timeout();
            }
            return new WbemConfiguration(protocol$value, port$value, this.namespace, timeout$value, this.username, this.password, this.vCenter, this.hostname);
        }

        @Generated
        public String toString() {
            return "WbemConfiguration.WbemConfigurationBuilder(protocol$value=" + String.valueOf(this.protocol$value) + ", port$value=" + this.port$value + ", namespace=" + this.namespace + ", timeout$value=" + this.timeout$value + ", username=" + this.username + ", password=" + Arrays.toString(this.password) + ", vCenter=" + this.vCenter + ", hostname=" + this.hostname + ")";
        }
    }
}

