/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.wbem;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.exception.ClientException;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.WbemCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.WqlCriterion;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.strategy.utils.PslUtils;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.wbem.WbemConfiguration;
import org.sentrysoftware.metricshub.extension.wbem.WbemRequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WbemCriterionProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WbemCriterionProcessor.class);
    private static final String SELECT_NAME_FROM_CIM_NAMESPACE = "SELECT Name from CIM_Namespace";
    private static final Set<String> IGNORED_WBEM_NAMESPACES = Set.of("root", "/root");
    private static final String INTEROP_LOWER_CASE = "interop";
    private static final String ROOT_SLASH = "root/";
    static final List<WqlQuery> WBEM_INTEROP_QUERIES = List.of(new WqlQuery("SELECT Name FROM __NAMESPACE", "root"), new WqlQuery("SELECT Name from CIM_Namespace", "Interop"), new WqlQuery("SELECT Name from CIM_Namespace", "PG_Interop"), new WqlQuery("SELECT Name from CIM_Namespace", "root/Interop"), new WqlQuery("SELECT Name from CIM_Namespace", "root/PG_Interop"), new WqlQuery("SELECT Name from CIM_Namespace", "interop"));
    @NonNull
    private WbemRequestExecutor wbemRequestExecutor;
    @NonNull
    private String connectorId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CriterionTestResult findNamespace(String hostname, WbemConfiguration wbemConfiguration, WbemCriterion wbemCriterion, TelemetryManager telemetryManager, String connectorId) {
        Set possibleWbemNamespaces;
        Set set = possibleWbemNamespaces = telemetryManager.getHostProperties().getPossibleWbemNamespaces();
        synchronized (set) {
            if (possibleWbemNamespaces.isEmpty()) {
                PossibleNamespacesResult possibleWbemNamespacesResult = this.findPossibleNamespaces(hostname, wbemConfiguration, telemetryManager);
                if (!possibleWbemNamespacesResult.isSuccess()) {
                    return CriterionTestResult.error((Criterion)wbemCriterion, (String)possibleWbemNamespacesResult.getErrorMessage());
                }
                possibleWbemNamespaces.clear();
                possibleWbemNamespaces.addAll(possibleWbemNamespacesResult.getPossibleNamespaces());
            }
        }
        NamespaceResult namespaceResult = this.detectNamespace(hostname, wbemConfiguration, (WqlCriterion)wbemCriterion, Collections.unmodifiableSet(possibleWbemNamespaces), telemetryManager);
        if (namespaceResult.getResult().isSuccess()) {
            telemetryManager.getHostProperties().getConnectorNamespace(connectorId).setAutomaticWbemNamespace(namespaceResult.getNamespace());
        }
        return namespaceResult.getResult();
    }

    private NamespaceResult detectNamespace(String hostname, WbemConfiguration configuration, WqlCriterion criterion, Set<String> possibleNamespaces, TelemetryManager telemetryManager) {
        TreeMap<String, CriterionTestResult> namespaces = new TreeMap<String, CriterionTestResult>();
        WqlCriterion tentativeCriterion = criterion.copy();
        for (String namespace : possibleNamespaces) {
            tentativeCriterion.setNamespace(namespace);
            CriterionTestResult testResult = this.performDetectionTest(hostname, configuration, tentativeCriterion, telemetryManager);
            if (testResult.isSuccess()) {
                namespaces.put(namespace, testResult);
                continue;
            }
            Throwable e = testResult.getException();
            if (e == null || this.wbemRequestExecutor.isAcceptableException(e)) continue;
            log.debug("Hostname {} - Does not respond to {} requests. {}: {}\nCancelling namespace detection.", new Object[]{hostname, criterion.getClass().getSimpleName(), e.getClass().getSimpleName(), e.getMessage()});
            return NamespaceResult.builder().result(testResult).build();
        }
        if (namespaces.isEmpty()) {
            String formattedNamespaceList = possibleNamespaces.stream().collect(Collectors.joining("\n- "));
            return NamespaceResult.builder().result(CriterionTestResult.failure((Criterion)criterion, (String)("None of the possible namespaces match the criterion:" + formattedNamespaceList))).build();
        }
        if (namespaces.size() > 1) {
            namespaces.remove("root/cimv2");
            namespaces.remove("root\\cimv2");
        }
        String detectedNamespace = (String)namespaces.keySet().stream().findFirst().orElseThrow();
        return NamespaceResult.builder().namespace(detectedNamespace).result((CriterionTestResult)namespaces.get(detectedNamespace)).build();
    }

    private PossibleNamespacesResult findPossibleNamespaces(String hostname, WbemConfiguration configuration, TelemetryManager telemetryManager) {
        if (configuration.getNamespace() != null && !configuration.getNamespace().isBlank()) {
            return PossibleNamespacesResult.builder().possibleNamespaces(Collections.singleton(configuration.getNamespace())).success(true).build();
        }
        TreeSet<String> possibleWbemNamespaces = new TreeSet<String>();
        for (WqlQuery interopQuery : WBEM_INTEROP_QUERIES) {
            try {
                this.wbemRequestExecutor.executeWbem(hostname, configuration, interopQuery.getWql(), interopQuery.getNamespace(), telemetryManager).stream().filter(row -> !row.isEmpty()).map(row -> (String)row.get(0)).filter(Objects::nonNull).filter(namespace -> !namespace.isBlank()).filter(namespace -> !namespace.toLowerCase().contains(INTEROP_LOWER_CASE)).filter(namespace -> !IGNORED_WBEM_NAMESPACES.contains(namespace)).map(namespace -> ROOT_SLASH + namespace).forEach(possibleWbemNamespaces::add);
            }
            catch (ClientException e) {
                if (this.wbemRequestExecutor.isAcceptableException(e)) continue;
                Throwable cause = e.getCause();
                String messageFormat = "Hostname %s - Does not respond to WBEM requests. %s: %s\nCancelling namespace detection.";
                String message = String.format("Hostname %s - Does not respond to WBEM requests. %s: %s\nCancelling namespace detection.", hostname, cause != null ? cause.getClass().getSimpleName() : ((Object)((Object)e)).getClass().getSimpleName(), cause != null ? cause.getMessage() : e.getMessage());
                log.debug(message);
                return PossibleNamespacesResult.builder().errorMessage(message).success(false).build();
            }
        }
        if (possibleWbemNamespaces.isEmpty()) {
            return PossibleNamespacesResult.builder().errorMessage("No suitable namespace could be found to query host " + hostname + ".").success(false).build();
        }
        return PossibleNamespacesResult.builder().possibleNamespaces(possibleWbemNamespaces).success(true).build();
    }

    private CriterionTestResult performDetectionTest(String hostname, @NonNull WbemConfiguration configuration, @NonNull WqlCriterion criterion, @NonNull TelemetryManager telemetryManager) {
        List<List<String>> queryResult;
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is marked non-null but is null");
        }
        if (criterion == null) {
            throw new IllegalArgumentException("criterion is marked non-null but is null");
        }
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        try {
            queryResult = this.wbemRequestExecutor.executeWbem(hostname, configuration, criterion.getQuery(), criterion.getNamespace(), telemetryManager);
        }
        catch (ClientException e) {
            return CriterionTestResult.error((Criterion)criterion, (Throwable)e);
        }
        String actualResult = SourceTable.tableToCsv(queryResult, (String)";", (boolean)true);
        if (actualResult == null || actualResult.isBlank()) {
            return CriterionTestResult.failure((Criterion)criterion, (String)"No result.");
        }
        if (criterion.getExpectedResult() == null || criterion.getExpectedResult().isBlank()) {
            return CriterionTestResult.success((Criterion)criterion, (String)actualResult);
        }
        Matcher matcher = Pattern.compile(PslUtils.psl2JavaRegex((String)criterion.getExpectedResult()), 10).matcher(actualResult);
        if (matcher.find()) {
            return CriterionTestResult.success((Criterion)criterion, (String)matcher.group());
        }
        return CriterionTestResult.failure((Criterion)criterion, (String)actualResult);
    }

    public CriterionTestResult process(WbemCriterion wbemCriterion, TelemetryManager telemetryManager) {
        if (wbemCriterion == null) {
            return CriterionTestResult.error((Criterion)wbemCriterion, (String)"Malformed criterion. Cannot perform detection.");
        }
        WbemConfiguration wbemConfiguration = (WbemConfiguration)telemetryManager.getHostConfiguration().getConfigurations().get(WbemConfiguration.class);
        if (wbemConfiguration == null) {
            return CriterionTestResult.error((Criterion)wbemCriterion, (String)"The WBEM credentials are not configured for this host.");
        }
        String hostname = telemetryManager.getHostname(List.of(WbemConfiguration.class));
        if ("automatic".equalsIgnoreCase(wbemCriterion.getNamespace())) {
            String cachedNamespace = telemetryManager.getHostProperties().getConnectorNamespace(this.connectorId).getAutomaticWbemNamespace();
            if (cachedNamespace == null) {
                return this.findNamespace(hostname, wbemConfiguration, wbemCriterion, telemetryManager, this.connectorId);
            }
            WbemCriterion cachedNamespaceCriterion = wbemCriterion.copy();
            cachedNamespaceCriterion.setNamespace(cachedNamespace);
            return this.performDetectionTest(hostname, wbemConfiguration, (WqlCriterion)cachedNamespaceCriterion, telemetryManager);
        }
        return this.performDetectionTest(hostname, wbemConfiguration, (WqlCriterion)wbemCriterion, telemetryManager);
    }

    @Generated
    public WbemCriterionProcessor(@NonNull WbemRequestExecutor wbemRequestExecutor, @NonNull String connectorId) {
        if (wbemRequestExecutor == null) {
            throw new IllegalArgumentException("wbemRequestExecutor is marked non-null but is null");
        }
        if (connectorId == null) {
            throw new IllegalArgumentException("connectorId is marked non-null but is null");
        }
        this.wbemRequestExecutor = wbemRequestExecutor;
        this.connectorId = connectorId;
    }

    public static class PossibleNamespacesResult {
        private Set<String> possibleNamespaces;
        private boolean success;
        private String errorMessage;

        @Generated
        PossibleNamespacesResult(Set<String> possibleNamespaces, boolean success, String errorMessage) {
            this.possibleNamespaces = possibleNamespaces;
            this.success = success;
            this.errorMessage = errorMessage;
        }

        @Generated
        public static PossibleNamespacesResultBuilder builder() {
            return new PossibleNamespacesResultBuilder();
        }

        @Generated
        public Set<String> getPossibleNamespaces() {
            return this.possibleNamespaces;
        }

        @Generated
        public boolean isSuccess() {
            return this.success;
        }

        @Generated
        public String getErrorMessage() {
            return this.errorMessage;
        }

        @Generated
        public void setPossibleNamespaces(Set<String> possibleNamespaces) {
            this.possibleNamespaces = possibleNamespaces;
        }

        @Generated
        public void setSuccess(boolean success) {
            this.success = success;
        }

        @Generated
        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PossibleNamespacesResult)) {
                return false;
            }
            PossibleNamespacesResult other = (PossibleNamespacesResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            Set<String> this$possibleNamespaces = this.getPossibleNamespaces();
            Set<String> other$possibleNamespaces = other.getPossibleNamespaces();
            if (this$possibleNamespaces == null ? other$possibleNamespaces != null : !((Object)this$possibleNamespaces).equals(other$possibleNamespaces)) {
                return false;
            }
            String this$errorMessage = this.getErrorMessage();
            String other$errorMessage = other.getErrorMessage();
            return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PossibleNamespacesResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            Set<String> $possibleNamespaces = this.getPossibleNamespaces();
            result = result * 59 + ($possibleNamespaces == null ? 43 : ((Object)$possibleNamespaces).hashCode());
            String $errorMessage = this.getErrorMessage();
            result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WbemCriterionProcessor.PossibleNamespacesResult(possibleNamespaces=" + String.valueOf(this.getPossibleNamespaces()) + ", success=" + this.isSuccess() + ", errorMessage=" + this.getErrorMessage() + ")";
        }

        @Generated
        public static class PossibleNamespacesResultBuilder {
            @Generated
            private Set<String> possibleNamespaces;
            @Generated
            private boolean success;
            @Generated
            private String errorMessage;

            @Generated
            PossibleNamespacesResultBuilder() {
            }

            @Generated
            public PossibleNamespacesResultBuilder possibleNamespaces(Set<String> possibleNamespaces) {
                this.possibleNamespaces = possibleNamespaces;
                return this;
            }

            @Generated
            public PossibleNamespacesResultBuilder success(boolean success) {
                this.success = success;
                return this;
            }

            @Generated
            public PossibleNamespacesResultBuilder errorMessage(String errorMessage) {
                this.errorMessage = errorMessage;
                return this;
            }

            @Generated
            public PossibleNamespacesResult build() {
                return new PossibleNamespacesResult(this.possibleNamespaces, this.success, this.errorMessage);
            }

            @Generated
            public String toString() {
                return "WbemCriterionProcessor.PossibleNamespacesResult.PossibleNamespacesResultBuilder(possibleNamespaces=" + String.valueOf(this.possibleNamespaces) + ", success=" + this.success + ", errorMessage=" + this.errorMessage + ")";
            }
        }
    }

    public static class NamespaceResult {
        private String namespace;
        private CriterionTestResult result;

        @Generated
        NamespaceResult(String namespace, CriterionTestResult result) {
            this.namespace = namespace;
            this.result = result;
        }

        @Generated
        public static NamespaceResultBuilder builder() {
            return new NamespaceResultBuilder();
        }

        @Generated
        public String getNamespace() {
            return this.namespace;
        }

        @Generated
        public CriterionTestResult getResult() {
            return this.result;
        }

        @Generated
        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Generated
        public void setResult(CriterionTestResult result) {
            this.result = result;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NamespaceResult)) {
                return false;
            }
            NamespaceResult other = (NamespaceResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                return false;
            }
            CriterionTestResult this$result = this.getResult();
            CriterionTestResult other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NamespaceResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            CriterionTestResult $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WbemCriterionProcessor.NamespaceResult(namespace=" + this.getNamespace() + ", result=" + String.valueOf(this.getResult()) + ")";
        }

        @Generated
        public static class NamespaceResultBuilder {
            @Generated
            private String namespace;
            @Generated
            private CriterionTestResult result;

            @Generated
            NamespaceResultBuilder() {
            }

            @Generated
            public NamespaceResultBuilder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            @Generated
            public NamespaceResultBuilder result(CriterionTestResult result) {
                this.result = result;
                return this;
            }

            @Generated
            public NamespaceResult build() {
                return new NamespaceResult(this.namespace, this.result);
            }

            @Generated
            public String toString() {
                return "WbemCriterionProcessor.NamespaceResult.NamespaceResultBuilder(namespace=" + this.namespace + ", result=" + String.valueOf(this.result) + ")";
            }
        }
    }

    static class WqlQuery {
        private String wql;
        private String namespace;

        WqlQuery(String wql, String namespace) {
            this.wql = wql;
            this.namespace = namespace;
        }

        @Generated
        public String getWql() {
            return this.wql;
        }

        @Generated
        public String getNamespace() {
            return this.namespace;
        }

        @Generated
        public void setWql(String wql) {
            this.wql = wql;
        }

        @Generated
        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WqlQuery)) {
                return false;
            }
            WqlQuery other = (WqlQuery)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$wql = this.getWql();
            String other$wql = other.getWql();
            if (this$wql == null ? other$wql != null : !this$wql.equals(other$wql)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            return !(this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WqlQuery;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $wql = this.getWql();
            result = result * 59 + ($wql == null ? 43 : $wql.hashCode());
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WbemCriterionProcessor.WqlQuery(wql=" + this.getWql() + ", namespace=" + this.getNamespace() + ")";
        }
    }
}

