/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.wbem;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.TextTableHelper;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.WbemCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.WbemSource;
import org.sentrysoftware.metricshub.engine.extension.IProtocolExtension;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.wbem.WbemConfiguration;
import org.sentrysoftware.metricshub.extension.wbem.WbemCriterionProcessor;
import org.sentrysoftware.metricshub.extension.wbem.WbemRequestExecutor;
import org.sentrysoftware.metricshub.extension.wbem.WbemSourceProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WbemExtension
implements IProtocolExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WbemExtension.class);
    private static final String INTEROP_LOWER_CASE = "interop";
    public static final List<String> WBEM_UP_TEST_NAMESPACES = List.of("root/Interop", "interop", "root/PG_Interop", "PG_Interop");
    public static final String WBEM_TEST_QUERY = "SELECT Name FROM CIM_NameSpace";
    private static final String IDENTIFIER = "wbem";
    private WbemRequestExecutor wbemRequestExecutor = new WbemRequestExecutor();

    public boolean isValidConfiguration(IConfiguration configuration) {
        return configuration instanceof WbemConfiguration;
    }

    public Set<Class<? extends Source>> getSupportedSources() {
        return Set.of(WbemSource.class);
    }

    public Map<Class<? extends IConfiguration>, Set<Class<? extends Source>>> getConfigurationToSourceMapping() {
        return Map.of(WbemConfiguration.class, Set.of(WbemSource.class));
    }

    public Set<Class<? extends Criterion>> getSupportedCriteria() {
        return Set.of(WbemCriterion.class);
    }

    public Optional<Boolean> checkProtocol(TelemetryManager telemetryManager) {
        String hostname = telemetryManager.getHostname(List.of(WbemConfiguration.class));
        List<List<String>> wbemResult = null;
        WbemConfiguration wbemConfiguration = (WbemConfiguration)telemetryManager.getHostConfiguration().getConfigurations().get(WbemConfiguration.class);
        if (wbemConfiguration == null) {
            return Optional.empty();
        }
        log.info("Hostname {} - Performing {} protocol health check.", (Object)hostname, (Object)this.getIdentifier());
        log.info("Hostname {} - Checking WBEM protocol status. Sending a WQL SELECT request on different namespaces.", (Object)hostname);
        for (String wbemNamespace : WBEM_UP_TEST_NAMESPACES) {
            try {
                log.info("Hostname {} - Checking WBEM protocol status. Sending a WQL SELECT request on {} namespace.", (Object)hostname, (Object)wbemNamespace);
                wbemResult = this.wbemRequestExecutor.executeWbem(hostname, wbemConfiguration, WBEM_TEST_QUERY, wbemNamespace, telemetryManager);
            }
            catch (Exception e) {
                if (this.wbemRequestExecutor.isAcceptableException(e)) {
                    return Optional.of(true);
                }
                log.debug("Hostname {} - Checking WBEM protocol status. WBEM exception when performing a WQL SELECT query on '{}' namespace: ", new Object[]{hostname, wbemNamespace, e});
            }
        }
        return Optional.of(wbemResult != null);
    }

    public CriterionTestResult processCriterion(Criterion criterion, String connectorId, TelemetryManager telemetryManager) {
        if (criterion instanceof WbemCriterion) {
            WbemCriterion wbemCriterion = (WbemCriterion)criterion;
            return new WbemCriterionProcessor(this.wbemRequestExecutor, connectorId).process(wbemCriterion, telemetryManager);
        }
        throw new IllegalArgumentException(String.format("Hostname %s - Cannot process criterion %s.", telemetryManager.getHostname(), criterion != null ? criterion.getClass().getSimpleName() : "<null>"));
    }

    public SourceTable processSource(Source source, String connectorId, TelemetryManager telemetryManager) {
        if (source instanceof WbemSource) {
            WbemSource wbemSource = (WbemSource)source;
            return new WbemSourceProcessor(this.wbemRequestExecutor, connectorId).process(wbemSource, telemetryManager);
        }
        throw new IllegalArgumentException(String.format("Hostname %s - Cannot process source %s.", telemetryManager.getHostname(), source != null ? source.getClass().getSimpleName() : "<null>"));
    }

    public boolean isSupportedConfigurationType(String configurationType) {
        return IDENTIFIER.equalsIgnoreCase(configurationType);
    }

    public IConfiguration buildConfiguration(String configurationType, JsonNode jsonNode, UnaryOperator<char[]> decrypt) throws InvalidConfigurationException {
        try {
            WbemConfiguration wbemConfiguration = (WbemConfiguration)WbemExtension.newObjectMapper().treeToValue((TreeNode)jsonNode, WbemConfiguration.class);
            if (decrypt != null) {
                char[] passwordDecrypted = (char[])decrypt.apply(wbemConfiguration.getPassword());
                wbemConfiguration.setPassword(passwordDecrypted);
            }
            return wbemConfiguration;
        }
        catch (Exception e) {
            String errorMessage = String.format("Error while reading WBEM Configuration. Error: %s", e.getMessage());
            log.error(errorMessage);
            log.debug("Error while reading WBEM Configuration. Stack trace:", (Throwable)e);
            throw new InvalidConfigurationException(errorMessage, (Throwable)e);
        }
    }

    public static JsonMapper newObjectMapper() {
        return (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder((JsonFactory)new YAMLFactory()).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false)).build();
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String executeQuery(IConfiguration configuration, JsonNode queryNode) throws Exception {
        WbemConfiguration wbemConfiguration = (WbemConfiguration)configuration;
        String query = queryNode.get("query").asText();
        List<List<String>> result = this.wbemRequestExecutor.executeWbem(configuration.getHostname(), wbemConfiguration, query, wbemConfiguration.getNamespace(), new TelemetryManager());
        String[] columns = StringHelper.extractColumns((String)query);
        if (columns.length == 1 && columns[0].equals("*")) {
            return TextTableHelper.generateTextTable(result);
        }
        return TextTableHelper.generateTextTable((String[])columns, result);
    }
}

