/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.wbem;

import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.net.URI;
import java.net.URL;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.exception.ClientException;
import org.sentrysoftware.metricshub.engine.common.helpers.LoggingHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.TextTableHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.ThreadHelper;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.wbem.WbemConfiguration;
import org.sentrysoftware.vcenter.VCenterClient;
import org.sentrysoftware.wbem.client.WbemExecutor;
import org.sentrysoftware.wbem.client.WbemQueryResult;
import org.sentrysoftware.wbem.client.exceptions.WqlQuerySyntaxException;
import org.sentrysoftware.wbem.javax.wbem.WBEMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WbemRequestExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WbemRequestExecutor.class);
    public static final int CIM_ERR_INVALID_NAMESPACE = 3;
    public static final int CIM_ERR_INVALID_CLASS = 5;
    public static final int CIM_ERR_NOT_FOUND = 6;

    @WithSpan(value="WBEM")
    public List<List<String>> executeWbem(@SpanAttribute(value="host.hostname") @NonNull String hostname, @SpanAttribute(value="wbem.config") @NonNull WbemConfiguration wbemConfig, @SpanAttribute(value="wbem.query") @NonNull String query, @SpanAttribute(value="wbem.namespace") @NonNull String namespace, @NonNull TelemetryManager telemetryManager) throws ClientException {
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (wbemConfig == null) {
            throw new IllegalArgumentException("wbemConfig is marked non-null but is null");
        }
        if (query == null) {
            throw new IllegalArgumentException("query is marked non-null but is null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("namespace is marked non-null but is null");
        }
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        if (wbemConfig.getVCenter() != null) {
            return this.doVCenterQuery(hostname, wbemConfig, query, namespace, telemetryManager);
        }
        return this.doWbemQuery(hostname, wbemConfig, query, namespace);
    }

    private List<List<String>> doVCenterQuery(@NonNull String hostname, @NonNull WbemConfiguration wbemConfig, @NonNull String query, @NonNull String namespace, @NonNull TelemetryManager telemetryManager) throws ClientException {
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (wbemConfig == null) {
            throw new IllegalArgumentException("wbemConfig is marked non-null but is null");
        }
        if (query == null) {
            throw new IllegalArgumentException("query is marked non-null but is null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("namespace is marked non-null but is null");
        }
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        String ticket = telemetryManager.getHostProperties().getVCenterTicket();
        if (ticket == null) {
            ticket = this.refreshVCenterTicket(wbemConfig.getVCenter(), wbemConfig.getUsername(), wbemConfig.getPassword(), hostname, wbemConfig.getTimeout());
        }
        WbemConfiguration vCenterWbemConfig = WbemConfiguration.builder().username(ticket).password(ticket.toCharArray()).namespace(wbemConfig.getNamespace()).port(wbemConfig.getPort()).protocol(wbemConfig.getProtocol()).timeout(wbemConfig.getTimeout()).build();
        try {
            List<List<String>> list = this.doWbemQuery(hostname, vCenterWbemConfig, query, namespace);
            return list;
        }
        catch (ClientException e) {
            if (WbemRequestExecutor.isRefreshTicketNeeded(e.getCause())) {
                ticket = this.refreshVCenterTicket(wbemConfig.getVCenter(), wbemConfig.getUsername(), wbemConfig.getPassword(), hostname, wbemConfig.getTimeout());
                vCenterWbemConfig.setUsername(ticket);
                vCenterWbemConfig.setPassword(ticket.toCharArray());
                List<List<String>> list = this.doWbemQuery(hostname, vCenterWbemConfig, query, namespace);
                return list;
            }
            throw e;
        }
        finally {
            telemetryManager.getHostProperties().setVCenterTicket(ticket);
        }
    }

    private String refreshVCenterTicket(@NonNull String vCenter, @NonNull String username, @NonNull char[] password, @NonNull String hostname, @NonNull Long timeout) throws ClientException {
        if (vCenter == null) {
            throw new IllegalArgumentException("vCenter is marked non-null but is null");
        }
        if (username == null) {
            throw new IllegalArgumentException("username is marked non-null but is null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password is marked non-null but is null");
        }
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (timeout == null) {
            throw new IllegalArgumentException("timeout is marked non-null but is null");
        }
        VCenterClient.setDebug(() -> true, arg_0 -> ((Logger)log).debug(arg_0));
        try {
            String ticket = (String)ThreadHelper.execute(() -> VCenterClient.requestCertificate(vCenter, username, new String(password), hostname), (long)timeout);
            if (ticket == null) {
                throw new ClientException("Cannot get the ticket through vCenter module");
            }
            return ticket;
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            log.error("Hostname {} - vCenter ticket refresh query failed. Error message: {}", (Object)hostname, (Object)e.getMessage());
            log.debug("Hostname {} - vCenter ticket refresh query failed.", (Object)hostname, (Object)e);
            throw new ClientException("vCenter refresh ticket query failed on " + hostname + ".", e);
        }
    }

    private static boolean isRefreshTicketNeeded(Throwable t) {
        if (t == null) {
            return false;
        }
        if (t instanceof WBEMException) {
            WBEMException wbemException = (WBEMException)t;
            int cimErrorType = wbemException.getID();
            return cimErrorType == 2;
        }
        return WbemRequestExecutor.isRefreshTicketNeeded(t.getCause());
    }

    public List<List<String>> doWbemQuery(String hostname, WbemConfiguration wbemConfig, String query, String namespace) throws ClientException {
        try {
            String urlSpec = String.format("%s://%s:%d", wbemConfig.getProtocol().toString(), hostname, wbemConfig.getPort());
            URL url = new URI(urlSpec).toURL();
            LoggingHelper.trace(() -> log.trace("Executing WBEM request:\n- Hostname: {}\n- Port: {}\n- Protocol: {}\n- URL: {}\n- Username: {}\n- Query: {}\n- Namespace: {}\n- Timeout: {} s\n", new Object[]{hostname, wbemConfig.getPort(), wbemConfig.getProtocol().toString(), url, wbemConfig.getUsername(), query, namespace, wbemConfig.getTimeout()}));
            long startTime = System.currentTimeMillis();
            WbemQueryResult wbemQueryResult = WbemExecutor.executeWql(url, namespace, wbemConfig.getUsername(), wbemConfig.getPassword(), query, wbemConfig.getTimeout().intValue() * 1000, null);
            long responseTime = System.currentTimeMillis() - startTime;
            List<List<String>> result = wbemQueryResult.getValues();
            LoggingHelper.trace(() -> log.trace("Executed WBEM request:\n- Hostname: {}\n- Port: {}\n- Protocol: {}\n- URL: {}\n- Username: {}\n- Query: {}\n- Namespace: {}\n- Timeout: {} s\n- Result:\n{}\n- response-time: {}\n", new Object[]{hostname, wbemConfig.getPort(), wbemConfig.getProtocol().toString(), url, wbemConfig.getUsername(), query, namespace, wbemConfig.getTimeout(), TextTableHelper.generateTextTable(wbemQueryResult.getProperties(), (List)result), responseTime}));
            return result;
        }
        catch (Exception e) {
            throw new ClientException("WBEM query failed on " + hostname + ".", e);
        }
    }

    public boolean isAcceptableException(Throwable t) {
        if (t == null) {
            return false;
        }
        if (t instanceof WBEMException) {
            WBEMException wbemException = (WBEMException)t;
            int cimErrorType = wbemException.getID();
            return this.isAcceptableWbemError(cimErrorType);
        }
        if (t instanceof WqlQuerySyntaxException) {
            return true;
        }
        return this.isAcceptableException(t.getCause());
    }

    private boolean isAcceptableWbemError(int errorId) {
        return errorId == 3 || errorId == 5 || errorId == 6;
    }
}

