/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.wbem;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.LoggingHelper;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.WbemSource;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.wbem.WbemConfiguration;
import org.sentrysoftware.metricshub.extension.wbem.WbemRequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WbemSourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WbemSourceProcessor.class);
    @NonNull
    private WbemRequestExecutor wbemRequestExecutor;
    @NonNull
    private String connectorId;

    String getNamespace(WbemSource wbemSource, TelemetryManager telemetryManager, String connectorId) {
        String namespace = wbemSource.getNamespace();
        if (namespace == null) {
            namespace = "root\\cimv2";
        } else if ("automatic".equalsIgnoreCase(namespace)) {
            namespace = telemetryManager.getHostProperties().getConnectorNamespace(connectorId).getAutomaticWbemNamespace();
        }
        return namespace;
    }

    public SourceTable process(WbemSource wbemSource, TelemetryManager telemetryManager) {
        String hostname = telemetryManager.getHostname(List.of(WbemConfiguration.class));
        if (wbemSource == null) {
            log.error("Hostname {} - Malformed WBEM Source {}. Returning an empty table.", (Object)hostname, (Object)wbemSource);
            return SourceTable.empty();
        }
        WbemConfiguration wbemConfiguration = (WbemConfiguration)telemetryManager.getHostConfiguration().getConfigurations().get(WbemConfiguration.class);
        if (wbemConfiguration == null) {
            log.debug("Hostname {} - The WBEM credentials are not configured. Returning an empty table for WBEM source {}.", (Object)hostname, (Object)wbemSource.getKey());
            return SourceTable.empty();
        }
        String namespace = this.getNamespace(wbemSource, telemetryManager, this.connectorId);
        try {
            if (hostname == null) {
                log.error("Hostname {} - No hostname indicated, the URL cannot be built.", (Object)hostname);
                return SourceTable.empty();
            }
            if (wbemConfiguration.getPort() == null || wbemConfiguration.getPort() == 0) {
                log.error("Hostname {} - No port indicated to connect to the host", (Object)hostname);
                return SourceTable.empty();
            }
            List<List<String>> table = this.wbemRequestExecutor.executeWbem(hostname, wbemConfiguration, wbemSource.getQuery(), namespace, telemetryManager);
            return SourceTable.builder().table(table).build();
        }
        catch (Exception e) {
            LoggingHelper.logSourceError((String)this.connectorId, (String)wbemSource.getKey(), (String)String.format("WBEM query=%s, Username=%s, Timeout=%d, Namespace=%s", wbemSource.getQuery(), wbemConfiguration.getUsername(), wbemConfiguration.getTimeout(), namespace), (String)hostname, (Throwable)e);
            return SourceTable.empty();
        }
    }

    @Generated
    public WbemSourceProcessor(@NonNull WbemRequestExecutor wbemRequestExecutor, @NonNull String connectorId) {
        if (wbemRequestExecutor == null) {
            throw new IllegalArgumentException("wbemRequestExecutor is marked non-null but is null");
        }
        if (connectorId == null) {
            throw new IllegalArgumentException("connectorId is marked non-null but is null");
        }
        this.wbemRequestExecutor = wbemRequestExecutor;
        this.connectorId = connectorId;
    }
}

