/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.client;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static final String DEFAULT_ARRAY_SEPARATOR = "|";
    public static final String EMPTY = "";
    public static final DateTimeFormatter WBEM_CIM_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static final Pattern CIM_DATETIME_PATTERN = Pattern.compile("^([0-9]{14})(?:\\.([0-9]{3,6}))?([+-][0-9]{3})$");

    public static <T> void checkNonNull(T argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException(name + " must not be null.");
        }
    }

    public static OffsetDateTime convertCimDateTime(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        Matcher dateTimeMatcher = CIM_DATETIME_PATTERN.matcher(stringValue);
        if (!dateTimeMatcher.find()) {
            throw new IllegalArgumentException("Not a valid CIM_DATETIME value: " + stringValue);
        }
        LocalDateTime localDateTime = LocalDateTime.parse(dateTimeMatcher.group(1), WBEM_CIM_DATETIME_FORMATTER);
        String zoneOffset = dateTimeMatcher.group(3);
        if (zoneOffset == null) {
            throw new IllegalStateException("Unable to get the timezone offset from CIM_DATETIME value: " + stringValue);
        }
        int secondsOffset = Integer.parseInt(zoneOffset) * 60;
        ZoneOffset offset = ZoneOffset.ofTotalSeconds(secondsOffset);
        return OffsetDateTime.of(localDateTime, offset);
    }
}

