/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sentrysoftware.wbem.client.Utils;
import org.sentrysoftware.wbem.javax.cim.CIMDataType;
import org.sentrysoftware.wbem.javax.cim.CIMDateTimeAbsolute;
import org.sentrysoftware.wbem.javax.cim.CIMDateTimeInterval;
import org.sentrysoftware.wbem.javax.cim.CIMInstance;
import org.sentrysoftware.wbem.javax.cim.CIMObjectPath;
import org.sentrysoftware.wbem.javax.cim.CIMProperty;

public class WbemCimDataHandler {
    public static final String PATH_PROPERTY = "__Path";
    private static final Map<Integer, Function<Object, String>> CONVERT_MAP;

    private WbemCimDataHandler() {
    }

    public static String getCimPropertyAsString(String property, CIMInstance cimInstance, String arraySeparator) {
        String separator;
        Utils.checkNonNull(property, "property");
        Utils.checkNonNull(cimInstance, "cimInstance");
        if (PATH_PROPERTY.equalsIgnoreCase(property)) {
            CIMObjectPath objectPath = cimInstance.getObjectPath();
            Utils.checkNonNull(objectPath, "objectPath");
            return WbemCimDataHandler.convertReference(objectPath);
        }
        CIMProperty<?> cimProperty = cimInstance.getProperty(property);
        String string = separator = arraySeparator == null ? "|" : arraySeparator;
        if (cimProperty == null && cimInstance.getKeys() != null) {
            return Stream.of(cimInstance.getKeys()).filter(key -> key.getName() != null && key.getName().equalsIgnoreCase(property)).findFirst().map(cp -> WbemCimDataHandler.convertCimPropertyValue(cp, separator)).orElse("");
        }
        return cimProperty == null ? "" : WbemCimDataHandler.convertCimPropertyValue(cimProperty, separator);
    }

    private static String convertCimPropertyValue(CIMProperty<?> cimProperty, String arraySeparator) {
        Object cimPropertyValue = cimProperty.getValue();
        if (cimPropertyValue == null) {
            return "";
        }
        CIMDataType dataType = cimProperty.getDataType();
        if (dataType == null) {
            return cimPropertyValue.toString();
        }
        return dataType.isArray() ? WbemCimDataHandler.convertArray(cimProperty, arraySeparator) : CONVERT_MAP.getOrDefault(dataType.getType(), Object::toString).apply(cimPropertyValue);
    }

    private static String convertArray(CIMProperty<?> cimProperty, String arraySeparator) {
        return Arrays.stream((Object[])cimProperty.getValue()).map(obj -> obj == null ? "" : CONVERT_MAP.getOrDefault(cimProperty.getDataType().getType(), Object::toString).apply(obj)).collect(Collectors.joining(arraySeparator, "", arraySeparator));
    }

    private static String convertReference(Object cimPropertyValue) {
        CIMObjectPath objectPath = (CIMObjectPath)cimPropertyValue;
        String str = objectPath.toString();
        return str.substring(str.indexOf(58) + 1).replace("\\\\", "\\").replace("\\\"", "\"");
    }

    private static String convertDateTime(Object cimPropertyValue) {
        if (cimPropertyValue == null) {
            return "";
        }
        if (cimPropertyValue instanceof CIMDateTimeAbsolute) {
            String dateTimeString = ((CIMDateTimeAbsolute)cimPropertyValue).getDateTimeString();
            return String.valueOf(Utils.convertCimDateTime(dateTimeString).toInstant().toEpochMilli());
        }
        return String.valueOf(((CIMDateTimeInterval)cimPropertyValue).getTotalMilliseconds());
    }

    static {
        HashMap<Integer, Function<Object, String>> map = new HashMap<Integer, Function<Object, String>>();
        map.put(8, String::valueOf);
        map.put(9, String::valueOf);
        map.put(1, String::valueOf);
        map.put(3, String::valueOf);
        map.put(5, String::valueOf);
        map.put(7, String::valueOf);
        map.put(13, String::valueOf);
        map.put(10, String::valueOf);
        map.put(11, String::valueOf);
        map.put(15, String::valueOf);
        map.put(12, WbemCimDataHandler::convertDateTime);
        map.put(0, String::valueOf);
        map.put(2, String::valueOf);
        map.put(4, String::valueOf);
        map.put(6, String::valueOf);
        map.put(14, WbemCimDataHandler::convertReference);
        CONVERT_MAP = Collections.unmodifiableMap(map);
    }
}

