/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.client;

import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.security.auth.Subject;
import org.sentrysoftware.wbem.client.Utils;
import org.sentrysoftware.wbem.client.WbemCimDataHandler;
import org.sentrysoftware.wbem.client.WbemQueryResult;
import org.sentrysoftware.wbem.client.WqlQuery;
import org.sentrysoftware.wbem.javax.cim.CIMElement;
import org.sentrysoftware.wbem.javax.cim.CIMInstance;
import org.sentrysoftware.wbem.javax.cim.CIMObjectPath;
import org.sentrysoftware.wbem.javax.wbem.CloseableIterator;
import org.sentrysoftware.wbem.javax.wbem.WBEMException;
import org.sentrysoftware.wbem.javax.wbem.client.EnumerateResponse;
import org.sentrysoftware.wbem.javax.wbem.client.PasswordCredential;
import org.sentrysoftware.wbem.javax.wbem.client.UserPrincipal;
import org.sentrysoftware.wbem.javax.wbem.client.WBEMClient;
import org.sentrysoftware.wbem.javax.wbem.client.WBEMClientFactory;

public class WbemClient
implements AutoCloseable {
    private static final Locale[] FIXED_AVAILABLE_LOCALES_ARRAY = new Locale[]{Locale.ENGLISH};
    private WBEMClient client;
    private CloseableIterator<CIMInstance> iterator;

    public void connect(URL url, String username, char[] password, int timeout) throws WBEMException {
        Utils.checkNonNull(url, "url");
        Utils.checkNonNull(username, "username");
        Utils.checkNonNull(password, "password");
        CIMObjectPath cimObjectPath = new CIMObjectPath(url.getProtocol(), url.getHost(), String.valueOf(url.getPort()), null, null, null);
        Subject subject = new Subject();
        subject.getPrincipals().add(new UserPrincipal(username));
        subject.getPrivateCredentials().add(new PasswordCredential(password));
        this.client = WBEMClientFactory.getClient("CIM-XML");
        this.client.setProperty("javax.wbem.client.timeout", String.valueOf(timeout));
        this.client.initialize(cimObjectPath, subject, FIXED_AVAILABLE_LOCALES_ARRAY);
    }

    @Override
    public void close() {
        if (this.iterator != null) {
            this.iterator.close();
        }
        if (this.client != null) {
            this.client.close();
        }
    }

    public WbemQueryResult executeWql(WqlQuery wqlQuery, String namespace, String arraySeparator) throws WBEMException {
        Utils.checkNonNull(wqlQuery, "wqlQuery");
        Utils.checkNonNull(namespace, "namespace");
        if (this.client == null) {
            throw new IllegalStateException("client must be connected first.");
        }
        this.iterator = this.client.enumerateInstances(new CIMObjectPath(null, null, null, namespace, wqlQuery.getClassName(), null), true, false, true, wqlQuery.getPropertiesArray());
        return WbemClient.enumerateInstances(wqlQuery, this.iterator, arraySeparator);
    }

    public WbemQueryResult getAssociators(WqlQuery wqlQuery, String objectPathAssociators, String arraySeparator) throws WBEMException {
        Utils.checkNonNull(wqlQuery, "wqlQuery");
        Utils.checkNonNull(objectPathAssociators, "objectPathAssociators");
        if (this.client == null) {
            throw new IllegalStateException("client must be connected first.");
        }
        EnumerateResponse<CIMInstance> response = this.client.associators(new CIMObjectPath(objectPathAssociators), wqlQuery.getClassName(), null, null, null, false, wqlQuery.getPropertiesArray(), null, null, null, false, null);
        this.iterator = response.getResponses();
        return WbemClient.enumerateInstances(wqlQuery, this.iterator, arraySeparator);
    }

    public static WbemQueryResult enumerateInstances(WqlQuery wqlQuery, CloseableIterator<CIMInstance> iterator, String arraySeparator) {
        if (iterator == null) {
            return new WbemQueryResult(new ArrayList<String>(), new ArrayList<List<String>>());
        }
        Set properties = null;
        List<String> originalProperties = null;
        ArrayList<List<String>> values = new ArrayList<List<String>>();
        while (iterator.hasNext()) {
            List row;
            CIMInstance cimInstance = (CIMInstance)iterator.next();
            if (properties == null) {
                Set set = properties = wqlQuery.getProperties().isEmpty() ? (Set)Stream.of(cimInstance.getProperties()).map(CIMElement::getName).collect(Collectors.toCollection(LinkedHashSet::new)) : wqlQuery.getProperties();
            }
            if (originalProperties == null) {
                List<String> list = originalProperties = wqlQuery.hasDuplicateProperties() ? wqlQuery.getOriginalProperties() : properties.stream().collect(Collectors.toList());
            }
            if (wqlQuery.hasDuplicateProperties()) {
                Map<String, String> cimProperties = properties.stream().collect(Collectors.toMap(String::toLowerCase, property -> WbemCimDataHandler.getCimPropertyAsString(property, cimInstance, arraySeparator)));
                row = originalProperties.stream().map(property -> (String)cimProperties.get(property.toLowerCase())).collect(Collectors.toList());
            } else {
                row = properties.stream().map(property -> WbemCimDataHandler.getCimPropertyAsString(property, cimInstance, arraySeparator)).collect(Collectors.toList());
            }
            values.add(row);
        }
        return new WbemQueryResult(originalProperties, values);
    }
}

