/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.client;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sentrysoftware.wbem.client.Utils;
import org.sentrysoftware.wbem.client.exceptions.WqlQuerySyntaxException;

public class WqlQuery {
    private static final String ID = "[^\\s]+";
    private static final String LIST_SEPARATOR = "\\s*,\\s*";
    private static final Pattern CHECK_SELECT_PATTERN = Pattern.compile("^\\s*SELECT\\s+(\\*|(?!SELECT|FROM|WHERE)\\w+|((?!SELECT|FROM|WHERE)\\w+\\s*,\\s*)+((?!SELECT|FROM|WHERE)\\w+))\\s+FROM\\s+((?!SELECT|WHERE|FROM)\\w+)\\s*?$", 2);
    private static final Pattern EXTRACT_SELECT_PATTERN = Pattern.compile("^\\s*SELECT\\s+(.+)\\s+FROM\\s+([^\\s]+)\\s*$", 2);
    private static final int SELECT_GROUP_CLASSNAME = 2;
    private static final int SELECT_GROUP_FIELDS = 1;
    private static final int SELECT_GROUP_COUNT = 2;
    private String className;
    private Set<String> properties;
    private List<String> originalProperties;

    private WqlQuery() {
    }

    public static WqlQuery parseQuery(String query) throws WqlQuerySyntaxException {
        Utils.checkNonNull(query, "query");
        if (CHECK_SELECT_PATTERN.matcher(query).find()) {
            WqlQuery wqlQuery = new WqlQuery();
            wqlQuery.parseSelect(query);
            return wqlQuery;
        }
        throw new WqlQuerySyntaxException(query);
    }

    public String getClassName() {
        return this.className;
    }

    public String[] getPropertiesArray() {
        return this.properties.isEmpty() ? null : (String[])this.properties.stream().filter(property -> !"__Path".equalsIgnoreCase((String)property)).toArray(String[]::new);
    }

    public Set<String> getProperties() {
        return this.properties;
    }

    public List<String> getOriginalProperties() {
        return this.originalProperties;
    }

    public boolean hasDuplicateProperties() {
        return this.properties != null && this.originalProperties != null && this.properties.size() != this.originalProperties.size();
    }

    private void parseSelect(String query) throws WqlQuerySyntaxException {
        Matcher matcher = EXTRACT_SELECT_PATTERN.matcher(query);
        if (!matcher.find()) {
            throw new WqlQuerySyntaxException(query);
        }
        if (matcher.groupCount() < 2) {
            throw new WqlQuerySyntaxException(query);
        }
        this.className = matcher.group(2);
        String fieldsList = matcher.group(1);
        String[] fieldArray = Optional.ofNullable(fieldsList).filter(s -> !"*".equals(s)).map(s -> s.split(LIST_SEPARATOR)).orElse(new String[0]);
        this.originalProperties = Stream.of(fieldArray).map(String::trim).collect(Collectors.toList());
        HashMap originalMap = new HashMap();
        this.originalProperties.stream().forEach(property -> originalMap.computeIfAbsent(property.toLowerCase(), prop -> property));
        this.properties = this.originalProperties.stream().map(property -> (String)originalMap.get(property.toLowerCase())).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

