/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.javax.cim;

import java.io.Serializable;
import org.sentrysoftware.wbem.javax.cim.CIMClass;
import org.sentrysoftware.wbem.javax.cim.CIMDateTime;
import org.sentrysoftware.wbem.javax.cim.CIMInstance;
import org.sentrysoftware.wbem.javax.cim.CIMObjectPath;
import org.sentrysoftware.wbem.javax.cim.UnsignedInteger16;
import org.sentrysoftware.wbem.javax.cim.UnsignedInteger32;
import org.sentrysoftware.wbem.javax.cim.UnsignedInteger64;
import org.sentrysoftware.wbem.javax.cim.UnsignedInteger8;
import org.sentrysoftware.wbem.sblim.cimclient.internal.util.MOF;

public class CIMDataType
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int BOOLEAN = 9;
    public static final CIMDataType BOOLEAN_ARRAY_T = new CIMDataType(9, true);
    public static final CIMDataType BOOLEAN_T = new CIMDataType(9, false);
    public static final int CHAR16 = 13;
    public static final CIMDataType CHAR16_ARRAY_T = new CIMDataType(13, true);
    public static final CIMDataType CHAR16_T = new CIMDataType(13, false);
    public static final int CLASS = 17;
    public static final CIMDataType CLASS_ARRAY_T = new CIMDataType(17, true);
    public static final CIMDataType CLASS_T = new CIMDataType(17, false);
    public static final int DATETIME = 12;
    public static final CIMDataType DATETIME_ARRAY_T = new CIMDataType(12, true);
    public static final CIMDataType DATETIME_T = new CIMDataType(12, false);
    public static final int INVALID = -1;
    public static final CIMDataType INVALID_T = new CIMDataType(-1, false);
    public static final int NULL = 16;
    public static final int OBJECT = 15;
    public static final CIMDataType OBJECT_ARRAY_T = new CIMDataType(15, true);
    public static final CIMDataType OBJECT_T = new CIMDataType(15, false);
    public static final int REAL32 = 10;
    public static final CIMDataType REAL32_ARRAY_T = new CIMDataType(10, true);
    public static final CIMDataType REAL32_T = new CIMDataType(10, false);
    public static final int REAL64 = 11;
    public static final CIMDataType REAL64_ARRAY_T = new CIMDataType(11, true);
    public static final CIMDataType REAL64_T = new CIMDataType(11, false);
    public static final int REFERENCE = 14;
    public static final int SINT16 = 3;
    public static final CIMDataType SINT16_ARRAY_T = new CIMDataType(3, true);
    public static final CIMDataType SINT16_T = new CIMDataType(3, false);
    public static final int SINT32 = 5;
    public static final CIMDataType SINT32_ARRAY_T = new CIMDataType(5, true);
    public static final CIMDataType SINT32_T = new CIMDataType(5, false);
    public static final int SINT64 = 7;
    public static final CIMDataType SINT64_ARRAY_T = new CIMDataType(7, true);
    public static final CIMDataType SINT64_T = new CIMDataType(7, false);
    public static final int SINT8 = 1;
    public static final CIMDataType SINT8_ARRAY_T = new CIMDataType(1, true);
    public static final CIMDataType SINT8_T = new CIMDataType(1, false);
    public static final int STRING = 8;
    public static final CIMDataType STRING_ARRAY_T = new CIMDataType(8, true);
    public static final CIMDataType STRING_T = new CIMDataType(8, false);
    public static final int UINT16 = 2;
    public static final CIMDataType UINT16_ARRAY_T = new CIMDataType(2, true);
    public static final CIMDataType UINT16_T = new CIMDataType(2, false);
    public static final int UINT32 = 4;
    public static final CIMDataType UINT32_ARRAY_T = new CIMDataType(4, true);
    public static final CIMDataType UINT32_T = new CIMDataType(4, false);
    public static final int UINT64 = 6;
    public static final CIMDataType UINT64_ARRAY_T = new CIMDataType(6, true);
    public static final CIMDataType UINT64_T = new CIMDataType(6, false);
    public static final int UINT8 = 0;
    public static final CIMDataType UINT8_ARRAY_T = new CIMDataType(0, true);
    public static final CIMDataType UINT8_T = new CIMDataType(0, false);
    private int iTypeCode;
    private int iBound;
    private String iRefClassName;

    private void setType(int pType) {
        this.iTypeCode = pType;
        this.iBound = -1;
    }

    private void setType(int pType, int pBound) {
        this.iTypeCode = pType;
        this.iBound = pBound;
    }

    public CIMDataType(int pType, boolean pIsArray) throws IllegalArgumentException {
        if (pIsArray) {
            this.setType(pType, 0);
        } else {
            this.setType(pType);
        }
    }

    public CIMDataType(int pType, int pSize) throws IllegalArgumentException {
        if (pSize <= 0) {
            throw new IllegalArgumentException("Maximum number of elements must be positive integer!");
        }
        this.setType(pType, pSize);
    }

    public CIMDataType(String pClassName) {
        if (pClassName == null) {
            throw new IllegalArgumentException("Class name must not be null!");
        }
        this.setType(14);
        this.iRefClassName = pClassName;
    }

    public CIMDataType(String pClassName, int pSize) {
        if (pClassName == null) {
            throw new IllegalArgumentException("Class name must not be null!");
        }
        if (pSize < 0) {
            throw new IllegalArgumentException("Maximum number of elements cannot be negative integer!");
        }
        this.setType(14, pSize);
        this.iRefClassName = pClassName;
    }

    public boolean equals(Object pObj) {
        if (this == pObj) {
            return true;
        }
        if (!(pObj instanceof CIMDataType)) {
            return false;
        }
        CIMDataType that = (CIMDataType)pObj;
        if (this.iRefClassName == null && that.iRefClassName != null) {
            return false;
        }
        boolean refMatch = this.iRefClassName == null ? true : this.iRefClassName.equals(that.iRefClassName);
        return this.iTypeCode == that.iTypeCode && this.isArray() == that.isArray() && refMatch;
    }

    public static final CIMDataType getDataType(Object pObj) throws IllegalArgumentException {
        if (pObj instanceof Byte) {
            return SINT8_T;
        }
        if (pObj instanceof Byte[]) {
            return SINT8_ARRAY_T;
        }
        if (pObj instanceof Short) {
            return SINT16_T;
        }
        if (pObj instanceof Short[]) {
            return SINT16_ARRAY_T;
        }
        if (pObj instanceof Integer) {
            return SINT32_T;
        }
        if (pObj instanceof Integer[]) {
            return SINT32_ARRAY_T;
        }
        if (pObj instanceof Long) {
            return SINT64_T;
        }
        if (pObj instanceof Long[]) {
            return SINT64_ARRAY_T;
        }
        if (pObj instanceof UnsignedInteger8) {
            return UINT8_T;
        }
        if (pObj instanceof UnsignedInteger8[]) {
            return UINT8_ARRAY_T;
        }
        if (pObj instanceof UnsignedInteger16) {
            return UINT16_T;
        }
        if (pObj instanceof UnsignedInteger16[]) {
            return UINT16_ARRAY_T;
        }
        if (pObj instanceof UnsignedInteger32) {
            return UINT32_T;
        }
        if (pObj instanceof UnsignedInteger32[]) {
            return UINT32_ARRAY_T;
        }
        if (pObj instanceof UnsignedInteger64) {
            return UINT64_T;
        }
        if (pObj instanceof UnsignedInteger64[]) {
            return UINT64_ARRAY_T;
        }
        if (pObj instanceof Boolean) {
            return BOOLEAN_T;
        }
        if (pObj instanceof Boolean[]) {
            return BOOLEAN_ARRAY_T;
        }
        if (pObj instanceof Character) {
            return CHAR16_T;
        }
        if (pObj instanceof Character[]) {
            return CHAR16_ARRAY_T;
        }
        if (pObj instanceof String) {
            return STRING_T;
        }
        if (pObj instanceof String[]) {
            return STRING_ARRAY_T;
        }
        if (pObj instanceof Float) {
            return REAL32_T;
        }
        if (pObj instanceof Float[]) {
            return REAL32_ARRAY_T;
        }
        if (pObj instanceof Double) {
            return REAL64_T;
        }
        if (pObj instanceof Double[]) {
            return REAL64_ARRAY_T;
        }
        if (pObj instanceof CIMDateTime) {
            return DATETIME_T;
        }
        if (pObj instanceof CIMDateTime[]) {
            return DATETIME_ARRAY_T;
        }
        if (pObj instanceof CIMClass) {
            return CLASS_T;
        }
        if (pObj instanceof CIMClass[]) {
            return CLASS_ARRAY_T;
        }
        if (pObj instanceof CIMInstance) {
            return OBJECT_T;
        }
        if (pObj instanceof CIMInstance[]) {
            return OBJECT_ARRAY_T;
        }
        if (pObj instanceof CIMObjectPath) {
            CIMObjectPath op = (CIMObjectPath)pObj;
            return new CIMDataType(op.getObjectName());
        }
        if (pObj instanceof CIMObjectPath[]) {
            CIMObjectPath[] ops = (CIMObjectPath[])pObj;
            for (int i = 0; i < ops.length; ++i) {
                if (ops[i] == null) continue;
                return new CIMDataType(ops[i].getObjectName(), 0);
            }
        }
        throw new IllegalArgumentException("Invalid CIM Type!");
    }

    public String getRefClassName() {
        return this.iRefClassName;
    }

    public int getSize() {
        return this.iBound;
    }

    public int getType() {
        return this.iTypeCode;
    }

    public boolean isArray() {
        return this.iBound >= 0;
    }

    public String toString() {
        return MOF.dataType(this);
    }
}

