/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.javax.cim;

public class UnsignedInteger16
extends Number
implements Comparable<UnsignedInteger16> {
    private static final long serialVersionUID = -4992164525643467216L;
    public static final int MAX_VALUE = 65535;
    public static final int MIN_VALUE = 0;
    private int iValue;

    private void setValue(int pValue) throws NumberFormatException {
        if (pValue > 65535 || pValue < 0) {
            String msg = "uint16:" + pValue + " is out of range!";
            throw new NumberFormatException(msg);
        }
        this.iValue = pValue;
    }

    public UnsignedInteger16(int pValue) throws NumberFormatException {
        this.setValue(pValue);
    }

    public UnsignedInteger16(String pValue) throws NumberFormatException {
        if (pValue == null) {
            throw new IllegalArgumentException("String value cannot be null!");
        }
        this.setValue(Integer.parseInt(pValue));
    }

    @Override
    public int compareTo(UnsignedInteger16 pOther) {
        if (pOther == null) {
            throw new IllegalArgumentException("Other UnsignedInteger16 cannot be null!");
        }
        UnsignedInteger16 that = pOther;
        int d = this.iValue - that.iValue;
        if (d == 0) {
            return 0;
        }
        return d < 0 ? -1 : 1;
    }

    public boolean equals(Object pObj) {
        if (!(pObj instanceof UnsignedInteger16)) {
            return false;
        }
        return this.iValue == ((UnsignedInteger16)pObj).iValue;
    }

    @Override
    public byte byteValue() {
        return (byte)this.iValue;
    }

    @Override
    public double doubleValue() {
        return this.iValue;
    }

    @Override
    public float floatValue() {
        return this.iValue;
    }

    public int hashCode() {
        return Integer.valueOf(this.iValue).hashCode();
    }

    @Override
    public int intValue() {
        return this.iValue;
    }

    @Override
    public long longValue() {
        return this.iValue;
    }

    @Override
    public short shortValue() {
        return (short)this.iValue;
    }

    public String toString() {
        return Integer.toString(this.iValue);
    }
}

