/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.cim;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.sentrysoftware.wbem.javax.cim.CIMDataType;
import org.sentrysoftware.wbem.javax.cim.CIMQualifiedElementInterface;
import org.sentrysoftware.wbem.javax.cim.CIMQualifier;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cim.CIMElementSorter;

public class CIMQualifiedElementInterfaceImpl
implements CIMQualifiedElementInterface,
Serializable {
    private static final long serialVersionUID = 4533301297060752510L;
    private CIMQualifier<?>[] iQualis;
    private CIMQualifier<?>[] iLocalOnlyQualis;
    private boolean iEmbeddedObject;
    private static final CIMQualifier<Boolean> KEY = new CIMQualifier<Boolean>("Key", CIMDataType.BOOLEAN_T, Boolean.TRUE, 1);
    private static final CIMQualifier<Boolean> ASSOCIATION = new CIMQualifier<Boolean>("Association", CIMDataType.BOOLEAN_T, Boolean.TRUE, 1);
    private static final CIMQualifier<?>[] EMPTY_QA = new CIMQualifier[0];

    public CIMQualifiedElementInterfaceImpl(CIMQualifier<?>[] pQualifiers) {
        this.setQualis(pQualifiers);
    }

    public CIMQualifiedElementInterfaceImpl(CIMQualifier<?>[] pQualifiers, boolean pIsKeyed) {
        this(pQualifiers, pIsKeyed, false);
    }

    public CIMQualifiedElementInterfaceImpl(CIMQualifier<?>[] pQualifiers, boolean pIsKeyed, boolean pKeepEmbObj) {
        this(pQualifiers, pIsKeyed, pKeepEmbObj, false);
    }

    public CIMQualifiedElementInterfaceImpl(CIMQualifier<?>[] pQualifiers, boolean pIsKeyed, boolean pKeepEmbObj, boolean pIsAssociation) {
        if (pKeepEmbObj) {
            this.iQualis = (CIMQualifier[])CIMElementSorter.sort(pQualifiers);
            this.iEmbeddedObject = CIMElementSorter.findIdx(this.iQualis, "EmbeddedObject") >= 0;
        } else {
            this.setQualis(pQualifiers);
        }
        this.setBoolQualifier(KEY, pIsKeyed);
        this.setBoolQualifier(ASSOCIATION, pIsAssociation);
    }

    public boolean equals(Object pObj) {
        if (!(pObj instanceof CIMQualifiedElementInterfaceImpl)) {
            return false;
        }
        CIMQualifiedElementInterfaceImpl that = (CIMQualifiedElementInterfaceImpl)pObj;
        return Arrays.equals(this.getQualifiers(), that.getQualifiers());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getQualifiers());
    }

    private void setQualis(CIMQualifier<?>[] pQualiA) {
        int rmIdx = CIMElementSorter.findIdx(pQualiA = (CIMQualifier[])CIMElementSorter.sort(pQualiA), "EmbeddedObject");
        if (rmIdx < 0) {
            this.iQualis = pQualiA;
            return;
        }
        this.iEmbeddedObject = true;
        this.iQualis = pQualiA;
    }

    private void setBoolQualifier(CIMQualifier<Boolean> pQuali, boolean pValue) {
        int idx = CIMElementSorter.findIdx(this.iQualis, pQuali.getName());
        if (pValue) {
            if (idx < 0) {
                this.insertQuali(pQuali, -idx - 1);
            } else if (!((Boolean)pQuali.getValue()).equals(this.iQualis[idx].getValue())) {
                this.iQualis[idx] = pQuali;
            }
        } else if (idx > 0) {
            this.removeQuali(idx);
        }
    }

    private void insertQuali(CIMQualifier<Boolean> pQuali, int idx) {
        int origLength = this.iQualis == null ? 0 : this.iQualis.length;
        CIMQualifier[] qualis = new CIMQualifier[origLength + 1];
        int srcIdx = 0;
        int dstIdx = 0;
        while (srcIdx < idx) {
            qualis[dstIdx++] = this.iQualis[srcIdx++];
        }
        qualis[dstIdx++] = pQuali;
        while (srcIdx < origLength) {
            qualis[dstIdx++] = this.iQualis[srcIdx++];
        }
        this.iQualis = qualis;
    }

    private void removeQuali(int idx) {
        CIMQualifier[] qualis = new CIMQualifier[this.iQualis.length - 1];
        int srcIdx = 0;
        int dstIdx = 0;
        while (srcIdx < idx) {
            qualis[dstIdx++] = this.iQualis[srcIdx++];
        }
        ++srcIdx;
        while (srcIdx < this.iQualis.length) {
            qualis[dstIdx++] = this.iQualis[srcIdx++];
        }
        this.iQualis = qualis;
    }

    public boolean isKeyed() {
        return this.hasQualifierValue("key", Boolean.TRUE);
    }

    public boolean isEmbeddedObject() {
        return this.iEmbeddedObject;
    }

    @Override
    public CIMQualifier<?> getQualifier(int pIndex) {
        return this.iQualis[pIndex];
    }

    @Override
    public CIMQualifier<?> getQualifier(String pName) {
        return (CIMQualifier)CIMElementSorter.find(this.iQualis, pName);
    }

    @Override
    public int getQualifierCount() {
        return this.iQualis == null ? 0 : this.iQualis.length;
    }

    @Override
    public Object getQualifierValue(String pName) {
        CIMQualifier<?> quali = this.getQualifier(pName);
        if (quali == null) {
            return null;
        }
        return quali.getValue();
    }

    @Override
    public CIMQualifier<?>[] getQualifiers() {
        return this.getQualifiers(false);
    }

    public CIMQualifier<?>[] getQualifiers(boolean pLocalOnly) {
        if (this.iQualis == null) {
            return EMPTY_QA;
        }
        if (!pLocalOnly) {
            return this.iQualis;
        }
        if (this.iLocalOnlyQualis == null) {
            ArrayList qualiL = new ArrayList(this.iQualis.length);
            for (int i = 0; i < this.iQualis.length; ++i) {
                if (this.iQualis[i].isPropagated()) continue;
                qualiL.add(this.iQualis[i]);
            }
            this.iLocalOnlyQualis = qualiL.toArray(new CIMQualifier[qualiL.size()]);
        }
        return this.iLocalOnlyQualis;
    }

    @Override
    public boolean hasQualifier(String pName) {
        return this.getQualifier(pName) != null;
    }

    @Override
    public boolean hasQualifierValue(String pName, Object pValue) {
        if (!this.hasQualifier(pName)) {
            return false;
        }
        Object value = this.getQualifierValue(pName);
        return value == null ? pValue == null : value.equals(pValue);
    }
}

