/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.cim;

import java.io.IOException;
import java.io.StringReader;

public class DTStringReader {
    private String iDateTimeStr;
    private StringReader iReader;
    private int iPos = 0;
    private boolean iUnsignificant;

    public DTStringReader(String pDateTimeStr) {
        this.iDateTimeStr = pDateTimeStr;
        this.iReader = new StringReader(pDateTimeStr);
    }

    public int read(int pLen, String pFieldName, boolean pAllowUnsignificant) throws IllegalArgumentException {
        int res;
        int read;
        char[] buf = new char[pLen];
        try {
            read = this.iReader.read(buf);
            this.iPos += pLen;
        }
        catch (IOException e) {
            String msg = "Failed to read " + pFieldName + " field from " + this.iDateTimeStr + '!';
            throw new IllegalArgumentException(msg);
        }
        if (read != pLen) {
            String msg = "Length of " + pFieldName + " field should be " + pLen + " but only" + read + " characters could be read!";
            throw new IllegalArgumentException(msg);
        }
        if (pAllowUnsignificant) {
            int cnt = 0;
            for (int i = 0; i < buf.length; ++i) {
                if (buf[i] != '*') continue;
                ++cnt;
            }
            if (cnt == buf.length) {
                this.iUnsignificant = true;
                return -1;
            }
        }
        this.iUnsignificant = false;
        String field = new String(buf);
        try {
            res = Integer.parseInt(field);
        }
        catch (NumberFormatException e) {
            String msg = "Illegal " + pFieldName + " field \"" + field + "\" in \"" + this.iDateTimeStr + "\"!";
            throw new IllegalArgumentException(msg);
        }
        if (res < 0) {
            throw new IllegalArgumentException("Negative value is not allowed for " + pFieldName + " in " + this.iDateTimeStr + "!");
        }
        if (field.indexOf(43) != -1) {
            throw new IllegalArgumentException("Plus sign is not allowed for " + pFieldName + " in " + this.iDateTimeStr + "!");
        }
        return res;
    }

    public int readAndCheck(int pLen, String pFieldName, int pMin, int pMax, boolean pAllowUnsignificant) throws IllegalArgumentException {
        int val = this.read(pLen, pFieldName, pAllowUnsignificant);
        if (pAllowUnsignificant && val == -1) {
            return val;
        }
        if (val < pMin || val > pMax) {
            throw new IllegalArgumentException(pFieldName + " must be between " + pMin + " and " + pMax + ", but " + val + " was read from " + this.iDateTimeStr + " !");
        }
        return val;
    }

    public char read() {
        try {
            int i = this.iReader.read();
            if (i > 0) {
                ++this.iPos;
                return (char)i;
            }
            return '\u0000';
        }
        catch (IOException e) {
            return '\u0000';
        }
    }

    public void read(char c) throws IllegalArgumentException {
        if (this.read() != c) {
            String msg = "'" + c + "' expected at position " + this.getPos() + " in " + this.iDateTimeStr + "!";
            throw new IllegalArgumentException(msg);
        }
    }

    public int getPos() {
        return this.iPos;
    }

    public boolean isUnsignificant() {
        return this.iUnsignificant;
    }
}

