/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax;

import org.sentrysoftware.wbem.javax.cim.CIMDataType;
import org.sentrysoftware.wbem.javax.cim.CIMObjectPath;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cim.CIMHelper;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.CIMObjectFactory;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.SAXSession;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.AbstractValueNode;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.ArrayIf;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.Node;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.QualifiedNodeHandler;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.ValueArrayNode;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.ValueNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EmbObjHandler {
    private String iNodeName;
    private CIMDataType iRawType;
    private boolean iHasEmbObjAttr;
    private boolean iHasEmbInstAttr;
    private SAXSession iSession;
    private CIMDataType iType;
    private Object iValue;
    private QualifiedNodeHandler iQualiHandler;
    private AbstractValueNode iAbsValNode;

    public static EmbObjHandler init(EmbObjHandler pHandler, String pNodeName, Attributes pAttribs, SAXSession pSession, QualifiedNodeHandler pQNodeHandler, boolean pCheckEmbObjAttrib) throws SAXException {
        if (pHandler == null) {
            pHandler = new EmbObjHandler();
        }
        pHandler.initInst(pNodeName, pAttribs, pSession, pQNodeHandler, pCheckEmbObjAttrib);
        return pHandler;
    }

    private EmbObjHandler() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initInst(String pNodeName, Attributes pAttribs, SAXSession pSession, QualifiedNodeHandler pQNodeHandler, boolean pCheckEmbObjAttrib) throws SAXException {
        this.iSession = pSession;
        this.iNodeName = pNodeName;
        this.iQualiHandler = pQNodeHandler;
        this.iType = null;
        this.iValue = null;
        this.iAbsValNode = null;
        this.iRawType = Node.getCIMType(pAttribs, true);
        if (this.iRawType == null) {
            this.iRawType = Node.getParamType(pAttribs);
        }
        if (pCheckEmbObjAttrib) {
            String embObjStr = pAttribs.getValue("EmbeddedObject");
            if (embObjStr == null) {
                embObjStr = pAttribs.getValue("EMBEDDEDOBJECT");
            }
            if (embObjStr == null) {
                this.iHasEmbObjAttr = false;
                this.iHasEmbInstAttr = false;
                return;
            } else if ("instance".equalsIgnoreCase(embObjStr)) {
                this.iHasEmbInstAttr = true;
                this.iHasEmbObjAttr = false;
                return;
            } else {
                if (!"object".equalsIgnoreCase(embObjStr)) throw new SAXException("EmbeddedObject attribute's value must be \"object\" or \"instance\". " + embObjStr + " is invalid!");
                this.iHasEmbInstAttr = false;
                this.iHasEmbObjAttr = true;
            }
            return;
        } else {
            this.iHasEmbObjAttr = false;
            this.iHasEmbInstAttr = false;
        }
    }

    private boolean isEmbeddedObject() {
        return this.iHasEmbInstAttr || this.iHasEmbObjAttr || this.iQualiHandler != null && (this.iQualiHandler.isEmbeddedObject() || this.iQualiHandler.isEmbeddedInstance());
    }

    private boolean isEmbeddedClass() {
        return this.iHasEmbObjAttr || this.iQualiHandler != null && this.iQualiHandler.isEmbeddedObject();
    }

    private boolean isEmbeddedInstance() {
        return this.iHasEmbInstAttr || this.iQualiHandler != null && this.iQualiHandler.isEmbeddedInstance();
    }

    public Object getValue() throws SAXException {
        this.transform();
        return this.iValue;
    }

    public CIMDataType getType() throws SAXException {
        this.transform();
        return this.iType;
    }

    public CIMDataType getRawType() {
        return this.iRawType;
    }

    public CIMDataType getArrayType() throws SAXException {
        this.transform();
        return this.iType.isArray() ? this.iType : CIMHelper.UnboundedArrayDataType(this.iType.getType());
    }

    public void addValueNode(AbstractValueNode pValueNode) {
        if (this.isEmbeddedObject() && pValueNode != null && !(pValueNode instanceof ValueNode) && !(pValueNode instanceof ValueArrayNode)) {
            throw new IllegalArgumentException("pValueNode's type can be ValueNode or ValueArrayNode or it can be null. " + pValueNode.getClass().getName() + " is an invalid type!");
        }
        this.iAbsValNode = pValueNode;
    }

    private void transform() throws SAXException {
        if (this.iType != null) {
            return;
        }
        if (this.iAbsValNode == null) {
            if (this.isEmbeddedObject()) {
                if (this.iRawType != CIMDataType.STRING_T) {
                    throw new SAXException("Embedded Object CIM-XML element's type must be string. " + this.iRawType + " is invalid!");
                }
                this.iType = this.iSession.strictEmbObjParsing() ? (this.isEmbeddedInstance() ? CIMDataType.OBJECT_T : CIMDataType.CLASS_T) : (this.isEmbeddedInstance() ? CIMDataType.OBJECT_T : CIMDataType.STRING_T);
            } else {
                this.iType = this.iRawType;
            }
            this.iValue = null;
        } else {
            this.setType();
            if (this.isEmbeddedObject()) {
                this.transformEmbObj();
            } else {
                this.transformNormObj();
            }
        }
    }

    private void transformEmbObj() throws SAXException {
        if (this.iAbsValNode instanceof ValueNode) {
            String valueStr = (String)((ValueNode)this.iAbsValNode).getValue();
            this.iValue = CIMObjectFactory.getEmbeddedObj(this.iRawType, valueStr, this.iSession);
            this.iType = CIMObjectFactory.getCIMObjScalarType(this.iValue);
        } else {
            this.iValue = CIMObjectFactory.getEmbeddedObjA(this.iRawType, (ValueArrayNode)this.iAbsValNode, this.iSession);
            this.iType = CIMObjectFactory.getCIMObjArrayType(this.iValue);
        }
        if (this.isEmbeddedInstance() && this.iType.getType() != 15) {
            throw new SAXException(this.iNodeName + " element is an EmbeddedInstance with non INSTANCE value. It's not valid!");
        }
        if (this.isEmbeddedClass() && this.iType.getType() != 17 && this.iType.getType() != 15) {
            throw new SAXException(this.iNodeName + " element is an EmbeddedObject with non CLASS/INSTANCE value. It's not valid!");
        }
    }

    private void transformNormObj() throws SAXException {
        if (this.iAbsValNode instanceof ValueNode) {
            this.iType = this.iRawType;
            this.iValue = CIMObjectFactory.getObject(this.iType, (ValueNode)this.iAbsValNode);
        } else if (this.iAbsValNode instanceof ValueArrayNode) {
            this.iType = CIMHelper.UnboundedArrayDataType(this.iRawType.getType());
            this.iValue = CIMObjectFactory.getObject(this.iRawType, (ValueArrayNode)this.iAbsValNode);
        } else {
            this.iValue = this.iAbsValNode.getValue();
            if (this.iAbsValNode instanceof ArrayIf) {
                if (this.iValue instanceof CIMObjectPath[]) {
                    this.iType = new CIMDataType("", 0);
                }
            } else {
                this.iType = this.iValue instanceof CIMObjectPath ? new CIMDataType(((CIMObjectPath)this.iValue).getObjectName()) : this.iRawType;
            }
        }
    }

    private void setType() throws SAXException {
        if (this.iType != null || this.iRawType != null) {
            return;
        }
        this.iRawType = this.iAbsValNode.getType();
        if (this.iRawType == null) {
            this.iRawType = this.iAbsValNode instanceof ArrayIf ? CIMDataType.STRING_ARRAY_T : CIMDataType.STRING_T;
        }
    }
}

