/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node;

import org.sentrysoftware.wbem.javax.cim.CIMObjectPath;
import org.sentrysoftware.wbem.javax.cim.CIMProperty;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.SAXSession;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.AbstractObjectPathNode;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.InstanceNameNode;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.NameSpacePathNode;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.Node;
import org.sentrysoftware.wbem.sblim.cimclient.internal.util.XMLHostStr;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class InstancePathNode
extends AbstractObjectPathNode {
    private boolean iHasInstancePath;
    private String iLocalNameSpacePathStr;
    private XMLHostStr iHostStr;
    private boolean iHasInstanceName;
    private String iClassNameStr;
    private CIMProperty<?>[] iKeys;

    public InstancePathNode() {
        super("INSTANCEPATH");
    }

    @Override
    public void init(Attributes pAttribs, SAXSession pSession) {
        this.iHasInstancePath = false;
        this.iHasInstanceName = false;
        this.iClassNameStr = null;
        this.iLocalNameSpacePathStr = null;
        this.iHostStr = new XMLHostStr();
        this.iKeys = null;
    }

    @Override
    public void testChild(String pNodeNameEnum) throws SAXException {
        if (pNodeNameEnum == "NAMESPACEPATH") {
            if (this.iHasInstancePath) {
                throw new SAXException("INSTANCEPATH node can have only one NAMESPACEPATH child node!");
            }
        } else if (pNodeNameEnum == "INSTANCENAME") {
            if (this.iHasInstanceName) {
                throw new SAXException("INSTANCEPATH node can have only one INSTANCENAME child node!");
            }
        } else {
            throw new SAXException("INSTANCEPATH node cannot have " + pNodeNameEnum + " child node!");
        }
    }

    @Override
    public void parseData(String pData) {
    }

    @Override
    public void childParsed(Node pChild) {
        if (pChild instanceof NameSpacePathNode) {
            NameSpacePathNode nsPathNode = (NameSpacePathNode)pChild;
            this.iHostStr.set(nsPathNode.getHostStr());
            this.iLocalNameSpacePathStr = nsPathNode.getLocalNameSpacePath();
            this.iHasInstancePath = true;
        } else {
            InstanceNameNode instNameNode = (InstanceNameNode)pChild;
            this.iClassNameStr = instNameNode.getClassName();
            this.iKeys = instNameNode.getKeys();
            this.iHasInstanceName = true;
        }
    }

    @Override
    public void testCompletness() throws SAXException {
        if (!this.iHasInstancePath) {
            throw new SAXException("INSTANCEPATH node must have a NAMESPACEPATH child node!");
        }
        if (!this.iHasInstanceName) {
            throw new SAXException("INSTANCEPATH node must have an INSTANCENAME child node!");
        }
    }

    @Override
    public CIMObjectPath getCIMObjectPath() {
        return new CIMObjectPath(this.iHostStr.getProtocol(), this.iHostStr.getHost(), this.iHostStr.getPort(), this.iLocalNameSpacePathStr, this.iClassNameStr, this.iKeys);
    }
}

