/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node;

import org.sentrysoftware.wbem.javax.cim.CIMObjectPath;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.LocalPathBuilder;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.SAXSession;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.AbstractObjectPathNode;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.ClassNameNode;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.LocalNameSpacePathNode;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LocalClassPathNode
extends AbstractObjectPathNode {
    private boolean iHasLocalNameSpacePath;
    private boolean iHasClassName;
    private String iNameSpaceStr;
    private String iClassNameStr;
    private CIMObjectPath iLocalPath;

    public LocalClassPathNode() {
        super("LOCALCLASSPATH");
    }

    @Override
    public void init(Attributes pAttribs, SAXSession pSession) {
        this.iLocalPath = pSession.getDefLocalPath();
        this.iHasClassName = false;
        this.iHasLocalNameSpacePath = false;
        this.iClassNameStr = null;
        this.iNameSpaceStr = null;
    }

    @Override
    public void parseData(String pData) {
    }

    @Override
    public void testChild(String pNodeNameEnum) throws SAXException {
        if (pNodeNameEnum == "LOCALNAMESPACEPATH") {
            if (this.iHasLocalNameSpacePath) {
                throw new SAXException("LOCALCLASSPATH node already has a LOCALNAMESPACEPATH child node!");
            }
        } else if (pNodeNameEnum == "CLASSNAME") {
            if (this.iHasClassName) {
                throw new SAXException("LOCALCLASSPATH node already has a CLASSNAME child node!");
            }
        } else {
            throw new SAXException("LOCALCLASSPATH node cannot have " + pNodeNameEnum + " child node! It can have LOCALNAMESPACEPATH and CLASSNAME child nodes only!");
        }
    }

    @Override
    public void childParsed(Node pChild) {
        if (pChild instanceof LocalNameSpacePathNode) {
            this.iNameSpaceStr = ((LocalNameSpacePathNode)pChild).getNameSpace();
            this.iHasLocalNameSpacePath = true;
        } else {
            this.iClassNameStr = ((ClassNameNode)pChild).getClassName();
            this.iHasClassName = true;
        }
    }

    @Override
    public void testCompletness() throws SAXException {
        if (!this.iHasLocalNameSpacePath) {
            throw new SAXException("LOCALNAMESPACE child node is mandatory for LOCALCLASSPATH node!");
        }
        if (!this.iHasClassName) {
            throw new SAXException("CLASSNAME child node is mandatory for LOCALCLASSPATH node!");
        }
    }

    @Override
    public CIMObjectPath getCIMObjectPath() {
        return LocalPathBuilder.build(this.iLocalPath, this.iClassNameStr, this.iNameSpaceStr);
    }
}

