/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node;

import org.sentrysoftware.wbem.javax.cim.CIMObjectPath;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.SAXSession;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.AbstractPathNode;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.NameSpaceNode;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.Node;
import org.sentrysoftware.wbem.sblim.cimclient.internal.util.WBEMConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LocalNameSpacePathNode
extends AbstractPathNode {
    private StringBuffer iNameSpaceStrBuf;
    private String iNameSpaceStr;
    private CIMObjectPath iNameSpacePath;
    private CIMObjectPath iLocalPath;

    public LocalNameSpacePathNode() {
        super("LOCALNAMESPACEPATH");
    }

    @Override
    public void init(Attributes pAttribs, SAXSession pSession) {
        this.iLocalPath = pSession.getDefLocalPath();
        this.iNameSpaceStrBuf = null;
        this.iNameSpaceStr = null;
        this.iNameSpacePath = null;
    }

    @Override
    public void parseData(String pData) {
    }

    @Override
    public void testChild(String pNodeNameEnum) throws SAXException {
        if (pNodeNameEnum != "NAMESPACE") {
            throw new SAXException(this.getNodeName() + " node can have NAMESPACE child node only! " + pNodeNameEnum + " child node is invalid!");
        }
    }

    @Override
    public void childParsed(Node pChild) {
        String nsStr = ((NameSpaceNode)pChild).getNameSpace();
        if (this.iNameSpaceStrBuf == null) {
            this.iNameSpaceStrBuf = new StringBuffer(nsStr);
        } else {
            this.iNameSpaceStrBuf.append('/' + nsStr);
        }
    }

    @Override
    public void testCompletness() throws SAXException {
        if (this.iNameSpaceStrBuf == null) {
            if (WBEMConfiguration.getGlobalConfiguration().allowEmptyLocalNameSpacePath() && this.iLocalPath != null && this.iLocalPath.getNamespace() != null) {
                return;
            }
            throw new SAXException(this.getNodeName() + " node must have at least one NAMESPACE child node!");
        }
    }

    public String getNameSpace() {
        if (this.iNameSpaceStr != null) {
            return this.iNameSpaceStr;
        }
        this.iNameSpaceStr = this.iNameSpaceStrBuf == null ? this.iLocalPath.getNamespace() : this.iNameSpaceStrBuf.toString();
        return this.iNameSpaceStr;
    }

    @Override
    public CIMObjectPath getCIMObjectPath() {
        if (this.iNameSpacePath != null) {
            return this.iNameSpacePath;
        }
        this.iNameSpacePath = new CIMObjectPath(null, null, null, this.getNameSpace(), null, null);
        return this.iNameSpacePath;
    }
}

