/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.http;

import java.net.PasswordAuthentication;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.Challenge;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.PegasusLocalAuthInfo;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.WwwAuthInfo;
import org.sentrysoftware.wbem.sblim.cimclient.internal.logging.LogAndTraceBroker;

public abstract class AuthorizationInfo {
    protected String iAddr;
    protected int iPort;
    protected String iProtocol;
    protected String iRealm;
    protected String iScheme;
    protected PasswordAuthentication iCredentials;
    protected long iNc = 1L;
    protected String iCnonce;
    protected String iOpaque;
    protected String iAlgorithm;
    protected String iUri;
    protected String iNonce;
    protected String iQop;
    protected String iA1;
    protected String iResponse;

    public void init(Boolean pProxy, String pAddress, int pPort, String pProtocol, String pRealm, String pScheme) {
        this.iAddr = pAddress;
        this.iPort = pPort;
        this.iProtocol = pProtocol;
        this.iRealm = pRealm;
        this.iScheme = pScheme;
    }

    public void setOpaque(String opaque) {
        this.iOpaque = opaque;
    }

    public String getOpaque() {
        return this.iOpaque;
    }

    public String getQop() {
        return this.iQop;
    }

    public void setQop(String qop) {
        this.iQop = qop;
    }

    public long getNc() {
        return this.iNc;
    }

    public void setNc(long nc) {
        this.iNc = nc;
    }

    public void setNonce(String nonce) {
        this.iNonce = nonce;
    }

    public String getNonce() {
        return this.iNonce;
    }

    public void setCnonce(String cnonce) {
        this.iCnonce = cnonce;
    }

    public String getCnonce() {
        return this.iCnonce;
    }

    public void setAlgorithm(String algorithm) {
        this.iAlgorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.iAlgorithm;
    }

    public String getA1() {
        return this.iA1;
    }

    public void setA1(String A1) {
        this.iA1 = A1;
    }

    public void setResponse(String response) {
        this.iResponse = response;
    }

    public String getResponse() {
        return this.iResponse;
    }

    public String getURI() {
        return this.iUri;
    }

    public void setURI(String uri) {
        this.iUri = uri;
    }

    public void setCredentials(PasswordAuthentication credentials) {
        this.iCredentials = credentials;
    }

    public String getAddr() {
        return this.iAddr;
    }

    public int getPort() {
        return this.iPort;
    }

    public String getProtocol() {
        return this.iProtocol;
    }

    public String getRealm() {
        return this.iRealm;
    }

    public void setRealm(String realm) {
        this.iRealm = realm;
    }

    public String getScheme() {
        return this.iScheme;
    }

    public void setScheme(String scheme) {
        this.iScheme = scheme;
    }

    public PasswordAuthentication getCredentials() {
        return this.iCredentials;
    }

    public boolean match(Object obj) {
        boolean prot;
        if (obj == null || !(obj instanceof AuthorizationInfo)) {
            return false;
        }
        AuthorizationInfo that = (AuthorizationInfo)obj;
        boolean type = this.getClass().equals(that.getClass());
        boolean prmpt = this.iRealm == null || that.iRealm == null ? true : this.iRealm.equals(that.iRealm);
        boolean schm = this.iScheme == null || that.iScheme == null ? true : this.iScheme.equals(that.iScheme);
        boolean adr = this.iAddr == null || that.iAddr == null ? true : this.iAddr.equals(that.iAddr);
        boolean bl = prot = this.iProtocol == null || that.iProtocol == null ? true : this.iProtocol.equals(that.iProtocol);
        boolean prt = this.iPort <= 0 || that.iPort <= 0 ? true : this.iPort == that.iPort;
        return type && prmpt && schm && adr && prot && prt;
    }

    public abstract void updateAuthenticationInfo(Challenge var1, String var2, URI var3, String var4) throws NoSuchAlgorithmException;

    public abstract String toString();

    public abstract String getHeaderFieldName();

    public abstract boolean isSentOnFirstRequest();

    public abstract boolean isKeptAlive();

    public static AuthorizationInfo createAuthorizationInfo(String pModule, Boolean pProxy, String pAddress, int pPort, String pProtocol, String pRealm, String pScheme) {
        AuthorizationInfo info = AuthorizationInfo.createAuthorizationInfo(pModule);
        if (info != null) {
            info.init(pProxy, pAddress, pPort, pProtocol, pRealm, pScheme);
        }
        return info;
    }

    public static AuthorizationInfo createAuthorizationInfo(String pModule) {
        if (WwwAuthInfo.class.getName().equals(pModule)) {
            return new WwwAuthInfo();
        }
        if (PegasusLocalAuthInfo.class.getName().equals(pModule)) {
            return new PegasusLocalAuthInfo();
        }
        try {
            Class<?> module = Class.forName(pModule);
            AuthorizationInfo info = (AuthorizationInfo)module.newInstance();
            return info;
        }
        catch (Exception e) {
            LogAndTraceBroker.getBroker().trace(Level.FINER, "Exception while loading authentication module", e);
            LogAndTraceBroker.getBroker().message("CIM2004S", pModule);
            return null;
        }
    }
}

