/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import javax.net.SocketFactory;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.AuthorizationHandler;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.AuthorizationInfo;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.Challenge;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpClientMethod;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpClientPool;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpHeader;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpParseException;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpSocketFactory;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.io.ASCIIPrintStream;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.io.KeepAliveInputStream;
import org.sentrysoftware.wbem.sblim.cimclient.internal.logging.LogAndTraceBroker;

public class HttpClient
implements HandshakeCompletedListener {
    private static String iEncoding;
    private boolean iConnected = false;
    private HttpClientPool iHttpClientPool;
    private AuthorizationHandler iAuth_handler;
    private SSLSession iSession;
    private InputStream iIStream;
    private boolean iUseHttp11 = true;
    private boolean iKeepAlive = true;
    private HttpClientMethod iMethod;
    private OutputStream iOStream;
    private AuthorizationInfo iPrevAuthInfo;
    private AuthorizationInfo iPrevProxy;
    private HttpHeader iRequestHeaders = new HttpHeader();
    private String iRequestMethod = "POST";
    private boolean iReset = true;
    private HttpClientMethod iResponse;
    private HttpHeader iResponseHeaders = new HttpHeader();
    private InputStream iServerInput;
    private ByteArrayOutputStream iServerOutput;
    private Socket iSocket;
    private URI iUrl;
    private long iPreviousResponseTime = -1L;

    public static String convertToHexString(byte[] digest) {
        char[] hexDigit = "0123456789abcdef".toCharArray();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            byte b = digest[i];
            buf.append(hexDigit[b >> 4 & 0xF]);
            buf.append(hexDigit[b & 0xF]);
        }
        return buf.toString();
    }

    public static HttpClient getClient(URI url, HttpClientPool clientPool, AuthorizationHandler auth_handler) {
        return clientPool.retrieveAvailableConnectionFromPool(url, auth_handler);
    }

    protected static String dequote(String str) {
        int len = str.length();
        if (len > 1 && str.charAt(0) == '\"' && str.charAt(len - 1) == '\"') {
            return str.substring(1, len - 1);
        }
        return str;
    }

    protected static void handleRsp(String authInfo, AuthorizationInfo prevAuthInfo) throws IOException {
        if (authInfo != null) {
            HttpHeader params = HttpHeader.parse(authInfo);
            String nonce = params.getField("nextnonce");
            if (nonce != null) {
                prevAuthInfo.setNonce(nonce);
                prevAuthInfo.setNc(0L);
            } else {
                nonce = prevAuthInfo.getNonce();
            }
            String qop = params.getField("qop");
            if (qop != null) {
                if (!"auth".equalsIgnoreCase(qop) && !"auth-int".equalsIgnoreCase(qop)) {
                    throw new IOException("Authentication Digest with integrity check not supported");
                }
                String rspauthStr = HttpClient.dequote(params.getField("rspauth"));
                if (rspauthStr != null) {
                    byte[] rspauth = HttpClient.parseHex(rspauthStr);
                    String cnonce = HttpClient.dequote(params.getField("cnonce"));
                    if (cnonce != null && !cnonce.equals(prevAuthInfo.getCnonce())) {
                        throw new IOException("Digest authentication: Invalid nonce counter");
                    }
                    String ncStr = params.getField("nc");
                    if (ncStr != null) {
                        try {
                            long nc = Long.parseLong(ncStr, 16);
                            if (nc != prevAuthInfo.getNc()) {
                                throw new IOException();
                            }
                        }
                        catch (Exception e) {
                            throw new IOException("Digest authentication: Invalid nonce counter");
                        }
                    }
                    try {
                        MessageDigest md5 = MessageDigest.getInstance("MD5");
                        md5.reset();
                        byte[] bytes = prevAuthInfo.getA1().getBytes("UTF-8");
                        md5.update(bytes);
                        String HA1 = HttpClient.convertToHexString(md5.digest());
                        if ("MD5-sess".equalsIgnoreCase(params.getField("algorithm"))) {
                            md5.reset();
                            md5.update((HA1 + ":" + nonce + ":" + cnonce).getBytes("UTF-8"));
                            HA1 = HttpClient.convertToHexString(md5.digest());
                        }
                        String HA2 = ":" + prevAuthInfo.getURI();
                        if ("auth-int".equalsIgnoreCase(qop)) {
                            md5.reset();
                            md5.update(new byte[0]);
                            HA2 = HA2 + ":" + HttpClient.convertToHexString(md5.digest());
                        }
                        md5.reset();
                        md5.update(HA2.getBytes("UTF-8"));
                        HA2 = HttpClient.convertToHexString(md5.digest());
                        md5.reset();
                        md5.update((HA1 + ":" + nonce + ":" + ncStr + ":" + cnonce + ":" + qop + ":" + HA2).getBytes("UTF-8"));
                        String hsh = HttpClient.convertToHexString(md5.digest());
                        byte[] hash = HttpClient.parseHex(hsh);
                        if (!Arrays.equals(hash, rspauth)) {
                            throw new IOException("Digest Authentication failed!");
                        }
                    }
                    catch (NoSuchAlgorithmException e1) {
                        throw new IOException("Unable to validate Authentication response: NoSuchAlgorithmException");
                    }
                }
            }
        }
    }

    protected static byte[] parseHex(String hex) {
        byte[] value = new byte[hex.length() >> 1];
        int n = 0;
        for (int i = 0; i < value.length; ++i) {
            value[i] = (byte)(0xFF & Integer.parseInt(hex.substring(n, n + 1), 16));
            n += 2;
        }
        return value;
    }

    private static boolean isASCIISuperset(String charset) throws Exception {
        String asciiSuperSet = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!~*'();/?:@&=+$,";
        byte[] abyte0 = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 45, 95, 46, 33, 126, 42, 39, 40, 41, 59, 47, 63, 58, 64, 38, 61, 43, 36, 44};
        byte[] convertedArray = asciiSuperSet.getBytes(charset);
        return Arrays.equals(convertedArray, abyte0);
    }

    public HttpClient(URI url, HttpClientPool clientPool, AuthorizationHandler auth_handler) {
        this.iUrl = url;
        this.iAuth_handler = auth_handler;
        this.iHttpClientPool = clientPool;
    }

    public void connect() throws IOException {
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        try {
            this.iReset = true;
            this.iResponse = null;
            this.iConnected = true;
            this.iServerOutput = null;
            this.resetSocket();
        }
        finally {
            logger.exit();
        }
    }

    public synchronized void disconnect() {
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.iConnected = false;
        if (this.iSocket != null) {
            try {
                this.iSocket.close();
            }
            catch (IOException e) {
                logger.trace(Level.FINE, "Unexpected problem closing http socket", e);
            }
            this.iSocket = null;
            this.iServerInput = null;
            this.iReset = true;
            this.iResponse = null;
        }
        logger.exit();
    }

    protected void finalize() throws Throwable {
        try {
            this.iSocket.close();
        }
        catch (IOException iOException) {
        }
        finally {
            super.finalize();
        }
    }

    public synchronized String getHeaderFieldValue(int index) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (index == 0) {
            return this.iResponse.toString();
        }
        Iterator<Map.Entry<HttpHeader.HeaderEntry, String>> iterator = this.iResponseHeaders.iterator();
        while (iterator.hasNext() && --index >= 0) {
            Map.Entry<HttpHeader.HeaderEntry, String> entry = iterator.next();
            if (index != 0) continue;
            return entry.getValue().toString();
        }
        return null;
    }

    public synchronized String getHeaderField(String name) {
        return this.iResponseHeaders.getField(name);
    }

    public synchronized String getHeaderFieldName(int index) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (index == 0) {
            return null;
        }
        Iterator<Map.Entry<HttpHeader.HeaderEntry, String>> iterator = this.iResponseHeaders.iterator();
        while (iterator.hasNext() && --index >= 0) {
            Map.Entry<HttpHeader.HeaderEntry, String> entry = iterator.next();
            if (index != 0) continue;
            return entry.getKey().toString();
        }
        return null;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.getResponseCode() < 500 && this.iResponse != null && this.iServerInput != null) {
            return this.iServerInput;
        }
        throw new IOException("Failed to open an input stream from server: HTTPResponse " + this.getResponseCode());
    }

    public synchronized OutputStream getOutputStream() {
        if (this.iServerOutput == null) {
            this.iServerOutput = new ByteArrayOutputStream();
        }
        return this.iServerOutput;
    }

    public String getRequestMethod() {
        return this.iRequestMethod;
    }

    public String getRequestProperty(String key) {
        return this.iRequestHeaders.getField(key);
    }

    /*
     * Exception decompiling
     */
    public synchronized int getResponseCode() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 0[TRYBLOCK]], but top level block is 11[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getResponseMessage() {
        if (this.iResponse != null) {
            return this.iResponse.getResponseMessage();
        }
        return null;
    }

    @Override
    public void handshakeCompleted(HandshakeCompletedEvent event) {
        LogAndTraceBroker.getBroker().trace(Level.FINER, "Http handshake completed.");
        this.iSession = event.getSession();
    }

    public void reset() {
        this.iRequestHeaders.clear();
        this.iResponseHeaders.clear();
        this.iResponse = null;
        this.iReset = true;
    }

    public void setRequestMethod(String method) {
        this.iRequestMethod = method;
    }

    public void setRequestProperty(String key, String value) {
        this.iRequestHeaders.addField(key, value);
    }

    public void streamFinished() {
        this.streamFinished(true);
    }

    public void streamFinished(boolean keep) {
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        HostPortPair hpp = new HostPortPair(this.iUrl);
        if (keep) {
            logger.trace(Level.FINER, "Adding http client to pool (" + hpp + ")");
            this.iHttpClientPool.returnAvailableConnectionToPool(this);
        } else {
            logger.trace(Level.FINER, "Disconnectiong http client (" + hpp + ")");
            this.iHttpClientPool.removeConnectionFromPool(this);
            this.disconnect();
        }
        logger.exit();
    }

    public void useHttp11(boolean bool) {
        this.iUseHttp11 = bool;
    }

    public boolean usingProxy() {
        return false;
    }

    protected AuthorizationInfo getAuthentication(boolean proxy, AuthorizationInfo prevAuthInfo, String authenticate) throws HttpParseException, NoSuchAlgorithmException {
        Challenge[] challenges = Challenge.parseChallenge(authenticate);
        prevAuthInfo = null;
        for (int cntr = 0; cntr < challenges.length; ++cntr) {
            Challenge challenge = challenges[cntr];
            prevAuthInfo = this.iAuth_handler.getAuthorizationInfo(this.iHttpClientPool.getConfigurationContext().getHttpAuthenticationModule(), proxy ? Boolean.TRUE : Boolean.FALSE, this.iUrl.getHost(), this.iUrl.getPort(), this.iUrl.getScheme(), challenge.getRealm(), challenge.getScheme());
            if (prevAuthInfo == null) continue;
            prevAuthInfo.updateAuthenticationInfo(challenge, authenticate, this.iUrl, this.iRequestMethod);
            return prevAuthInfo;
        }
        return null;
    }

    private void closeConnection() {
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        if (this.iSocket != null) {
            try {
                this.iSocket.close();
            }
            catch (IOException e) {
                logger.trace(Level.FINER, "Exception while closing the socket", e);
            }
            this.iSocket = null;
            this.iServerInput = null;
        }
        logger.exit();
    }

    private String[] parseProperty(String propertyName) {
        String[] as;
        String s = (String)AccessController.doPrivileged(new GetProperty(propertyName));
        if (s == null || s.length() == 0) {
            as = null;
        } else {
            Vector<Object> vector = new Vector<Object>();
            StringTokenizer stringtokenizer = new StringTokenizer(s, ",");
            while (stringtokenizer.hasMoreElements()) {
                vector.addElement(stringtokenizer.nextElement());
            }
            as = new String[vector.size()];
            for (int i1 = 0; i1 < as.length; ++i1) {
                as[i1] = (String)vector.elementAt(i1);
            }
        }
        return as;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetSocket() throws IOException {
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        if (!this.iKeepAlive) {
            logger.trace(Level.FINER, "KeepAlive=false, closing http connection...");
            this.closeConnection();
        }
        int httpTimeout = this.iHttpClientPool.getConfigurationContext().getHttpTimeout();
        logger.trace(Level.FINER, "Setting http timeout=" + httpTimeout);
        if (this.iSocket == null) {
            SocketFactory factory;
            SecurityManager sm;
            boolean socketConnectWithTimeout = this.iHttpClientPool.getConfigurationContext().socketConnectWithTimeout();
            logger.trace(Level.FINER, "Socket=null, creating http socket " + (socketConnectWithTimeout ? "with" : "without") + " timeout.");
            if (!socketConnectWithTimeout && (sm = System.getSecurityManager()) != null) {
                sm.checkConnect(this.iUrl.getHost(), this.iUrl.getPort());
            }
            if ((factory = this.iHttpClientPool.getConfigurationContext().getCustomSocketFactory()) == null && (factory = HttpSocketFactory.getInstance().getClientSocketFactory("HTTPS".equalsIgnoreCase(this.iUrl.getScheme()) ? this.iHttpClientPool.getSslContext() : null)) == null) {
                logger.message("CIM2003S", this.iUrl.getScheme());
                throw new IllegalStateException("Unable to load socket factory:" + this.iUrl.getScheme());
            }
            logger.trace(Level.FINER, "Creating new http for url " + this.iUrl.toString());
            if (socketConnectWithTimeout) {
                int connectTimeout = this.iHttpClientPool.getConfigurationContext().getSocketConnectTimeout();
                logger.trace(Level.FINER, "Setting socket connect timeout=" + connectTimeout);
                if (factory instanceof SSLSocketFactory) {
                    Socket sock = new Socket();
                    sock.connect(new InetSocketAddress(this.iUrl.getHost(), this.iUrl.getPort()), connectTimeout);
                    this.iSocket = ((SSLSocketFactory)factory).createSocket(sock, this.iUrl.getHost(), this.iUrl.getPort(), true);
                } else {
                    this.iSocket = factory.createSocket();
                    if (this.iSocket != null) {
                        this.iSocket.connect(new InetSocketAddress(this.iUrl.getHost(), this.iUrl.getPort()), connectTimeout);
                    }
                }
            } else {
                this.iSocket = factory.createSocket(this.iUrl.getHost(), this.iUrl.getPort());
            }
            if (this.iSocket == null) {
                logger.trace(Level.WARNING, "Socket factory " + factory.getClass().getName() + " returned null socket");
                throw new IOException("Socket factory did not create socket");
            }
            this.iPreviousResponseTime = -1L;
            this.iSocket.setTcpNoDelay(true);
            this.iSocket.setKeepAlive(true);
            this.iSocket.setSoTimeout(httpTimeout);
            if (this.iSocket instanceof SSLSocket) {
                boolean performHandshake = this.iHttpClientPool.getConfigurationContext().performSslHandshake();
                logger.trace(Level.FINER, "SSL socket created, handshake " + (performHandshake ? "will" : "will not") + " be performed.");
                if (performHandshake) {
                    String disableCipherSuites;
                    String[] ciphersuites;
                    SSLSocket sk = (SSLSocket)this.iSocket;
                    String[] protocols = this.parseProperty("https.protocols");
                    if (protocols != null) {
                        logger.trace(Level.FINER, "Setting SSLSocket.setEnabledProtocols() from \"https.protocols\"=" + String.valueOf(Arrays.asList(protocols)));
                        sk.setEnabledProtocols(protocols);
                    }
                    if ((ciphersuites = this.parseProperty("https.cipherSuites")) != null) {
                        logger.trace(Level.FINER, "Setting SSLSocket.setEnableCipheSuites() from \"https.cipherSuites\"=" + String.valueOf(Arrays.asList(ciphersuites)));
                        sk.setEnabledCipherSuites(ciphersuites);
                    }
                    if ((disableCipherSuites = this.iHttpClientPool.getConfigurationContext().getSslClientCipherSuitesToDisable()) != null) {
                        sk.setEnabledCipherSuites(this.iHttpClientPool.getUpdatedCipherSuites(sk.getEnabledCipherSuites(), disableCipherSuites));
                    }
                    boolean synchronizedHandshake = this.iHttpClientPool.getConfigurationContext().synchronizedSslHandshake();
                    logger.trace(Level.FINER, "Starting " + (synchronizedHandshake ? "synchronized" : "unsynchronized") + " http handshake.");
                    sk.addHandshakeCompletedListener(this);
                    if (synchronizedHandshake) {
                        Class<SSLSocket> clazz = SSLSocket.class;
                        synchronized (SSLSocket.class) {
                            sk.startHandshake();
                            // ** MonitorExit[var11_13] (shouldn't be in output)
                        }
                    } else {
                        sk.startHandshake();
                    }
                }
            }
            {
                this.iIStream = new BufferedInputStream(this.iSocket.getInputStream());
                this.iOStream = new ASCIIPrintStream(new BufferedOutputStream(this.iSocket.getOutputStream(), 1024), false, iEncoding);
                this.iServerInput = null;
            }
        } else {
            if (this.iServerInput != null && !(this.iServerInput instanceof KeepAliveInputStream)) {
                long total;
                logger.trace(Level.FINER, "Socket!=null, flushing the stream...");
                long totalBytes = 0L;
                while ((total = (long)this.iServerInput.available()) > 0L) {
                    if ((total = this.iServerInput.skip(total)) < 0L) continue;
                    totalBytes += total;
                }
                logger.trace(Level.FINER, "total bytes on the stream=" + totalBytes);
            }
            this.iSocket.setSoTimeout(httpTimeout);
        }
    }

    public boolean isConnected() {
        return this.iConnected;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append('[');
        result.append("URI=");
        result.append(this.iUrl);
        result.append(", ");
        result.append(this.iConnected ? "connected" : "not connected");
        result.append(", ");
        result.append(this.iKeepAlive ? "kept alive" : "not kept alive");
        result.append(", ");
        result.append(this.iUseHttp11 ? "HTTP 1.1" : "HTTP 1.0");
        result.append(", ");
        result.append("Method=");
        result.append(this.iMethod);
        result.append(", ");
        result.append("Request Method=");
        result.append(this.iRequestMethod);
        result.append(", ");
        result.append("Protocol=");
        result.append(this.iSession != null ? this.iSession.getProtocol() : "http");
        result.append(", ");
        result.append("CipherSuite=");
        result.append(this.iSession != null ? this.iSession.getCipherSuite() : "n/a");
        result.append(']');
        return result.toString();
    }

    static {
        try {
            iEncoding = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return System.getProperty("file.encoding", "ISO8859_1");
                }
            });
            if (!HttpClient.isASCIISuperset(iEncoding)) {
                iEncoding = "ISO8859_1";
            }
        }
        catch (Exception exception) {
            iEncoding = "ISO8859_1";
        }
    }

    private static class HostPortPair {
        String iHost;

        public HostPortPair(URI url) {
            this.iHost = url.getScheme().toLowerCase() + ':' + url.getHost().toLowerCase() + ':' + url.getPort();
        }

        public boolean equals(Object o) {
            if (!(o instanceof HostPortPair)) {
                return false;
            }
            return this.iHost.equals(((HostPortPair)o).iHost);
        }

        public int hashCode() {
            return this.iHost.hashCode();
        }

        public String toString() {
            return "HostPortPair=[+" + this.iHost + "]";
        }
    }

    private static class GetProperty
    implements PrivilegedAction<Object> {
        String iPropertyName;

        GetProperty(String propertyName) {
            this.iPropertyName = propertyName;
        }

        @Override
        public Object run() {
            return System.getProperty(this.iPropertyName);
        }
    }
}

