/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.http;

import java.util.Vector;

public class HttpHeaderParser {
    String iRaw;
    Vector<String[]> iNameValuePair;

    public HttpHeaderParser(String pHeader) {
        this.iRaw = pHeader;
        this.iNameValuePair = new Vector();
        if (this.iRaw != null) {
            this.iRaw = this.iRaw.trim();
            char[] charArray = this.iRaw.toCharArray();
            int startPosValue = 0;
            int currentPos = 0;
            boolean isName = true;
            boolean withinQuote = false;
            int len = charArray.length;
            String[] nvp = new String[2];
            do {
                char c;
                if ((c = charArray[currentPos]) == '=') {
                    nvp[0] = new String(charArray, startPosValue, currentPos - startPosValue).toLowerCase();
                    isName = false;
                    startPosValue = ++currentPos;
                    continue;
                }
                if (c == '\"') {
                    if (withinQuote) {
                        nvp[1] = new String(charArray, startPosValue, currentPos - startPosValue);
                        this.iNameValuePair.add(nvp);
                        nvp = new String[2];
                        withinQuote = false;
                        while (++currentPos < len && (charArray[currentPos] == ' ' || charArray[currentPos] == ',' || charArray[currentPos] == ';')) {
                        }
                        isName = true;
                        startPosValue = currentPos;
                        continue;
                    }
                    withinQuote = true;
                    startPosValue = ++currentPos;
                    continue;
                }
                if (c == ' ' || c == ',' || c == ';') {
                    if (withinQuote) {
                        ++currentPos;
                        continue;
                    }
                    if (isName) {
                        nvp[0] = new String(charArray, startPosValue, currentPos - startPosValue).toLowerCase();
                        this.iNameValuePair.add(nvp);
                        nvp = new String[2];
                    } else {
                        nvp[1] = new String(charArray, startPosValue, currentPos - startPosValue);
                        this.iNameValuePair.add(nvp);
                        nvp = new String[2];
                    }
                    while (++currentPos < len && (charArray[currentPos] == ' ' || charArray[currentPos] == ',' || charArray[currentPos] == ';')) {
                    }
                    isName = true;
                    startPosValue = currentPos;
                    continue;
                }
                ++currentPos;
            } while (currentPos < len);
            if (--currentPos > startPosValue) {
                if (!isName) {
                    if (charArray[currentPos] == '\"') {
                        nvp[1] = new String(charArray, startPosValue, currentPos - startPosValue);
                        this.iNameValuePair.add(nvp);
                        nvp = new String[2];
                    } else {
                        nvp[1] = new String(charArray, startPosValue, currentPos - startPosValue + 1);
                        this.iNameValuePair.add(nvp);
                        nvp = new String[2];
                    }
                } else {
                    nvp[0] = new String(charArray, startPosValue, currentPos - startPosValue + 1).toLowerCase();
                }
                this.iNameValuePair.add(nvp);
            } else if (currentPos == startPosValue) {
                if (!isName) {
                    if (charArray[currentPos] == '\"') {
                        nvp[1] = String.valueOf(charArray[currentPos - 1]);
                        this.iNameValuePair.add(nvp);
                        nvp = new String[2];
                    } else {
                        nvp[1] = String.valueOf(charArray[currentPos]);
                        this.iNameValuePair.add(nvp);
                        nvp = new String[2];
                    }
                } else {
                    nvp[0] = String.valueOf(charArray[currentPos]).toLowerCase();
                }
                this.iNameValuePair.add(nvp);
            }
        }
    }

    public String getField(int pIndex) {
        if (pIndex < 0 || pIndex > this.iNameValuePair.size()) {
            return null;
        }
        return this.iNameValuePair.elementAt(pIndex)[0];
    }

    public String getValue(int pIndex) {
        if (pIndex < 0 || pIndex > this.iNameValuePair.size()) {
            return null;
        }
        return this.iNameValuePair.elementAt(pIndex)[1];
    }

    public String getValue(String pName) {
        return this.getValue(pName, null);
    }

    public String getValue(String pName, String pDefault) {
        if (pName == null) {
            return pDefault;
        }
        pName = pName.toLowerCase();
        for (int i = 0; i < this.iNameValuePair.size(); ++i) {
            if (this.iNameValuePair.elementAt(i)[0] == null) {
                return pDefault;
            }
            if (!pName.equals(this.iNameValuePair.elementAt(i)[0])) continue;
            return this.iNameValuePair.elementAt(i)[1];
        }
        return pDefault;
    }

    public int getIntValue(String pName, int pDefault) {
        try {
            return Integer.parseInt(this.getValue(pName, String.valueOf(pDefault)));
        }
        catch (Exception e) {
            return pDefault;
        }
    }

    public String toString() {
        return "raw:" + this.iRaw;
    }
}

