/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpException;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpHeader;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpHeaderParser;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpServerMethod;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.io.BoundedInputStream;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.io.ChunkedInputStream;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.io.PersistentInputStream;
import org.sentrysoftware.wbem.sblim.cimclient.internal.logging.LogAndTraceBroker;

public class MessageReader {
    HttpHeader iHeader;
    HttpServerMethod iMethod;
    private boolean iChunked = false;
    private String iEncoding = "UTF-8";
    InputStream iContent;

    public MessageReader(InputStream pStream, int pTimeout) throws IOException, HttpException {
        String contentType;
        this.iMethod = new HttpServerMethod(pStream);
        this.iHeader = new HttpHeader(pStream, pTimeout);
        String encoding = this.iHeader.getField("Transfer-Encoding");
        if (encoding != null && encoding.toLowerCase().endsWith("chunked")) {
            this.iChunked = true;
        }
        String length = this.iHeader.getField("Content-Length");
        int contentLength = -1;
        if (length != null && length.length() > 0) {
            try {
                contentLength = Integer.parseInt(length);
            }
            catch (Exception e) {
                LogAndTraceBroker.getBroker().trace(Level.FINER, "Exception while parsing http content-length", e);
            }
        }
        if ((contentType = this.iHeader.getField("Content-Type")) != null) {
            try {
                HttpHeaderParser contentTypeHeader = new HttpHeaderParser(contentType);
                encoding = contentTypeHeader.getValue("charset");
            }
            catch (Exception e) {
                encoding = "UTF-8";
                LogAndTraceBroker.getBroker().trace(Level.FINER, "Exception while parsing http content-type", e);
            }
            this.iEncoding = encoding;
        }
        this.iContent = new PersistentInputStream(pStream, this.isPersistentConnectionSupported());
        if (this.iChunked) {
            this.iContent = new ChunkedInputStream(this.iContent, this.iHeader.getField("Trailer"), "Indication Request");
        } else if (contentLength >= 0) {
            this.iContent = new BoundedInputStream(this.iContent, contentLength);
        }
    }

    public String getCharacterEncoding() {
        return this.iEncoding;
    }

    public HttpHeader getHeader() {
        return this.iHeader;
    }

    public HttpServerMethod getMethod() {
        return this.iMethod;
    }

    public InputStream getInputStream() {
        return this.iContent;
    }

    public boolean isPersistentConnectionSupported() {
        String conn = this.iHeader.getField("Connection");
        if (conn != null) {
            if (conn.equalsIgnoreCase("close")) {
                return false;
            }
            if (conn.equalsIgnoreCase("Keep-Alive")) {
                return true;
            }
        }
        return this.iMethod.getMajorVersion() >= 1 && this.iMethod.getMinorVersion() >= 1;
    }

    public boolean isChunkSupported() {
        String TE;
        return this.iMethod.getMajorVersion() >= 1 && this.iMethod.getMinorVersion() >= 1 && (TE = this.iHeader.getField("TE")) != null && TE.equalsIgnoreCase("trailers");
    }

    public void close() throws IOException {
        this.iContent.close();
    }
}

