/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpHeader;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpServerMethod;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.io.ASCIIPrintStream;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.io.ChunkedOutputStream;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.io.PersistentOutputStream;
import org.sentrysoftware.wbem.sblim.cimclient.internal.logging.LogAndTraceBroker;

public class MessageWriter {
    HttpHeader iHeader = null;
    HttpServerMethod iMethod = null;
    HttpHeader iTrailer = null;
    boolean iChunked = false;
    boolean iPersistent = false;
    ASCIIPrintStream iRealOS;
    ASCIIPrintStream iClientOS;
    ByteArrayOutputStream iBufferedOS;

    public MessageWriter(OutputStream pStream, boolean pPersistent, boolean pChunked) {
        this.iRealOS = new ASCIIPrintStream(pStream);
        this.iChunked = pChunked;
        this.iPersistent = pPersistent;
        this.iBufferedOS = new ByteArrayOutputStream();
        this.iClientOS = pChunked ? new ASCIIPrintStream(new ChunkedOutputStream(new PersistentOutputStream(this.iBufferedOS, pPersistent), 512)) : new ASCIIPrintStream(new PersistentOutputStream(this.iBufferedOS, pPersistent));
        this.iHeader = new HttpHeader();
        this.iMethod = new HttpServerMethod(1, 1, 200, "OK");
    }

    public void reset() {
        this.iBufferedOS.reset();
    }

    public void setHeader(HttpHeader header) {
        this.iHeader = header;
    }

    public void setMethod(HttpServerMethod method) {
        this.iMethod = method;
    }

    public HttpHeader getHeader() {
        return this.iHeader;
    }

    public HttpServerMethod getMethod() {
        return this.iMethod;
    }

    public ASCIIPrintStream getOutputStream() {
        return this.iClientOS;
    }

    public void close() throws IOException {
        this.iMethod.write(this.iRealOS);
        this.iRealOS.flush();
        if (!this.iChunked) {
            this.iHeader.removeField("Transfer-Encoding");
        } else {
            this.iHeader.addField("Transfer-Encoding", "chunked");
        }
        if (this.iPersistent) {
            this.iHeader.addField("Connection", "Keep-iAlive");
        } else {
            this.iHeader.addField("Connection", "close");
        }
        this.iHeader.addField("Content-Type", "application/xml;charset=\"utf-8\"");
        if (!this.iChunked) {
            this.iHeader.addField("Content-length", Integer.toString(this.iBufferedOS.size()));
        }
        LogAndTraceBroker.getBroker().trace(Level.FINER, "Indication Response HTTP Headers= " + this.iHeader.toString());
        this.iHeader.write(this.iRealOS);
        this.iRealOS.flush();
        if (this.iChunked) {
            this.iClientOS.close();
        }
        this.iBufferedOS.writeTo(this.iRealOS);
        if (this.iChunked && this.iTrailer != null) {
            LogAndTraceBroker.getBroker().trace(Level.FINER, "Indication Response HTTP Trailer Headers= " + this.iTrailer.toString());
            this.iTrailer.write(this.iRealOS);
        }
        this.iRealOS.flush();
    }

    public void setTrailer(HttpHeader pTrailer) {
        this.iTrailer = pTrailer;
    }
}

