/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.logging;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;

public final class MessageLoader {
    private static final String BUNDLE_NAME = "org.sblim.cimclient.internal.logging.messages";
    private static final ResourceBundle RESOURCE_BUNDLE_LOCAL;
    private static final ResourceBundle RESOURCE_BUNDLE;

    private MessageLoader() {
    }

    public static String getMessage(String pKey) {
        try {
            return RESOURCE_BUNDLE.getString(pKey);
        }
        catch (MissingResourceException e) {
            return '!' + pKey + '!';
        }
    }

    public static String getLocalizedMessage(String pKey) {
        try {
            return RESOURCE_BUNDLE_LOCAL.getString(pKey);
        }
        catch (MissingResourceException e) {
            return '!' + pKey + '!';
        }
    }

    public static Level getLevel(String pKey) {
        char level = pKey.charAt(pKey.length() - 1);
        switch (level) {
            case 'S': {
                return Level.SEVERE;
            }
            case 'W': {
                return Level.WARNING;
            }
            case 'I': {
                return Level.INFO;
            }
            case 'C': {
                return Level.CONFIG;
            }
        }
        return null;
    }

    static {
        ResourceBundle bundleLocal;
        RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME, Locale.ENGLISH);
        try {
            bundleLocal = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
        }
        catch (MissingResourceException e) {
            bundleLocal = RESOURCE_BUNDLE;
        }
        RESOURCE_BUNDLE_LOCAL = bundleLocal;
    }
}

