/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.sentrysoftware.wbem.sblim.cimclient.internal.logging.TimeStamp;

public class TraceFormatter
extends Formatter {
    private final String iLineSeparator = System.getProperty("line.separator");

    @Override
    public String format(LogRecord pRecord) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(TimeStamp.format(pRecord.getMillis()));
        buffer.append(" >");
        buffer.append(String.valueOf(pRecord.getThreadID()));
        buffer.append("< ");
        buffer.append(pRecord.getSourceMethodName());
        buffer.append(this.iLineSeparator);
        buffer.append(pRecord.getLevel().getName());
        buffer.append(": ");
        buffer.append(pRecord.getMessage());
        buffer.append(this.iLineSeparator);
        if (pRecord.getThrown() != null) {
            buffer.append("---> ");
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            pRecord.getThrown().printStackTrace(printWriter);
            printWriter.close();
            buffer.append(stringWriter.toString());
            buffer.append(this.iLineSeparator);
        }
        return buffer.toString();
    }
}

