/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.uri;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sentrysoftware.wbem.sblim.cimclient.internal.uri.QuotedValue;
import org.sentrysoftware.wbem.sblim.cimclient.internal.uri.URIString;
import org.sentrysoftware.wbem.sblim.cimclient.internal.uri.Value;

public class CharValue
extends Value
implements QuotedValue {
    private char iChar;
    private static final Pattern pat = Pattern.compile("\\\\x([0-9a-fA-F]+)");

    public static Value parse(URIString pUriStr, boolean pThrow) throws IllegalArgumentException {
        URIString uriStr = pUriStr.deepCopy();
        if (!uriStr.cutStarting('\'')) {
            if (pThrow) {
                String msg = "Starting \"'\" is not found!\n" + uriStr.markPosition();
                throw new IllegalArgumentException(msg);
            }
            return null;
        }
        String charStr = uriStr.removeTill('\'', true);
        if (charStr == null) {
            if (pThrow) {
                String msg = "Closing \"'\" is not found!\n" + uriStr.markPosition();
                throw new IllegalArgumentException(msg);
            }
            return null;
        }
        if (uriStr.length() != 0 && uriStr.charAt(0) != ',') {
            if (pThrow) {
                String msg = "Character should be ',' or end of string!\n" + uriStr.markPosition();
                throw new IllegalArgumentException(msg);
            }
            return null;
        }
        if (charStr.length() < 1) {
            if (pThrow) {
                String msg = "Empty character is unparseable!\n" + uriStr.markPosition();
                throw new IllegalArgumentException(msg);
            }
            return null;
        }
        if (charStr.length() == 1) {
            pUriStr.set(uriStr);
            return new CharValue(charStr.charAt(0));
        }
        Matcher m = pat.matcher(charStr);
        if (!m.matches()) {
            if (pThrow) {
                String msg = "Unparseable character string!\n" + uriStr.markPosition();
                throw new IllegalArgumentException(msg);
            }
            return null;
        }
        String hexStr = m.group(1);
        int charCode = Integer.parseInt(hexStr, 16);
        pUriStr.set(uriStr);
        return new CharValue((char)charCode);
    }

    public static Value parse(URIString pUriStr) {
        return CharValue.parse(pUriStr, false);
    }

    private CharValue(char pChar) {
        this.iChar = pChar;
    }

    public char get() {
        return this.iChar;
    }

    public Character getCharacter() {
        return Character.valueOf(this.iChar);
    }

    public String toString() {
        if (this.iChar < ' ') {
            return "\\x" + this.iChar;
        }
        return Character.toString(this.iChar);
    }

    @Override
    public String toQuotedString() {
        return "'" + this.toString() + '\'';
    }

    @Override
    public String getTypeInfo() {
        return "char16";
    }
}

