/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.uri;

import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sentrysoftware.wbem.sblim.cimclient.internal.uri.URIString;
import org.sentrysoftware.wbem.sblim.cimclient.internal.uri.Value;

public class IntegerValue
extends Value {
    private BigInteger iBigValue;
    private boolean iTyped;
    private int iBitWidth;
    private boolean iSigned;
    private static final Pattern BIN_PAT = Pattern.compile("^((?:\\+|-)?[01]+)[bB]$");
    private static final Pattern OCT_PAT = Pattern.compile("^(?:\\+|-)?0[0-7]+$");
    private static final Pattern DEC_PAT = Pattern.compile("^(?:\\+|-)?[1-9][0-9]*$");
    private static final Pattern HEX_PAT = Pattern.compile("^(\\+|-)?0[xX]([0-9a-fA-F]+)$");

    private static Value parse(URIString pUriStr, boolean pTyped, boolean pSigned, int pBitWidth, boolean pThrow) throws IllegalArgumentException {
        URIString savedUriStr = pUriStr.deepCopy();
        String valStr = pUriStr.removeTill(',');
        if (valStr == null) {
            pUriStr.set(savedUriStr);
            if (pThrow) {
                String msg = "Empty value!\n" + pUriStr.markPosition();
                pUriStr.set(savedUriStr);
                throw new IllegalArgumentException(msg);
            }
            return null;
        }
        if (valStr.compareTo("0") == 0) {
            return IntegerValue.make(valStr, 10, pTyped, pSigned, pBitWidth);
        }
        Matcher m = DEC_PAT.matcher(valStr);
        if (m.matches()) {
            IntegerValue val = IntegerValue.make(valStr, 10, pTyped, pSigned, pBitWidth);
            if (val != null) {
                return val;
            }
            pUriStr.set(savedUriStr);
            if (pThrow) {
                String msg = "Failed to parse decimal value!\n" + pUriStr.markPosition();
                throw new IllegalArgumentException(msg);
            }
            return null;
        }
        m = HEX_PAT.matcher(valStr);
        if (m.matches()) {
            String sign = m.group(1);
            String str = sign == null ? m.group(2) : sign + m.group(2);
            IntegerValue val = IntegerValue.make(str, 16, pTyped, pSigned, pBitWidth);
            if (val != null) {
                return val;
            }
            pUriStr.set(savedUriStr);
            if (pThrow) {
                String msg = "Failed to parse hexadecimal value!\n" + pUriStr.markPosition();
                throw new IllegalArgumentException(msg);
            }
            return null;
        }
        m = OCT_PAT.matcher(valStr);
        if (m.matches()) {
            IntegerValue val = IntegerValue.make(valStr, 8, pTyped, pSigned, pBitWidth);
            if (val != null) {
                return val;
            }
            pUriStr.set(savedUriStr);
            if (pThrow) {
                String msg = "Failed to parse octal value!\n" + pUriStr.markPosition();
                throw new IllegalArgumentException(msg);
            }
            return null;
        }
        m = BIN_PAT.matcher(valStr);
        if (m.matches()) {
            IntegerValue val = IntegerValue.make(m.group(1), 2, pTyped, pSigned, pBitWidth);
            if (val != null) {
                return val;
            }
            pUriStr.set(savedUriStr);
            if (pThrow) {
                String msg = "Failed to parse binary value!\n" + pUriStr.markPosition();
                throw new IllegalArgumentException(msg);
            }
            return null;
        }
        pUriStr.set(savedUriStr);
        if (pThrow) {
            String msg = "Failed to parse integer value!\n" + pUriStr.markPosition();
            throw new IllegalArgumentException(msg);
        }
        return null;
    }

    public static Value parse(URIString pUriStr) {
        return IntegerValue.parse(pUriStr, false, false, 0, false);
    }

    public static Value parseUnsigned(URIString pUriStr, int pBitWidth) throws IllegalArgumentException {
        return IntegerValue.parse(pUriStr, true, false, pBitWidth, true);
    }

    public static Value parseSigned(URIString pUriStr, int pBitWidth) throws IllegalArgumentException {
        return IntegerValue.parse(pUriStr, true, true, pBitWidth, true);
    }

    private IntegerValue(String pStrVal, int pRadix, boolean pTyped, boolean pSigned, int pBitWidth) {
        this.iBigValue = new BigInteger(pStrVal, pRadix);
        this.iTyped = pTyped;
        this.iSigned = pSigned;
        this.iBitWidth = pBitWidth;
    }

    private static IntegerValue make(String pStrVal, int pRadix, boolean pTyped, boolean pSigned, int pBitWidth) {
        IntegerValue val = new IntegerValue(pStrVal, pRadix, pTyped, pSigned, pBitWidth);
        if (pTyped) {
            if (!pSigned && val.isNegative()) {
                return null;
            }
            if (val.bitLength() > val.getBitWidth()) {
                return null;
            }
        }
        return val;
    }

    public byte byteValue() {
        return this.iBigValue.byteValue();
    }

    public short shortValue() {
        return this.iBigValue.shortValue();
    }

    public int intValue() {
        return this.iBigValue.intValue();
    }

    public long longValue() {
        return this.iBigValue.longValue();
    }

    public BigInteger bigIntValue() {
        return this.iBigValue;
    }

    public boolean isNegative() {
        return this.iBigValue.compareTo(BigInteger.ZERO) < 0;
    }

    public boolean isSigned() {
        if (this.iTyped) {
            return this.iSigned;
        }
        return this.isNegative();
    }

    public int bitLength() {
        int len = this.iBigValue.bitLength();
        if (this.isSigned()) {
            ++len;
        }
        return len;
    }

    public int getBitWidth() {
        if (this.iTyped) {
            return this.iBitWidth;
        }
        int rawWidth = this.bitLength();
        if (rawWidth <= 8) {
            return 8;
        }
        if (rawWidth <= 16) {
            return 16;
        }
        if (rawWidth <= 32) {
            return 32;
        }
        return 64;
    }

    public String toString() {
        return this.iBigValue.toString();
    }

    @Override
    public String getTypeInfo() {
        return this.isSigned() ? "sint" : "uint" + this.getBitWidth();
    }
}

