/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.util;

import java.util.Comparator;
import java.util.TreeMap;
import org.sentrysoftware.wbem.javax.cim.CIMClass;
import org.sentrysoftware.wbem.javax.cim.CIMDataType;
import org.sentrysoftware.wbem.javax.cim.CIMDateTime;
import org.sentrysoftware.wbem.javax.cim.CIMElement;
import org.sentrysoftware.wbem.javax.cim.CIMInstance;
import org.sentrysoftware.wbem.javax.cim.CIMMethod;
import org.sentrysoftware.wbem.javax.cim.CIMObjectPath;
import org.sentrysoftware.wbem.javax.cim.CIMParameter;
import org.sentrysoftware.wbem.javax.cim.CIMProperty;
import org.sentrysoftware.wbem.javax.cim.CIMQualifiedElementInterface;
import org.sentrysoftware.wbem.javax.cim.CIMQualifier;
import org.sentrysoftware.wbem.javax.cim.CIMQualifierType;
import org.sentrysoftware.wbem.javax.cim.CIMTypedElement;
import org.sentrysoftware.wbem.javax.cim.CIMValuedElement;
import org.sentrysoftware.wbem.sblim.cimclient.internal.util.Util;

public class MOF {
    public static final String CLASS = "class";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String NULL = "null";
    public static final String ENABLEOVERRIDE = "enableoverride";
    public static final String DISABLEOVERRIDE = "disableOverride";
    public static final String RESTRICTED = "restricted";
    public static final String TOSUBCLASS = "tosubclass";
    public static final String TRANSLATABLE = "translatable";
    public static final String DT_BOOL = "boolean";
    public static final String DT_CHAR16 = "char16";
    public static final String DT_DATETIME = "datetime";
    public static final String DT_REAL32 = "real32";
    public static final String DT_REAL64 = "real64";
    public static final String DT_SINT16 = "sint16";
    public static final String DT_SINT32 = "sint32";
    public static final String DT_SINT64 = "sint64";
    public static final String DT_SINT8 = "sint8";
    public static final String DT_STR = "string";
    public static final String DT_UINT16 = "uint16";
    public static final String DT_UINT32 = "uint32";
    public static final String DT_UINT64 = "uint64";
    public static final String DT_UINT8 = "uint8";
    public static final String INVALID = "invalid";
    public static final String REF = "ref";
    public static final String INSTOF = "instance of ";
    public static final String QUALIFIER = "qualifier";
    public static final String SCOPE = "scope";
    public static final String ANY = "any";
    public static final String ASSOCIATION = "association";
    public static final String INDICATION = "indication";
    public static final String METHOD = "method";
    public static final String PARAMETER = "parameter";
    public static final String PROPERTY = "property";
    public static final String REFERENCE = "reference";
    public static final String INSTANCE = "instance";
    public static final String NAMESPACE = "namespace";
    public static final String INDENT = "  ";
    public static final String EMPTY = "";
    public static final int DEF_FLAVOR = 0;
    private static final TreeMap<CIMDataType, String> DATATYPE_MAP = new TreeMap(new Comparator<Object>(){

        @Override
        public int compare(Object pO1, Object pO2) {
            CIMDataType t1 = (CIMDataType)pO1;
            CIMDataType t2 = (CIMDataType)pO2;
            return t1.getType() - t2.getType();
        }
    });

    public static String classDeclaration(CIMClass pCl, String pInd) {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append(MOF.qualifierList(pCl, pInd));
        buf.append("class " + pCl.getName() + ' ');
        String supCl = pCl.getSuperClassName();
        if (supCl != null) {
            buf.append(':' + supCl + ' ');
        }
        buf.append("{\n");
        for (i = 0; i < pCl.getPropertyCount(); ++i) {
            buf.append(MOF.propertyDeclaration(pCl.getProperty(i), pInd + INDENT));
        }
        for (i = 0; i < pCl.getMethodCount(); ++i) {
            buf.append(MOF.methodDeclaration(pCl.getMethod(i), pInd + INDENT));
        }
        buf.append("};");
        return buf.toString();
    }

    public static String instanceDeclaration(CIMInstance pInst, String pInd) {
        StringBuffer buf = new StringBuffer();
        buf.append(pInd + INSTOF + pInst.getClassName() + " {\n");
        for (int i = 0; i < pInst.getPropertyCount(); ++i) {
            buf.append(MOF.valueInitializer(pInst.getProperty(i), pInd + INDENT));
        }
        CIMProperty<?>[] keys = pInst.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            if (pInst.getProperty(keys[i].getName()) != null) continue;
            buf.append(MOF.valueInitializer(keys[i], pInd + INDENT));
        }
        buf.append(pInd + "};");
        return buf.toString();
    }

    public static String methodDeclaration(CIMMethod<?> pMethod, String pInd) {
        StringBuffer buf = new StringBuffer();
        buf.append(MOF.qualifierList(pMethod, pInd));
        buf.append(pInd + MOF.dataType(pMethod) + ' ' + pMethod.getName() + '(');
        if (pMethod.getParameters().length > 0) {
            buf.append('\n');
            buf.append(MOF.parameterList(pMethod, pInd + INDENT) + '\n' + pInd);
        }
        buf.append(");\n");
        return buf.toString();
    }

    public static String parameter(CIMParameter<?> pParam, String pInd) {
        return MOF.typedElement(pParam, pInd);
    }

    public static String typedElement(CIMTypedElement pTypedElement, String pInd) {
        return MOF.qualifierList(pTypedElement, pInd) + pInd + MOF.dataType(pTypedElement) + ' ' + pTypedElement.getName() + MOF.array(pTypedElement);
    }

    public static String valuedElement(CIMValuedElement<?> pValuedElement, String pInd) {
        StringBuffer buf = new StringBuffer(MOF.typedElement(pValuedElement, pInd));
        if (pValuedElement.getValue() != null) {
            buf.append(MOF.defaultValue(pValuedElement, pInd));
        }
        buf.append(';');
        return buf.toString();
    }

    public static String qualifierList(CIMElement pElement, String pInd) {
        if (!(pElement instanceof CIMQualifiedElementInterface)) {
            return EMPTY;
        }
        CIMQualifiedElementInterface qualified = (CIMQualifiedElementInterface)((Object)pElement);
        if (qualified.getQualifierCount() == 0) {
            return EMPTY;
        }
        StringBuffer buf = new StringBuffer(pInd + '[');
        for (int i = 0; i < qualified.getQualifierCount(); ++i) {
            if (i > 0) {
                buf.append(",\n" + pInd);
            }
            buf.append(MOF.qualifier(qualified.getQualifier(i)));
        }
        buf.append("]\n");
        return buf.toString();
    }

    public static String qualifierDeclaration(CIMQualifierType<?> pQType) {
        return "qualifier " + pQType.getName() + ' ' + MOF.dataType(pQType) + ' ' + MOF.scope(pQType.getScope()) + ' ' + MOF.flavor(pQType.getFlavor()) + ';';
    }

    public static String scope(int pScopes) {
        ScopeBuffer buf = new ScopeBuffer(pScopes);
        buf.append("scope(");
        if (pScopes == 127) {
            buf.append(ANY);
        } else {
            buf.append(2, ASSOCIATION);
            buf.append(1, CLASS);
            buf.append(4, INDICATION);
            buf.append(32, METHOD);
            buf.append(64, PARAMETER);
            buf.append(8, PROPERTY);
            buf.append(16, REFERENCE);
        }
        buf.append(')');
        return buf.toString();
    }

    public static String flavor(int flavor) {
        StringBuffer buf = new StringBuffer();
        buf.append((flavor & 1) > 0 ? DISABLEOVERRIDE : ENABLEOVERRIDE);
        buf.append(' ' + ((flavor & 2) > 0 ? RESTRICTED : TOSUBCLASS));
        if ((flavor & 4) > 0) {
            buf.append(" translatable");
        }
        return buf.toString();
    }

    public static String qualifier(CIMQualifier<?> pQuali) {
        StringBuffer buf = new StringBuffer();
        buf.append(pQuali.getName());
        if (pQuali.getDataType() != null && pQuali.getValue() != null) {
            buf.append(MOF.qualifierParameter(pQuali));
        }
        buf.append(':' + MOF.flavor(pQuali.getFlavor()));
        return buf.toString();
    }

    public static String propertyDeclaration(CIMProperty<?> pProp, String pInd) {
        return MOF.valuedElement(pProp, pInd) + '\n';
    }

    public static String valueInitializer(CIMProperty<?> pProp, String pInd) {
        Object value = pProp.getValue();
        if (value != null) {
            return MOF.qualifierList(pProp, pInd) + pInd + pProp.getName() + " = " + MOF.initializer(value, pInd) + ";\n";
        }
        return EMPTY;
    }

    public static String dataType(CIMDataType pType) {
        if (pType.getType() == 14) {
            return pType.getRefClassName() + ' ' + REF;
        }
        String res = DATATYPE_MAP.get(pType);
        if (res == null) {
            String msg = "This function cannot handle typeCode: " + pType.getType() + "!";
            throw new IllegalArgumentException(msg);
        }
        return res;
    }

    public static String dataType(CIMTypedElement pTypedElement) {
        return MOF.dataType(pTypedElement.getDataType());
    }

    public static String objectHandle(CIMObjectPath pPath) {
        return MOF.objectHandle(pPath, false, false);
    }

    public static String objectHandle(CIMObjectPath pPath, boolean pTyped, boolean pLocal) {
        StringBuffer buf = new StringBuffer();
        if (!pLocal) {
            if (pPath.getScheme() != null) {
                buf.append(pPath.getScheme() + ':');
            }
            if (pPath.getHost() != null) {
                buf.append("//" + pPath.getHost());
            }
            if (pPath.getPort() != null) {
                buf.append(':' + pPath.getPort());
            }
        }
        if (pPath.getNamespace() != null) {
            if (!pLocal) {
                buf.append('/');
            }
            buf.append(pPath.getNamespace());
        }
        if (pTyped) {
            buf.append(MOF.pathType(pPath));
        } else if (pPath.getObjectName() != null && buf.length() > 0) {
            buf.append(':');
        }
        if (pPath.getObjectName() != null) {
            buf.append(pPath.getObjectName() + MOF.keyValuePairs(pPath.getKeys(), pTyped, EMPTY));
        }
        return buf.toString();
    }

    public static String objectHandleAsRef(CIMObjectPath pPath) {
        return MOF.objectHandleAsRef(pPath, false);
    }

    public static String objectHandleAsRef(CIMObjectPath pPath, boolean pTyped) {
        StringBuffer buf = new StringBuffer();
        if (pPath.getNamespace() != null) {
            buf.append(pPath.getNamespace());
        }
        if (pTyped) {
            buf.append(MOF.pathType(pPath));
        }
        if (pPath.getObjectName() != null) {
            if (!pTyped && pPath.getNamespace() != null) {
                buf.append(':');
            }
            buf.append(pPath.getObjectName());
            buf.append(MOF.keyValuePairs(pPath.getKeys(), pTyped, EMPTY));
        }
        return buf.toString();
    }

    public static String constantValue(CIMValuedElement<?> pValuedElement, String pInd) {
        return MOF.constantValue(pValuedElement.getValue(), pInd);
    }

    public static String constantValue(Object pObj, boolean pTyped, String pInd) {
        String valStr = pObj == null ? NULL : (pObj instanceof CIMObjectPath ? Util.quote(MOF.objectHandleAsRef((CIMObjectPath)pObj, pTyped)) : (pObj instanceof String ? Util.quote(pObj.toString()) : (pObj instanceof CIMDateTime ? Util.quote(pObj.toString()) : (pObj instanceof Character ? MOF.charValue((Character)pObj) : (pObj instanceof Boolean ? ((Boolean)pObj != false ? TRUE : FALSE) : (pObj instanceof CIMInstance ? '\n' + MOF.instanceDeclaration((CIMInstance)pObj, pInd) + '\n' : (pObj instanceof CIMClass ? '\n' + MOF.classDeclaration((CIMClass)pObj, pInd) + '\n' + pInd : pObj.toString())))))));
        if (pTyped) {
            String typeStr;
            if (pObj instanceof CIMObjectPath) {
                typeStr = REFERENCE;
            } else {
                CIMDataType type = CIMDataType.getDataType(pObj);
                typeStr = MOF.dataType(type);
            }
            return "(" + typeStr + ")" + valStr;
        }
        return valStr;
    }

    public static String constantValue(Object pObj, String pInd) {
        return MOF.constantValue(pObj, false, pInd);
    }

    private static String pathType(CIMObjectPath pPath) {
        String typeInfo = pPath.getKeys().length > 0 ? INSTANCE : (pPath.getObjectName() != null ? CLASS : NAMESPACE);
        return "/(" + typeInfo + ")";
    }

    private static String keyValuePairs(CIMProperty<?>[] pKeys, boolean pTyped, String pInd) {
        StringBuffer buf = new StringBuffer();
        if (pKeys != null && pKeys.length > 0) {
            buf.append('.');
            for (int i = 0; i < pKeys.length; ++i) {
                CIMProperty<?> key = pKeys[i];
                if (i != 0) {
                    buf.append(',');
                }
                buf.append(key.getName() + '=' + MOF.constantValue(key.getValue(), pTyped, pInd));
            }
        }
        return buf.toString();
    }

    private static String parameterList(CIMMethod<?> pMethod, String pInd) {
        StringBuffer buf = new StringBuffer();
        CIMParameter<?>[] params = pMethod.getParameters();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                buf.append(",\n");
            }
            buf.append(MOF.parameter(params[i], pInd));
        }
        return buf.toString();
    }

    private static String qualifierParameter(CIMQualifier<?> pQuali) {
        return pQuali.getDataType().isArray() ? MOF.arrayInitializer(pQuali, EMPTY) : '(' + MOF.constantValue(pQuali, EMPTY) + ')';
    }

    private static String charValue(Character pChar) {
        char ch = pChar.charValue();
        if (ch < ' ') {
            return "'\\x" + Integer.toString(ch, 16) + '\'';
        }
        return "'" + ch + '\'';
    }

    private static String arrayInitializer(Object pValue, String pInd) {
        if (pValue == null) {
            return EMPTY;
        }
        Object[] vA = (Object[])pValue;
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        for (int i = 0; i < vA.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(MOF.constantValue(vA[i], pInd));
        }
        buf.append('}');
        return buf.toString();
    }

    private static String arrayInitializer(CIMValuedElement<?> pValuedElement, String pInd) {
        return MOF.arrayInitializer(pValuedElement.getValue(), pInd);
    }

    private static String array(CIMDataType pType) {
        if (!pType.isArray()) {
            return EMPTY;
        }
        if (pType.getSize() > 0) {
            return "[" + pType.getSize() + ']';
        }
        return "[]";
    }

    private static String array(CIMTypedElement pTypedElement) {
        return MOF.array(pTypedElement.getDataType());
    }

    private static String defaultValue(CIMValuedElement<?> pValuedElement, String pInd) {
        Object value = pValuedElement.getValue();
        if (value == null) {
            return EMPTY;
        }
        return " = " + MOF.initializer(value, pInd);
    }

    private static String initializer(Object pValue, String pInd) {
        if (pValue instanceof Object[]) {
            return MOF.arrayInitializer(pValue, pInd);
        }
        return MOF.constantValue(pValue, pInd);
    }

    static {
        DATATYPE_MAP.put(CIMDataType.UINT8_T, DT_UINT8);
        DATATYPE_MAP.put(CIMDataType.UINT16_T, DT_UINT16);
        DATATYPE_MAP.put(CIMDataType.UINT32_T, DT_UINT32);
        DATATYPE_MAP.put(CIMDataType.UINT64_T, DT_UINT64);
        DATATYPE_MAP.put(CIMDataType.SINT8_T, DT_SINT8);
        DATATYPE_MAP.put(CIMDataType.SINT16_T, DT_SINT16);
        DATATYPE_MAP.put(CIMDataType.SINT32_T, DT_SINT32);
        DATATYPE_MAP.put(CIMDataType.SINT64_T, DT_SINT64);
        DATATYPE_MAP.put(CIMDataType.REAL32_T, DT_REAL32);
        DATATYPE_MAP.put(CIMDataType.REAL64_T, DT_REAL64);
        DATATYPE_MAP.put(CIMDataType.CHAR16_T, DT_CHAR16);
        DATATYPE_MAP.put(CIMDataType.STRING_T, DT_STR);
        DATATYPE_MAP.put(CIMDataType.BOOLEAN_T, DT_BOOL);
        DATATYPE_MAP.put(CIMDataType.DATETIME_T, DT_DATETIME);
        DATATYPE_MAP.put(CIMDataType.INVALID_T, INVALID);
        DATATYPE_MAP.put(CIMDataType.OBJECT_T, "object");
        DATATYPE_MAP.put(CIMDataType.CLASS_T, CLASS);
    }

    private static class ScopeBuffer {
        private StringBuffer buf = new StringBuffer();
        private int iScopes;
        private int iCnt = 0;

        public ScopeBuffer(int pScopes) {
            this.iScopes = pScopes;
        }

        public void append(String pStr) {
            this.buf.append(pStr);
        }

        public void append(char pChar) {
            this.buf.append(pChar);
        }

        public void append(int pMask, String pName) {
            if ((this.iScopes & pMask) > 0) {
                if (this.iCnt++ > 0) {
                    this.buf.append(',');
                }
                this.buf.append(pName);
            }
        }

        public String toString() {
            return this.buf.toString();
        }
    }
}

