/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.wbem.indications;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.sentrysoftware.wbem.javax.cim.CIMDataType;
import org.sentrysoftware.wbem.javax.cim.CIMInstance;
import org.sentrysoftware.wbem.javax.cim.CIMProperty;
import org.sentrysoftware.wbem.javax.wbem.WBEMException;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.CIMClientXML_HelperImpl;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.CIMRequest;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.CIMXMLBuilderImpl;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.CIMXMLParserImpl;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpContentHandler;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpException;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpHeader;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpHeaderParser;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.MessageReader;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.MessageWriter;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.io.DebugInputStream;
import org.sentrysoftware.wbem.sblim.cimclient.internal.logging.LogAndTraceBroker;
import org.sentrysoftware.wbem.sblim.cimclient.internal.util.WBEMConfiguration;
import org.sentrysoftware.wbem.sblim.cimclient.internal.wbem.CIMError;
import org.sentrysoftware.wbem.sblim.cimclient.internal.wbem.indications.CIMEvent;
import org.sentrysoftware.wbem.sblim.cimclient.internal.wbem.indications.CIMEventDispatcher;
import org.sentrysoftware.wbem.sblim.cimclient.internal.wbem.indications.ReliableIndicationHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class CIMIndicationHandler
extends HttpContentHandler {
    private CIMEventDispatcher iDispatcher = null;
    private int iMessageId = 0;
    private LogAndTraceBroker iLogger = LogAndTraceBroker.getBroker();
    private WBEMConfiguration iSessionProperties;
    private boolean iReliableIndicationsDisabled = true;
    private int iHashtableCapacity = 0;
    private LinkedList<ServerListEntry> iServerList;
    private Hashtable<ServerTableEntry, IndicationServer> iServerTable;
    private String iIndicationTraceClass;
    private String[] iIndicationTraceProperties;
    private boolean iAddSenderIPAddress;
    private DataManager iDataManagerThread;

    public CIMIndicationHandler(CIMEventDispatcher pDispatcher) {
        this(pDispatcher, null);
    }

    public CIMIndicationHandler(CIMEventDispatcher pDispatcher, WBEMConfiguration pProperties) {
        String filter;
        this.iDispatcher = pDispatcher;
        this.iSessionProperties = pProperties != null ? pProperties : WBEMConfiguration.getGlobalConfiguration();
        boolean bl = this.iReliableIndicationsDisabled = !this.iSessionProperties.isReliableIndicationEnabled();
        if (!this.iReliableIndicationsDisabled) {
            this.iHashtableCapacity = this.iSessionProperties.getReliableIndicationHashtableCapacity();
            if (this.iHashtableCapacity < 0 || this.iHashtableCapacity > 25000) {
                this.iLogger.trace(Level.FINE, "ReliableIndicationHashtableCapacity of " + this.iHashtableCapacity + " outside range, using default value");
                this.iHashtableCapacity = Integer.valueOf("0");
            }
            if (this.iHashtableCapacity == 0) {
                this.iServerList = new LinkedList();
                this.iDataManagerThread = new DataManager(this.iServerList);
            } else {
                this.iServerTable = new Hashtable(this.iHashtableCapacity);
                this.iDataManagerThread = new DataManager(this.iServerTable);
            }
            this.iDataManagerThread.start();
        }
        if ((filter = this.iSessionProperties.getListenerIndicationTraceFilter()) != null && filter.trim().length() > 0) {
            String properties;
            int colon = filter.indexOf(58);
            if (colon == -1) {
                this.iIndicationTraceClass = null;
                properties = filter;
            } else {
                this.iIndicationTraceClass = filter.substring(0, colon).trim().toLowerCase();
                properties = filter.substring(colon + 1).trim();
            }
            String[] props = properties.split(",");
            if (props != null && props.length > 0) {
                ArrayList<String> a = new ArrayList<String>();
                for (int i = 0; i < props.length; ++i) {
                    String prop = props[i].trim().toLowerCase();
                    if (prop == null || prop.length() <= 0) continue;
                    a.add(prop);
                }
                if (a.size() > 0) {
                    this.iIndicationTraceProperties = a.toArray(new String[0]);
                    if (this.iLogger.isLoggableTrace(Level.INFO)) {
                        StringBuilder msg = new StringBuilder("Indication trace enabled: class filter=");
                        if (this.iIndicationTraceClass != null) {
                            msg.append("\"");
                            msg.append(this.iIndicationTraceClass);
                            msg.append("\"");
                        } else {
                            msg.append("<none>");
                        }
                        msg.append(", properties=");
                        for (int i = 0; i < this.iIndicationTraceProperties.length; ++i) {
                            if (i > 0) {
                                msg.append(",");
                            }
                            msg.append("\"");
                            msg.append(this.iIndicationTraceProperties[i]);
                            msg.append("\"");
                        }
                        this.iLogger.trace(Level.INFO, msg.toString());
                    }
                } else {
                    this.iIndicationTraceProperties = null;
                }
            }
        }
        this.iAddSenderIPAddress = this.iSessionProperties.getListenerAddSenderIPAddress();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void close() {
        if (this.iDataManagerThread != null) {
            this.iDataManagerThread.stopRun();
            this.iDataManagerThread = null;
        }
        if (this.iDispatcher != null) {
            this.iDispatcher.close();
            this.iDispatcher = null;
        }
    }

    public synchronized int getMsgID() {
        ++this.iMessageId;
        if (this.iMessageId > 1000000) {
            this.iMessageId = 0;
        }
        return this.iMessageId;
    }

    private static HttpHeader processHeader(HttpHeader pHeader, MessageWriter pWriter) throws HttpException {
        HttpHeader header = CIMIndicationHandler.processHttpExtensions(pHeader);
        String cimExport = header.getField("CIMExport");
        String cimOperation = header.getField("CIMOperation");
        if (cimOperation != null && !"METHODCALL".equalsIgnoreCase(cimOperation)) {
            pWriter.getHeader().addField("CIMError", "unsupported-operation");
            throw new HttpException(400, "Bad Request");
        }
        if (cimExport != null && !"METHODREQUEST".equalsIgnoreCase(cimExport) && !"EXPORTMETHODCALL".equalsIgnoreCase(cimExport)) {
            pWriter.getHeader().addField("CIMError", "unsupported-operation");
            throw new HttpException(400, "Bad Request");
        }
        if (cimOperation == null && cimExport == null) {
            pWriter.getHeader().addField("CIMError", "unsupported-operation");
            throw new HttpException(400, "Bad Request");
        }
        return header;
    }

    @Override
    public void handleContent(MessageReader pReader, MessageWriter pWriter, InetAddress pInetAddress, String pLocalAddress) throws HttpException, IOException {
        CIMError error = null;
        HttpHeader inputHeader = pReader.getHeader();
        inputHeader = CIMIndicationHandler.processHeader(inputHeader, pWriter);
        LogAndTraceBroker.getBroker().trace(Level.FINER, "Indication Request HTTP Headers= " + inputHeader.toString());
        String cimMethod = inputHeader.getField("CIMMethod");
        String cimExport = inputHeader.getField("CIMExport");
        CIMRequest request = null;
        CIMClientXML_HelperImpl xmlHelper = null;
        try {
            xmlHelper = new CIMClientXML_HelperImpl();
        }
        catch (ParserConfigurationException e1) {
            IOException e = new IOException("ParserConfigurationException");
            e.initCause(e1);
            throw e;
        }
        InputStream inputstream = null;
        inputstream = this.iSessionProperties.isCimXmlTracingEnabled() && LogAndTraceBroker.getBroker().getXmlTraceStream() != null || LogAndTraceBroker.getBroker().isLoggableCIMXMLTrace(Level.FINEST) ? new DebugInputStream(pReader.getInputStream(), LogAndTraceBroker.getBroker().getXmlTraceStream(), "indication request") : pReader.getInputStream();
        request = this.parseDocument(xmlHelper, pReader, inputstream);
        if (request == null) {
            throw new HttpException(400, "Bad Request");
        }
        if (cimExport == null && !cimMethod.equalsIgnoreCase("Indication") || !request.isCIMExport()) {
            throw new HttpException(400, "Bad Request");
        }
        error = this.dispatchIndications(pReader, pInetAddress, pLocalAddress, request);
        this.buildResponse(xmlHelper, pWriter, request, error);
    }

    private CIMRequest parseDocument(CIMClientXML_HelperImpl xmlHelper, MessageReader pReader, InputStream inputstream) throws HttpException {
        Document doc = null;
        try {
            doc = xmlHelper.parse(new InputSource(new InputStreamReader(inputstream, pReader.getCharacterEncoding())));
            Element rootE = doc.getDocumentElement();
            return (CIMRequest)CIMXMLParserImpl.parseCIM(rootE);
        }
        catch (Exception e) {
            this.iLogger.trace(Level.WARNING, "exception while parsing the XML with DOM parser", e);
            throw new HttpException(400, "Bad Request");
        }
    }

    private IndicationServer getIndicationServerFromList(InetAddress pInetAddress, String pDestinationUrl) {
        ServerListEntry entry2;
        for (ServerListEntry entry2 : this.iServerList) {
            if (!entry2.getInetAddress().equals(pInetAddress) || !entry2.getDestinationUrl().equalsIgnoreCase(pDestinationUrl)) continue;
            return entry2.getIndicationServer();
        }
        entry2 = new ServerListEntry(pInetAddress, pDestinationUrl);
        this.iServerList.add(entry2);
        this.iLogger.trace(Level.FINE, "Creating reliable indication handler for server IP " + entry2.getInetAddress().toString() + ", destination URL " + entry2.getDestinationUrl() + " in linked list");
        return entry2.getIndicationServer();
    }

    private IndicationServer getIndicationServerFromTable(InetAddress pInetAddress, String pDestinationUrl) {
        ServerTableEntry key = new ServerTableEntry(pInetAddress, pDestinationUrl);
        IndicationServer server = this.iServerTable.get(key);
        if (server == null) {
            server = new IndicationServer();
            this.iServerTable.put(key, server);
            this.iLogger.trace(Level.FINE, "Creating reliable indication handler for server IP " + key.getInetAddress().toString() + ", destination URL " + key.getDestinationUrl() + " in hash table");
        }
        return server;
    }

    private synchronized boolean deliverIndication(CIMInstance pIndication, String pId, InetAddress pInetAddress) {
        IndicationServer server = this.iHashtableCapacity == 0 ? this.getIndicationServerFromList(pInetAddress, pId) : this.getIndicationServerFromTable(pInetAddress, pId);
        if (!server.isInitialized()) {
            long interval;
            long attempts = this.iSessionProperties.getListenerDeliveryRetryAttempts();
            if (attempts <= 0L || attempts > 1000L) {
                this.iLogger.trace(Level.FINE, "DeliveryRetryAttempts of " + attempts + " outside range, using default value");
                attempts = Long.valueOf("3");
            }
            if ((interval = this.iSessionProperties.getListenerDeliveryRetryInterval()) <= 0L || interval > 86400L) {
                this.iLogger.trace(Level.FINE, "DeliveryRetryInterval of " + interval + " outside range, using default value");
                interval = Long.valueOf("20");
            }
            server.initialize(new ReliableIndicationHandler(this.iDispatcher, attempts * interval * 10L * 1000L));
            this.iLogger.trace(Level.FINE, "Reliable indication support enabled for IP " + pInetAddress.getHostAddress() + " and URL " + pId + ", DeliveryRetryAttempts=" + attempts + ", DeliveryRetryInterval=" + interval);
        }
        server.getRIHandler().handleIndication(pIndication, pId, pInetAddress);
        return false;
    }

    private CIMError dispatchIndications(MessageReader pReader, InetAddress pInetAddress, String pLocalAddress, CIMRequest request) {
        try {
            Vector<Object> paramValue = request.getParamValue();
            for (Object cimEvent : paramValue) {
                int i;
                if (!(cimEvent instanceof CIMInstance)) continue;
                CIMInstance indicationInst = (CIMInstance)cimEvent;
                String path = pReader.getMethod().getFile();
                String id = path == null ? pLocalAddress + "/" : (path.equalsIgnoreCase("/cimom") ? path : (path.length() < 4 || !path.regionMatches(true, 0, "http", 0, 4) ? (path.startsWith("/") ? pLocalAddress + path : pLocalAddress + "/" + path) : path));
                if (this.iAddSenderIPAddress) {
                    int size = indicationInst.getPropertyCount();
                    CIMProperty[] props = new CIMProperty[size + 1];
                    for (i = 0; i < size; ++i) {
                        props[i] = indicationInst.getProperty(i);
                    }
                    props[size] = new CIMProperty<String>("SBLIMJCC_SenderIPAddress", CIMDataType.STRING_T, pInetAddress.getHostAddress());
                    indicationInst = new CIMInstance(indicationInst.getObjectPath(), props);
                }
                if (this.iIndicationTraceProperties != null && this.iLogger.isLoggableTrace(Level.FINE) && (this.iIndicationTraceClass == null || indicationInst.getClassName().toLowerCase().indexOf(this.iIndicationTraceClass) != -1)) {
                    StringBuilder msg = new StringBuilder("Received indication ");
                    msg.append(indicationInst.getClassName());
                    msg.append(" from IP=");
                    String inet = pInetAddress.getHostAddress();
                    msg.append(inet != null ? inet : "<null>");
                    msg.append(" to URL=");
                    msg.append(id);
                    msg.append(" with properties:");
                    for (i = 0; i < this.iIndicationTraceProperties.length; ++i) {
                        msg.append(" ");
                        CIMProperty<?> prop = indicationInst.getProperty(this.iIndicationTraceProperties[i]);
                        if (prop == null) {
                            msg.append(this.iIndicationTraceProperties[i]);
                            msg.append(" not a property;");
                            continue;
                        }
                        Object value = prop.getValue();
                        if (value == null) {
                            msg.append(prop.getName());
                            msg.append(" = <null>;");
                            continue;
                        }
                        msg.append(prop.toString().trim());
                    }
                    this.iLogger.trace(Level.FINE, msg.toString());
                }
                if (!this.iReliableIndicationsDisabled && !this.deliverIndication(indicationInst, id, pInetAddress)) continue;
                this.iDispatcher.dispatchEvent(new CIMEvent(indicationInst, id, pInetAddress));
            }
            return null;
        }
        catch (Exception e) {
            return new CIMError(new WBEMException(1, "CIM_ERR_FAILED", null, e));
        }
    }

    private void buildResponse(CIMClientXML_HelperImpl xmlHelper, MessageWriter pWriter, CIMRequest request, CIMError error) throws HttpException, IOException {
        Document responseDoc = null;
        try {
            DocumentBuilder docBuilder = xmlHelper.getDocumentBuilder();
            responseDoc = docBuilder.newDocument();
            CIMXMLBuilderImpl.createIndication_response(responseDoc, request.getId(), error);
        }
        catch (Exception e) {
            throw new HttpException(400, "Bad Request");
        }
        if (this.iSessionProperties.isCimXmlTracingEnabled() || this.iLogger.isLoggableCIMXMLTrace(Level.FINEST)) {
            ByteArrayOutputStream pos = new ByteArrayOutputStream();
            CIMClientXML_HelperImpl.dumpDocument(pos, responseDoc, "indication response");
            OutputStream debugStream = this.iLogger.getXmlTraceStream();
            if (this.iSessionProperties.isCimXmlTracingEnabled() && debugStream != null) {
                debugStream.write(((Object)pos).toString().getBytes());
            }
            if (this.iLogger.isLoggableCIMXMLTrace(Level.FINEST)) {
                this.iLogger.traceCIMXML(Level.FINEST, ((Object)pos).toString(), true);
            }
        }
        CIMClientXML_HelperImpl.serialize(pWriter.getOutputStream(), responseDoc);
        pWriter.getHeader().addField("CIMExport", "MethodResponse");
    }

    private static HttpHeader processHttpExtensions(HttpHeader pOriginalHeader) {
        String man = pOriginalHeader.getField("Man");
        String opt = pOriginalHeader.getField("Opt");
        HttpHeader headers = new HttpHeader();
        String ns = null;
        HttpHeaderParser manOptHeader = null;
        if (man != null && man.length() > 0) {
            manOptHeader = new HttpHeaderParser(man);
        } else if (opt != null && opt.length() > 0) {
            manOptHeader = new HttpHeaderParser(opt);
        }
        if (manOptHeader != null) {
            ns = manOptHeader.getValue("ns");
        }
        if (ns != null) {
            Iterator<Map.Entry<HttpHeader.HeaderEntry, String>> iter = pOriginalHeader.iterator();
            while (iter.hasNext()) {
                Map.Entry<HttpHeader.HeaderEntry, String> entry = iter.next();
                if (entry == null) continue;
                String key = entry.getKey().toString();
                if (key.startsWith(ns + "-")) {
                    headers.addParsedField(key.substring(3), entry.getValue().toString());
                    continue;
                }
                headers.addParsedField(key, entry.getValue().toString());
            }
        } else {
            headers = pOriginalHeader;
        }
        return headers;
    }

    private class DataManager
    extends Thread {
        private boolean iAlive = true;
        private LinkedList<ServerListEntry> iLinkedList;
        private Hashtable<ServerTableEntry, IndicationServer> iHashTable;

        public DataManager(LinkedList<ServerListEntry> pServerList) {
            this.iLinkedList = pServerList;
            this.iHashTable = null;
            this.setDaemon(true);
        }

        public DataManager(Hashtable<ServerTableEntry, IndicationServer> pServerTable) {
            this.iLinkedList = null;
            this.iHashTable = pServerTable;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (this.iAlive) {
                try {
                    Set<Map.Entry<ServerTableEntry, IndicationServer>> set;
                    if (this.iLinkedList != null) {
                        for (ServerListEntry throwable : this.iLinkedList) {
                            ReliableIndicationHandler handler;
                            IndicationServer server = throwable.getIndicationServer();
                            if (server == null || (handler = server.getRIHandler()) == null) continue;
                            handler.processAll();
                        }
                    } else if (this.iHashTable != null && (set = this.iHashTable.entrySet()) != null) {
                        for (Map.Entry entry : set) {
                            ReliableIndicationHandler handler;
                            IndicationServer server = (IndicationServer)entry.getValue();
                            if (server == null || (handler = server.getRIHandler()) == null) continue;
                            handler.processAll();
                        }
                    }
                    DataManager.sleep(1000L);
                }
                catch (Throwable throwable) {}
            }
        }

        public void stopRun() {
            this.iAlive = false;
        }
    }

    private class ServerListEntry {
        private InetAddress iInetAddress;
        private String iDestinationUrl;
        private IndicationServer iIndicationServer;

        public ServerListEntry(InetAddress pInetAddress, String pDestinationUrl) {
            this.iInetAddress = pInetAddress;
            this.iDestinationUrl = pDestinationUrl;
            this.iIndicationServer = new IndicationServer();
        }

        public InetAddress getInetAddress() {
            return this.iInetAddress;
        }

        public String getDestinationUrl() {
            return this.iDestinationUrl;
        }

        public IndicationServer getIndicationServer() {
            return this.iIndicationServer;
        }
    }

    private class IndicationServer {
        private boolean iRIInitialized = false;
        private ReliableIndicationHandler iRIHandler;

        public void initialize(ReliableIndicationHandler pRIHandler) {
            this.iRIInitialized = true;
            this.iRIHandler = pRIHandler;
        }

        public boolean isInitialized() {
            return this.iRIInitialized;
        }

        public ReliableIndicationHandler getRIHandler() {
            return this.iRIHandler;
        }
    }

    private class ServerTableEntry {
        private InetAddress iInetAddress;
        private String iDestinationUrl;

        public ServerTableEntry(InetAddress pInetAddress, String pDestinationUrl) {
            this.iInetAddress = pInetAddress;
            this.iDestinationUrl = pDestinationUrl;
        }

        public InetAddress getInetAddress() {
            return this.iInetAddress;
        }

        public String getDestinationUrl() {
            return this.iDestinationUrl;
        }

        public boolean equals(Object pObj) {
            if (!(pObj instanceof ServerTableEntry)) {
                return false;
            }
            ServerTableEntry that = (ServerTableEntry)pObj;
            return this.iInetAddress.equals(that.getInetAddress()) && this.iDestinationUrl.equalsIgnoreCase(that.getDestinationUrl());
        }

        public int hashCode() {
            return this.iInetAddress.hashCode() ^ this.iDestinationUrl.hashCode();
        }
    }
}

